/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.spi.balancer.BalancerEnvironment;
import org.apache.accumulo.core.spi.balancer.TabletBalancer;
import org.apache.accumulo.core.spi.balancer.data.TServerStatus;
import org.apache.accumulo.core.spi.balancer.data.TableStatistics;
import org.apache.accumulo.core.spi.balancer.data.TabletMigration;
import org.apache.accumulo.core.spi.balancer.data.TabletServerId;
import org.apache.accumulo.core.spi.balancer.data.TabletStatistics;
import org.apache.accumulo.core.spi.balancer.util.ThrottledBalancerProblemReporter;
import org.apache.accumulo.harness.AccumuloITBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChaoticLoadBalancer
implements TabletBalancer {
    private static final Logger log = LoggerFactory.getLogger(ChaoticLoadBalancer.class);
    protected BalancerEnvironment environment;
    private final ThrottledBalancerProblemReporter problemReporter = new ThrottledBalancerProblemReporter(this.getClass());
    private final ThrottledBalancerProblemReporter.OutstandingMigrationsProblem outstandingMigrationsProblem = this.problemReporter.createOutstandingMigrationsProblem();

    public void init(BalancerEnvironment balancerEnvironment) {
        this.environment = balancerEnvironment;
    }

    public void getAssignments(TabletBalancer.AssignmentParameters params) {
        long total = params.unassignedTablets().size();
        long avg = (long)Math.ceil((double)total / (double)params.currentStatus().size());
        HashMap<TabletServerId, Long> toAssign = new HashMap<TabletServerId, Long>();
        ArrayList<TabletServerId> tServerArray = new ArrayList<TabletServerId>();
        for (Map.Entry e : params.currentStatus().entrySet()) {
            long numTablets = 0L;
            for (TableStatistics ti : ((TServerStatus)e.getValue()).getTableMap().values()) {
                numTablets += (long)ti.getTabletCount();
            }
            if (numTablets > avg) continue;
            tServerArray.add((TabletServerId)e.getKey());
            toAssign.put((TabletServerId)e.getKey(), avg - numTablets);
        }
        if (tServerArray.isEmpty()) {
            return;
        }
        for (TabletId tabletId : params.unassignedTablets().keySet()) {
            int index = AccumuloITBase.random.nextInt(tServerArray.size());
            TabletServerId dest = (TabletServerId)tServerArray.get(index);
            params.addAssignment(tabletId, dest);
            long remaining = (Long)toAssign.get(dest) - 1L;
            if (remaining == 0L) {
                tServerArray.remove(index);
                toAssign.remove(dest);
                continue;
            }
            toAssign.put(dest, remaining);
        }
    }

    public long balance(TabletBalancer.BalanceParameters params) {
        HashMap<TabletServerId, Long> numTablets = new HashMap<TabletServerId, Long>();
        ArrayList<Object> underCapacityTServer = new ArrayList<Object>();
        if (!params.currentMigrations().isEmpty()) {
            this.outstandingMigrationsProblem.setMigrations(params.currentMigrations());
            this.problemReporter.reportProblem((ThrottledBalancerProblemReporter.Problem)this.outstandingMigrationsProblem);
            return 100L;
        }
        this.problemReporter.clearProblemReportTimes();
        boolean moveMetadata = AccumuloITBase.random.nextInt(4) == 0;
        long totalTablets = 0L;
        for (Map.Entry e : params.currentStatus().entrySet()) {
            long tabletCount = 0L;
            for (TableStatistics ti : ((TServerStatus)e.getValue()).getTableMap().values()) {
                tabletCount += (long)ti.getTabletCount();
            }
            numTablets.put((TabletServerId)e.getKey(), tabletCount);
            underCapacityTServer.add((TabletServerId)e.getKey());
            totalTablets += tabletCount;
        }
        long avg = (long)Math.ceil((double)totalTablets / (double)params.currentStatus().size() * 1.2);
        for (Map.Entry e : params.currentStatus().entrySet()) {
            for (String tableId : ((TServerStatus)e.getValue()).getTableMap().keySet()) {
                TableId id = TableId.of((String)tableId);
                if (!moveMetadata && MetadataTable.ID.equals((Object)id)) continue;
                try {
                    for (TabletStatistics ts : this.getOnlineTabletsForTable((TabletServerId)e.getKey(), id)) {
                        int index = AccumuloITBase.random.nextInt(underCapacityTServer.size());
                        TabletServerId dest = (TabletServerId)underCapacityTServer.get(index);
                        if (dest.equals(e.getKey())) continue;
                        params.migrationsOut().add(new TabletMigration(ts.getTabletId(), (TabletServerId)e.getKey(), dest));
                        if (numTablets.put(dest, (Long)numTablets.get(dest) + 1L) > avg) {
                            underCapacityTServer.remove(index);
                        }
                        if (numTablets.put((TabletServerId)e.getKey(), (Long)numTablets.get(e.getKey()) - 1L) <= avg && !underCapacityTServer.contains(e.getKey())) {
                            underCapacityTServer.add((TabletServerId)e.getKey());
                        }
                        if (!underCapacityTServer.isEmpty()) continue;
                        underCapacityTServer.addAll(numTablets.keySet());
                    }
                }
                catch (AccumuloSecurityException e1) {
                    log.debug("Encountered AccumuloSecurityException.  This should not happen.  Carrying on anyway.", (Throwable)e1);
                }
                catch (AccumuloException e1) {
                    log.debug("Encountered AccumuloException.  This should not happen.  Carrying on anyway.", (Throwable)e1);
                }
            }
        }
        return 100L;
    }

    protected List<TabletStatistics> getOnlineTabletsForTable(TabletServerId tabletServerId, TableId tableId) throws AccumuloException, AccumuloSecurityException {
        return this.environment.listOnlineTabletsForTable(tabletServerId, tableId);
    }
}

