/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterators;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanWalIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(CleanWalIT.class);

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(4L);
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setClientProperty(ClientProperty.INSTANCE_ZOOKEEPERS_TIMEOUT, "15s");
        cfg.setNumTservers(1);
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CleanWalIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            try (BatchWriter bw = client.createBatchWriter(tableName);){
                Mutation m = new Mutation((CharSequence)"row");
                m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
                bw.addMutation(m);
            }
            CleanWalIT.getCluster().getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
            CleanWalIT.getCluster().getClusterControl().startAllServers(ServerType.TABLET_SERVER);
            for (String table : new BatchWriter[]{MetadataTable.NAME, RootTable.NAME}) {
                client.tableOperations().flush(table, null, null, true);
            }
            log.debug("Checking entries for {}", (Object)tableName);
            Assertions.assertEquals((int)1, (int)this.count(tableName, client));
            for (String table : new String[]{MetadataTable.NAME, RootTable.NAME}) {
                log.debug("Checking logs for {}", (Object)table);
                Assertions.assertEquals((int)0, (int)this.countLogs(client), (String)("Found logs for " + table));
            }
            bw = client.createBatchWriter(tableName);
            try {
                Mutation m = new Mutation((CharSequence)"row");
                m.putDelete((CharSequence)"cf", (CharSequence)"cq");
                bw.addMutation(m);
            }
            finally {
                if (bw != null) {
                    bw.close();
                }
            }
            Assertions.assertEquals((int)0, (int)this.count(tableName, client));
            client.tableOperations().flush(tableName, null, null, true);
            client.tableOperations().flush(MetadataTable.NAME, null, null, true);
            client.tableOperations().flush(RootTable.NAME, null, null, true);
            try {
                CleanWalIT.getCluster().getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
                UtilWaitThread.sleepUninterruptibly((long)3L, (TimeUnit)TimeUnit.SECONDS);
            }
            finally {
                CleanWalIT.getCluster().getClusterControl().startAllServers(ServerType.TABLET_SERVER);
            }
            Assertions.assertEquals((int)0, (int)this.count(tableName, client));
        }
    }

    private int countLogs(AccumuloClient client) throws TableNotFoundException {
        int count = 0;
        try (Scanner scanner = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.LogColumnFamily.NAME);
            scanner.setRange(MetadataSchema.TabletsSection.getRange());
            for (Map.Entry entry : scanner) {
                log.debug("Saw {}={}", entry.getKey(), entry.getValue());
                ++count;
            }
        }
        return count;
    }

    int count(String tableName, AccumuloClient client) throws Exception {
        try (Scanner s = client.createScanner(tableName, Authorizations.EMPTY);){
            int n = Iterators.size((Iterator)s.iterator());
            return n;
        }
    }
}

