/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.ClientSideIteratorScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.OfflineScanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Filter;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.user.IntersectingIterator;
import org.apache.accumulo.core.iterators.user.VersioningIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClientSideIteratorIT
extends AccumuloClusterHarness {
    private List<Key> resultSet1;
    private List<Key> resultSet2;
    private List<Key> resultSet3;
    private AccumuloClient client;
    private String tableName;
    private static final AtomicBoolean initCalled = new AtomicBoolean(false);

    @BeforeEach
    public void setupData() {
        this.resultSet1 = new ArrayList<Key>();
        this.resultSet1.add(new Key((CharSequence)"row1", (CharSequence)"colf", (CharSequence)"colq", 4L));
        this.resultSet1.add(new Key((CharSequence)"row1", (CharSequence)"colf", (CharSequence)"colq", 3L));
        this.resultSet2 = new ArrayList<Key>();
        this.resultSet2.add(new Key((CharSequence)"row1", (CharSequence)"colf", (CharSequence)"colq", 4L));
        this.resultSet2.add(new Key((CharSequence)"row1", (CharSequence)"colf", (CharSequence)"colq", 3L));
        this.resultSet2.add(new Key((CharSequence)"row1", (CharSequence)"colf", (CharSequence)"colq", 2L));
        this.resultSet2.add(new Key((CharSequence)"row1", (CharSequence)"colf", (CharSequence)"colq", 1L));
        this.resultSet3 = new ArrayList<Key>();
        this.resultSet3.add(new Key((CharSequence)"part1", (CharSequence)"", (CharSequence)"doc2"));
        this.resultSet3.add(new Key((CharSequence)"part2", (CharSequence)"", (CharSequence)"DOC2"));
    }

    private void checkResults(Iterable<Map.Entry<Key, Value>> scanner, List<Key> results, PartialKey pk) {
        int i = 0;
        for (Map.Entry<Key, Value> entry : scanner) {
            Assertions.assertTrue((boolean)entry.getKey().equals(results.get(i++), pk));
        }
        Assertions.assertEquals((int)i, (int)results.size());
    }

    @BeforeEach
    public void setupInstance() {
        this.client = (AccumuloClient)Accumulo.newClient().from(ClientSideIteratorIT.getClientProps()).build();
        this.tableName = this.getUniqueNames(1)[0];
    }

    @AfterEach
    public void closeClient() {
        this.client.close();
    }

    @Test
    public void testIntersect() throws Exception {
        this.client.tableOperations().create(this.tableName);
        try (BatchWriter bw = this.client.createBatchWriter(this.tableName);){
            Mutation m = new Mutation((CharSequence)"part1");
            m.put((CharSequence)"bar", (CharSequence)"doc1", (CharSequence)"value");
            m.put((CharSequence)"bar", (CharSequence)"doc2", (CharSequence)"value");
            m.put((CharSequence)"dog", (CharSequence)"doc3", (CharSequence)"value");
            m.put((CharSequence)"foo", (CharSequence)"doc2", (CharSequence)"value");
            m.put((CharSequence)"foo", (CharSequence)"doc3", (CharSequence)"value");
            bw.addMutation(m);
            m = new Mutation((CharSequence)"part2");
            m.put((CharSequence)"bar", (CharSequence)"DOC1", (CharSequence)"value");
            m.put((CharSequence)"bar", (CharSequence)"DOC2", (CharSequence)"value");
            m.put((CharSequence)"dog", (CharSequence)"DOC3", (CharSequence)"value");
            m.put((CharSequence)"foo", (CharSequence)"DOC2", (CharSequence)"value");
            m.put((CharSequence)"foo", (CharSequence)"DOC3", (CharSequence)"value");
            bw.addMutation(m);
            bw.flush();
        }
        IteratorSetting si = new IteratorSetting(10, this.tableName, IntersectingIterator.class);
        try (ClientSideIteratorScanner csis = new ClientSideIteratorScanner(this.client.createScanner(this.tableName, new Authorizations()));){
            IntersectingIterator.setColumnFamilies((IteratorSetting)si, (Text[])new Text[]{new Text("bar"), new Text("foo")});
            csis.addScanIterator(si);
            this.checkResults((Iterable<Map.Entry<Key, Value>>)csis, this.resultSet3, PartialKey.ROW_COLFAM_COLQUAL);
        }
    }

    @Test
    public void testVersioning() throws Exception {
        this.client.tableOperations().create(this.tableName);
        this.client.tableOperations().removeProperty(this.tableName, "table.iterator.scan.vers");
        this.client.tableOperations().removeProperty(this.tableName, "table.iterator.majc.vers");
        this.client.tableOperations().removeProperty(this.tableName, "table.iterator.minc.vers");
        try (BatchWriter bw = this.client.createBatchWriter(this.tableName);){
            Mutation m = new Mutation((CharSequence)"row1");
            m.put((CharSequence)"colf", (CharSequence)"colq", 1L, (CharSequence)"value");
            m.put((CharSequence)"colf", (CharSequence)"colq", 2L, (CharSequence)"value");
            bw.addMutation(m);
            bw.flush();
            m = new Mutation((CharSequence)"row1");
            m.put((CharSequence)"colf", (CharSequence)"colq", 3L, (CharSequence)"value");
            m.put((CharSequence)"colf", (CharSequence)"colq", 4L, (CharSequence)"value");
            bw.addMutation(m);
            bw.flush();
        }
        try (Scanner scanner = this.client.createScanner(this.tableName, new Authorizations());
             ClientSideIteratorScanner csis = new ClientSideIteratorScanner(scanner);){
            IteratorSetting si = new IteratorSetting(10, "localvers", VersioningIterator.class);
            si.addOption("maxVersions", "2");
            csis.addScanIterator(si);
            this.checkResults((Iterable<Map.Entry<Key, Value>>)csis, this.resultSet1, PartialKey.ROW_COLFAM_COLQUAL_COLVIS_TIME);
            this.checkResults((Iterable<Map.Entry<Key, Value>>)scanner, this.resultSet2, PartialKey.ROW_COLFAM_COLQUAL_COLVIS_TIME);
            csis.fetchColumnFamily((CharSequence)"colf");
            this.checkResults((Iterable<Map.Entry<Key, Value>>)csis, this.resultSet1, PartialKey.ROW_COLFAM_COLQUAL_COLVIS_TIME);
            csis.clearColumns();
            csis.fetchColumnFamily((CharSequence)"none");
            Assertions.assertFalse((boolean)csis.iterator().hasNext());
        }
    }

    private void runPluginEnvTest(Set<String> expected) throws Exception {
        try (Scanner scanner = this.client.createScanner(this.tableName);){
            initCalled.set(false);
            try (ClientSideIteratorScanner csis = new ClientSideIteratorScanner(scanner);){
                csis.addScanIterator(new IteratorSetting(100, "filter", TestPropFilter.class));
                Assertions.assertEquals(expected, csis.stream().map(e -> ((Key)e.getKey()).getRowData().toString()).collect(Collectors.toSet()));
                Assertions.assertTrue((boolean)initCalled.get());
            }
        }
        this.client.tableOperations().offline(this.tableName, true);
        ClientContext context = (ClientContext)this.client;
        try (OfflineScanner offlineScanner = new OfflineScanner(context, context.getTableId(this.tableName), Authorizations.EMPTY);){
            initCalled.set(false);
            offlineScanner.addScanIterator(new IteratorSetting(100, "filter", TestPropFilter.class));
            Assertions.assertEquals(expected, offlineScanner.stream().map(e -> ((Key)e.getKey()).getRowData().toString()).collect(Collectors.toSet()));
            Assertions.assertTrue((boolean)initCalled.get());
        }
        this.client.tableOperations().online(this.tableName, true);
    }

    @Test
    public void testPluginEnv() throws Exception {
        Set<String> rows = Set.of("1234", "abc", "xyz789");
        this.client.tableOperations().create(this.tableName);
        try (BatchWriter bw = this.client.createBatchWriter(this.tableName);){
            for (String row : rows) {
                Mutation m = new Mutation((CharSequence)row);
                m.put((CharSequence)"f", (CharSequence)"q", (CharSequence)"v");
                bw.addMutation(m);
            }
        }
        this.runPluginEnvTest(rows);
        this.client.instanceOperations().setProperty("general.custom.testRegex", ".*[a-z]+.*");
        this.runPluginEnvTest(Set.of("abc", "xyz789"));
        this.client.tableOperations().setProperty(this.tableName, "table.custom.testRegex", ".*[0-9]+.*");
        this.runPluginEnvTest(Set.of("xyz789"));
        this.client.instanceOperations().removeProperty("general.custom.testRegex");
        this.runPluginEnvTest(Set.of("1234", "xyz789"));
        this.client.tableOperations().removeProperty(this.tableName, "table.custom.testRegex");
        this.runPluginEnvTest(rows);
    }

    public static class TestPropFilter
    extends Filter {
        private Predicate<Key> keyPredicate;

        private Predicate<Key> createRegexPredicate(String regex) {
            Predicate<Key> kp = k -> true;
            if (regex != null) {
                Pattern pattern = Pattern.compile(regex);
                kp = k -> pattern.matcher(k.getRowData().toString()).matches();
            }
            return kp;
        }

        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
            super.init(source, options, env);
            Predicate<Key> generalPredicate = this.createRegexPredicate(env.getPluginEnv().getConfiguration().getCustom("testRegex"));
            Predicate<Key> tablePredicate = this.createRegexPredicate(env.getPluginEnv().getConfiguration(env.getTableId()).getTableCustom("testRegex"));
            this.keyPredicate = generalPredicate.and(tablePredicate);
            initCalled.set(true);
        }

        public boolean accept(Key k, Value v) {
            return this.keyPredicate.test(k);
        }
    }
}

