/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.HashSet;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.metadata.schema.TabletDeletedException;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CloneIT
extends AccumuloClusterHarness {
    @Test
    public void testNoFiles() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CloneIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            KeyExtent ke = new KeyExtent(TableId.of((String)"0"), null, null);
            Mutation mut = MetadataSchema.TabletsSection.TabletColumnFamily.createPrevRowMutation((KeyExtent)ke);
            MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.put(mut, new Value((CharSequence)"M0"));
            MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(mut, new Value((CharSequence)"/default_tablet"));
            try (BatchWriter bw1 = client.createBatchWriter(tableName);){
                bw1.addMutation(mut);
            }
            try (BatchWriter bw2 = client.createBatchWriter(tableName);){
                MetadataTableUtil.initializeClone((String)tableName, (TableId)TableId.of((String)"0"), (TableId)TableId.of((String)"1"), (AccumuloClient)client, (BatchWriter)bw2);
                int rc = MetadataTableUtil.checkClone((String)tableName, (TableId)TableId.of((String)"0"), (TableId)TableId.of((String)"1"), (AccumuloClient)client, (BatchWriter)bw2);
                Assertions.assertEquals((int)0, (int)rc);
            }
        }
    }

    @Test
    public void testFilesChange() throws Exception {
        String filePrefix = "hdfs://nn:8000/accumulo/tables/0";
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CloneIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            KeyExtent ke = new KeyExtent(TableId.of((String)"0"), null, null);
            Mutation mut = MetadataSchema.TabletsSection.TabletColumnFamily.createPrevRowMutation((KeyExtent)ke);
            MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.put(mut, new Value((CharSequence)"M0"));
            MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(mut, new Value((CharSequence)"/default_tablet"));
            mut.put((CharSequence)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME.toString(), (CharSequence)(filePrefix + "/default_tablet/0_0.rf"), (CharSequence)new DataFileValue(1L, 200L).encodeAsString());
            try (BatchWriter bw1 = client.createBatchWriter(tableName);
                 BatchWriter bw2 = client.createBatchWriter(tableName);){
                bw1.addMutation(mut);
                bw1.flush();
                MetadataTableUtil.initializeClone((String)tableName, (TableId)TableId.of((String)"0"), (TableId)TableId.of((String)"1"), (AccumuloClient)client, (BatchWriter)bw2);
                Mutation mut2 = new Mutation(ke.toMetaRow());
                mut2.putDelete((CharSequence)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME.toString(), (CharSequence)(filePrefix + "/default_tablet/0_0.rf"));
                mut2.put((CharSequence)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME.toString(), (CharSequence)(filePrefix + "/default_tablet/1_0.rf"), (CharSequence)new DataFileValue(2L, 300L).encodeAsString());
                bw1.addMutation(mut2);
                bw1.flush();
                int rc = MetadataTableUtil.checkClone((String)tableName, (TableId)TableId.of((String)"0"), (TableId)TableId.of((String)"1"), (AccumuloClient)client, (BatchWriter)bw2);
                Assertions.assertEquals((int)1, (int)rc);
                rc = MetadataTableUtil.checkClone((String)tableName, (TableId)TableId.of((String)"0"), (TableId)TableId.of((String)"1"), (AccumuloClient)client, (BatchWriter)bw2);
                Assertions.assertEquals((int)0, (int)rc);
            }
            HashSet<String> files = new HashSet<String>();
            try (Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);){
                scanner.setRange(new KeyExtent(TableId.of((String)"1"), null, null).toMetaRange());
                for (Map.Entry entry : scanner) {
                    if (!((Key)entry.getKey()).getColumnFamily().equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) continue;
                    files.add(((Key)entry.getKey()).getColumnQualifier().toString());
                }
            }
            Assertions.assertEquals((int)1, (int)files.size());
            Assertions.assertTrue((boolean)files.contains(filePrefix + "/default_tablet/1_0.rf"));
        }
    }

    @Test
    public void testSplit1() throws Exception {
        String filePrefix = "hdfs://nn:8000/accumulo/tables/0";
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CloneIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            try (BatchWriter bw1 = client.createBatchWriter(tableName);
                 BatchWriter bw2 = client.createBatchWriter(tableName);){
                bw1.addMutation(CloneIT.createTablet("0", null, null, "/default_tablet", filePrefix + "/default_tablet/0_0.rf"));
                bw1.flush();
                MetadataTableUtil.initializeClone((String)tableName, (TableId)TableId.of((String)"0"), (TableId)TableId.of((String)"1"), (AccumuloClient)client, (BatchWriter)bw2);
                bw1.addMutation(CloneIT.createTablet("0", "m", null, "/default_tablet", filePrefix + "/default_tablet/0_0.rf"));
                bw1.addMutation(CloneIT.createTablet("0", null, "m", "/t-1", filePrefix + "/default_tablet/0_0.rf"));
                bw1.flush();
                int rc = MetadataTableUtil.checkClone((String)tableName, (TableId)TableId.of((String)"0"), (TableId)TableId.of((String)"1"), (AccumuloClient)client, (BatchWriter)bw2);
                Assertions.assertEquals((int)0, (int)rc);
            }
            HashSet<String> files = new HashSet<String>();
            int count = 0;
            try (Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);){
                scanner.setRange(new KeyExtent(TableId.of((String)"1"), null, null).toMetaRange());
                for (Map.Entry entry : scanner) {
                    if (!((Key)entry.getKey()).getColumnFamily().equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) continue;
                    files.add(((Key)entry.getKey()).getColumnQualifier().toString());
                    ++count;
                }
            }
            Assertions.assertEquals((int)1, (int)count);
            Assertions.assertEquals((int)1, (int)files.size());
            Assertions.assertTrue((boolean)files.contains(filePrefix + "/default_tablet/0_0.rf"));
        }
    }

    @Test
    public void testSplit2() throws Exception {
        String filePrefix = "hdfs://nn:8000/accumulo/tables/0";
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CloneIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            try (BatchWriter bw1 = client.createBatchWriter(tableName);
                 BatchWriter bw2 = client.createBatchWriter(tableName);){
                bw1.addMutation(CloneIT.createTablet("0", null, null, "/default_tablet", filePrefix + "/default_tablet/0_0.rf"));
                bw1.flush();
                MetadataTableUtil.initializeClone((String)tableName, (TableId)TableId.of((String)"0"), (TableId)TableId.of((String)"1"), (AccumuloClient)client, (BatchWriter)bw2);
                bw1.addMutation(CloneIT.createTablet("0", "m", null, "/default_tablet", filePrefix + "/default_tablet/1_0.rf"));
                Mutation mut3 = CloneIT.createTablet("0", null, "m", "/t-1", filePrefix + "/default_tablet/1_0.rf");
                mut3.putDelete((CharSequence)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME.toString(), (CharSequence)(filePrefix + "/default_tablet/0_0.rf"));
                bw1.addMutation(mut3);
                bw1.flush();
                int rc = MetadataTableUtil.checkClone((String)tableName, (TableId)TableId.of((String)"0"), (TableId)TableId.of((String)"1"), (AccumuloClient)client, (BatchWriter)bw2);
                Assertions.assertEquals((int)1, (int)rc);
                rc = MetadataTableUtil.checkClone((String)tableName, (TableId)TableId.of((String)"0"), (TableId)TableId.of((String)"1"), (AccumuloClient)client, (BatchWriter)bw2);
                Assertions.assertEquals((int)0, (int)rc);
            }
            HashSet<String> files = new HashSet<String>();
            int count = 0;
            try (Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);){
                scanner.setRange(new KeyExtent(TableId.of((String)"1"), null, null).toMetaRange());
                for (Map.Entry entry : scanner) {
                    if (!((Key)entry.getKey()).getColumnFamily().equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) continue;
                    files.add(((Key)entry.getKey()).getColumnQualifier().toString());
                    ++count;
                }
            }
            Assertions.assertEquals((int)1, (int)files.size());
            Assertions.assertEquals((int)2, (int)count);
            Assertions.assertTrue((boolean)files.contains(filePrefix + "/default_tablet/1_0.rf"));
        }
    }

    private static Mutation deleteTablet(String tid, String endRow, String prevRow, String file) {
        KeyExtent ke = new KeyExtent(TableId.of((String)tid), endRow == null ? null : new Text(endRow), prevRow == null ? null : new Text(prevRow));
        Mutation mut = new Mutation(ke.toMetaRow());
        MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.putDelete(mut);
        MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.putDelete(mut);
        MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.putDelete(mut);
        mut.putDelete((CharSequence)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME.toString(), (CharSequence)file);
        return mut;
    }

    private static Mutation createTablet(String tid, String endRow, String prevRow, String dir, String file) {
        KeyExtent ke = new KeyExtent(TableId.of((String)tid), endRow == null ? null : new Text(endRow), prevRow == null ? null : new Text(prevRow));
        Mutation mut = MetadataSchema.TabletsSection.TabletColumnFamily.createPrevRowMutation((KeyExtent)ke);
        MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.put(mut, new Value((CharSequence)"M0"));
        MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(mut, new Value((CharSequence)dir));
        mut.put((CharSequence)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME.toString(), (CharSequence)file, (CharSequence)new DataFileValue(10L, 200L).encodeAsString());
        return mut;
    }

    @Test
    public void testSplit3() throws Exception {
        String filePrefix = "hdfs://nn:8000/accumulo/tables/0";
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CloneIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            try (BatchWriter bw1 = client.createBatchWriter(tableName);
                 BatchWriter bw2 = client.createBatchWriter(tableName);){
                bw1.addMutation(CloneIT.createTablet("0", "m", null, "/d1", filePrefix + "/d1/file1.rf"));
                bw1.addMutation(CloneIT.createTablet("0", null, "m", "/d2", filePrefix + "/d2/file2.rf"));
                bw1.flush();
                MetadataTableUtil.initializeClone((String)tableName, (TableId)TableId.of((String)"0"), (TableId)TableId.of((String)"1"), (AccumuloClient)client, (BatchWriter)bw2);
                bw1.addMutation(CloneIT.createTablet("0", "f", null, "/d1", filePrefix + "/d1/file3.rf"));
                bw1.addMutation(CloneIT.createTablet("0", "m", "f", "/d3", filePrefix + "/d1/file1.rf"));
                bw1.addMutation(CloneIT.createTablet("0", "s", "m", "/d2", filePrefix + "/d2/file2.rf"));
                bw1.addMutation(CloneIT.createTablet("0", null, "s", "/d4", filePrefix + "/d2/file2.rf"));
                bw1.flush();
                int rc = MetadataTableUtil.checkClone((String)tableName, (TableId)TableId.of((String)"0"), (TableId)TableId.of((String)"1"), (AccumuloClient)client, (BatchWriter)bw2);
                Assertions.assertEquals((int)0, (int)rc);
            }
            HashSet<String> files = new HashSet<String>();
            int count = 0;
            try (Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);){
                scanner.setRange(new KeyExtent(TableId.of((String)"1"), null, null).toMetaRange());
                for (Map.Entry entry : scanner) {
                    if (!((Key)entry.getKey()).getColumnFamily().equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) continue;
                    files.add(((Key)entry.getKey()).getColumnQualifier().toString());
                    ++count;
                }
            }
            Assertions.assertEquals((int)2, (int)count);
            Assertions.assertEquals((int)2, (int)files.size());
            Assertions.assertTrue((boolean)files.contains(filePrefix + "/d1/file1.rf"));
            Assertions.assertTrue((boolean)files.contains(filePrefix + "/d2/file2.rf"));
        }
    }

    @Test
    public void testClonedMarker() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CloneIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            String filePrefix = "hdfs://nn:8000/accumulo/tables/0";
            try (BatchWriter bw1 = client.createBatchWriter(tableName);
                 BatchWriter bw2 = client.createBatchWriter(tableName);){
                bw1.addMutation(CloneIT.createTablet("0", "m", null, "/d1", filePrefix + "/d1/file1.rf"));
                bw1.addMutation(CloneIT.createTablet("0", null, "m", "/d2", filePrefix + "/d2/file2.rf"));
                bw1.flush();
                MetadataTableUtil.initializeClone((String)tableName, (TableId)TableId.of((String)"0"), (TableId)TableId.of((String)"1"), (AccumuloClient)client, (BatchWriter)bw2);
                bw1.addMutation(CloneIT.deleteTablet("0", "m", null, filePrefix + "/d1/file1.rf"));
                bw1.addMutation(CloneIT.deleteTablet("0", null, "m", filePrefix + "/d2/file2.rf"));
                bw1.flush();
                bw1.addMutation(CloneIT.createTablet("0", "f", null, "/d1", filePrefix + "/d1/file3.rf"));
                bw1.addMutation(CloneIT.createTablet("0", "m", "f", "/d3", filePrefix + "/d1/file1.rf"));
                bw1.addMutation(CloneIT.createTablet("0", "s", "m", "/d2", filePrefix + "/d2/file3.rf"));
                bw1.addMutation(CloneIT.createTablet("0", null, "s", "/d4", filePrefix + "/d4/file3.rf"));
                bw1.flush();
                int rc = MetadataTableUtil.checkClone((String)tableName, (TableId)TableId.of((String)"0"), (TableId)TableId.of((String)"1"), (AccumuloClient)client, (BatchWriter)bw2);
                Assertions.assertEquals((int)1, (int)rc);
                bw1.addMutation(CloneIT.deleteTablet("0", "m", "f", filePrefix + "/d1/file1.rf"));
                bw1.flush();
                bw1.addMutation(CloneIT.createTablet("0", "m", "f", "/d3", filePrefix + "/d1/file3.rf"));
                bw1.flush();
                rc = MetadataTableUtil.checkClone((String)tableName, (TableId)TableId.of((String)"0"), (TableId)TableId.of((String)"1"), (AccumuloClient)client, (BatchWriter)bw2);
                Assertions.assertEquals((int)0, (int)rc);
            }
            HashSet<String> files = new HashSet<String>();
            int count = 0;
            try (Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);){
                scanner.setRange(new KeyExtent(TableId.of((String)"1"), null, null).toMetaRange());
                for (Map.Entry entry : scanner) {
                    if (!((Key)entry.getKey()).getColumnFamily().equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) continue;
                    files.add(((Key)entry.getKey()).getColumnQualifier().toString());
                    ++count;
                }
            }
            Assertions.assertEquals((int)3, (int)count);
            Assertions.assertEquals((int)3, (int)files.size());
            Assertions.assertTrue((boolean)files.contains("hdfs://nn:8000/accumulo/tables/0/d1/file1.rf"));
            Assertions.assertTrue((boolean)files.contains("hdfs://nn:8000/accumulo/tables/0/d2/file3.rf"));
            Assertions.assertTrue((boolean)files.contains("hdfs://nn:8000/accumulo/tables/0/d4/file3.rf"));
        }
    }

    @Test
    public void testMerge() throws Exception {
        String filePrefix = "hdfs://nn:8000/accumulo/tables/0";
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CloneIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            try (BatchWriter bw1 = client.createBatchWriter(tableName);
                 BatchWriter bw2 = client.createBatchWriter(tableName);){
                bw1.addMutation(CloneIT.createTablet("0", "m", null, "/d1", filePrefix + "/d1/file1.rf"));
                bw1.addMutation(CloneIT.createTablet("0", null, "m", "/d2", filePrefix + "/d2/file2.rf"));
                bw1.flush();
                MetadataTableUtil.initializeClone((String)tableName, (TableId)TableId.of((String)"0"), (TableId)TableId.of((String)"1"), (AccumuloClient)client, (BatchWriter)bw2);
                bw1.addMutation(CloneIT.deleteTablet("0", "m", null, filePrefix + "/d1/file1.rf"));
                Mutation mut = CloneIT.createTablet("0", null, null, "/d2", filePrefix + "/d2/file2.rf");
                mut.put((CharSequence)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME.toString(), (CharSequence)(filePrefix + "/d1/file1.rf"), (CharSequence)new DataFileValue(10L, 200L).encodeAsString());
                bw1.addMutation(mut);
                bw1.flush();
                Assertions.assertThrows(TabletDeletedException.class, () -> MetadataTableUtil.checkClone((String)tableName, (TableId)TableId.of((String)"0"), (TableId)TableId.of((String)"1"), (AccumuloClient)client, (BatchWriter)bw2));
            }
        }
    }
}

