/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.ConditionalWriter;
import org.apache.accumulo.core.client.ConditionalWriterConfig;
import org.apache.accumulo.core.client.Durability;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.clientImpl.ConditionalWriterImpl;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Condition;
import org.apache.accumulo.core.data.ConditionalMutation;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.LongCombiner;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;
import org.apache.accumulo.core.iterators.user.SummingCombiner;
import org.apache.accumulo.core.iterators.user.VersioningIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.util.FastFormat;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloITBase;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.constraints.AlphaNumKeyConstraint;
import org.apache.accumulo.test.functional.BadIterator;
import org.apache.accumulo.test.functional.SlowIterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalWriterIT
extends SharedMiniClusterBase {
    private static final Logger log = LoggerFactory.getLogger(ConditionalWriterIT.class);

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    @BeforeAll
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniClusterWithConfig(new Callback());
    }

    @AfterAll
    public static void teardown() {
        SharedMiniClusterBase.stopMiniCluster();
    }

    public static long abs(long l) {
        if ((l = Math.abs(l)) < 0L) {
            return 0L;
        }
        return l;
    }

    @BeforeEach
    public void deleteUsers() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            Set users = client.securityOperations().listLocalUsers();
            ClusterUser user = this.getUser(0);
            if (users.contains(user.getPrincipal())) {
                client.securityOperations().dropLocalUser(user.getPrincipal());
            }
        }
    }

    @Test
    public void testBasic() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            try (ConditionalWriter cw = client.createConditionalWriter(tableName);
                 Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);){
                ConditionalMutation cm0 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq")});
                cm0.put((CharSequence)"name", (CharSequence)"last", (CharSequence)"doe");
                cm0.put((CharSequence)"name", (CharSequence)"first", (CharSequence)"john");
                cm0.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
                Assertions.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm0).getStatus());
                Assertions.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm0).getStatus());
                ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"1")});
                cm1.put((CharSequence)"name", (CharSequence)"last", (CharSequence)"Doe");
                cm1.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"2");
                Assertions.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm1).getStatus());
                ConditionalMutation cm2 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"1")});
                cm2.put((CharSequence)"name", (CharSequence)"last", (CharSequence)"DOE");
                cm2.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"2");
                Assertions.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm2).getStatus());
                ConditionalMutation cm3 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"txtypo", (CharSequence)"seq").setValue((CharSequence)"1")});
                cm3.put((CharSequence)"name", (CharSequence)"last", (CharSequence)"deo");
                cm3.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"2");
                Assertions.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm3).getStatus());
                ConditionalMutation cm4 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"2"), new Condition((CharSequence)"name", (CharSequence)"last").setValue((CharSequence)"doe")});
                cm4.put((CharSequence)"name", (CharSequence)"last", (CharSequence)"deo");
                cm4.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"3");
                Assertions.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm4).getStatus());
                ConditionalMutation cm5 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"1"), new Condition((CharSequence)"name", (CharSequence)"last").setValue((CharSequence)"Doe")});
                cm5.put((CharSequence)"name", (CharSequence)"last", (CharSequence)"deo");
                cm5.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"3");
                Assertions.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm5).getStatus());
                scanner.fetchColumn((CharSequence)"name", (CharSequence)"last");
                scanner.setRange(new Range((CharSequence)"99006"));
                Map.Entry<Key, Value> entry = this.getOnlyElement(scanner);
                Assertions.assertEquals((Object)"Doe", (Object)entry.getValue().toString());
                ConditionalMutation cm6 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"2"), new Condition((CharSequence)"name", (CharSequence)"last").setValue((CharSequence)"Doe")});
                cm6.put((CharSequence)"name", (CharSequence)"last", (CharSequence)"DOE");
                cm6.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"3");
                Assertions.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm6).getStatus());
                entry = this.getOnlyElement(scanner);
                Assertions.assertEquals((Object)"DOE", (Object)entry.getValue().toString());
                ConditionalMutation cm7 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"3")});
                cm7.putDelete((CharSequence)"name", (CharSequence)"last");
                cm7.putDelete((CharSequence)"name", (CharSequence)"first");
                cm7.putDelete((CharSequence)"tx", (CharSequence)"seq");
                Assertions.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm7).getStatus());
                Assertions.assertFalse((boolean)scanner.iterator().hasNext(), (String)"Did not expect to find any results");
                Assertions.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm0).getStatus());
                Assertions.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm0).getStatus());
                entry = this.getOnlyElement(scanner);
                Assertions.assertEquals((Object)"doe", (Object)entry.getValue().toString());
            }
        }
    }

    @Test
    public void testFields() throws Exception {
        try (AccumuloClient client1 = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            ClusterUser user1 = this.getUser(0);
            String user = user1.getPrincipal();
            if (ConditionalWriterIT.saslEnabled()) {
                client1.securityOperations().createLocalUser(user, null);
            } else {
                client1.securityOperations().createLocalUser(user, new PasswordToken((CharSequence)user1.getPassword()));
            }
            Authorizations auths = new Authorizations(new String[]{"A", "B"});
            client1.securityOperations().changeUserAuthorizations(user, auths);
            client1.securityOperations().grantSystemPermission(user, SystemPermission.CREATE_TABLE);
            try (AccumuloClient client2 = (AccumuloClient)Accumulo.newClient().from(client1.properties()).as((CharSequence)user, user1.getToken()).build();){
                client2.tableOperations().create(tableName);
                try (ConditionalWriter cw = client2.createConditionalWriter(tableName, new ConditionalWriterConfig().setAuthorizations(auths));
                     Scanner scanner = client2.createScanner(tableName, auths);){
                    ColumnVisibility cva = new ColumnVisibility("A");
                    ColumnVisibility cvb = new ColumnVisibility("B");
                    ConditionalMutation cm0 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cva)});
                    cm0.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
                    cm0.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
                    cm0.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
                    Assertions.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm0).getStatus());
                    scanner.setRange(new Range((CharSequence)"99006"));
                    Function<Scanner, Map.Entry> verifyValues = givenScanner -> {
                        givenScanner.fetchColumn((CharSequence)"name", (CharSequence)"last");
                        Map.Entry<Key, Value> result = this.getOnlyElement((Scanner)givenScanner);
                        Assertions.assertEquals((Object)"doe", (Object)result.getValue().toString());
                        givenScanner.clearColumns();
                        givenScanner.fetchColumn((CharSequence)"name", (CharSequence)"first");
                        result = this.getOnlyElement((Scanner)givenScanner);
                        Assertions.assertEquals((Object)"john", (Object)result.getValue().toString());
                        givenScanner.clearColumns();
                        givenScanner.fetchColumn((CharSequence)"tx", (CharSequence)"seq");
                        result = this.getOnlyElement((Scanner)givenScanner);
                        Assertions.assertEquals((Object)"1", (Object)result.getValue().toString());
                        givenScanner.clearColumns();
                        return result;
                    };
                    Map.Entry<Key, Value> entry = verifyValues.apply(scanner);
                    long ts = ((Key)entry.getKey()).getTimestamp();
                    ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"txA", (CharSequence)"seq").setVisibility(cva).setValue((CharSequence)"1")});
                    cm1.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"Doe");
                    cm1.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"John");
                    cm1.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"2");
                    Assertions.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm1).getStatus());
                    ConditionalMutation cm2 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seqA").setVisibility(cva).setValue((CharSequence)"1")});
                    cm2.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"Doe");
                    cm2.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"John");
                    cm2.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"2");
                    Assertions.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm2).getStatus());
                    ConditionalMutation cm3 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvb).setValue((CharSequence)"1")});
                    cm3.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"Doe");
                    cm3.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"John");
                    cm3.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"2");
                    Assertions.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm3).getStatus());
                    ConditionalMutation cm4 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cva).setTimestamp(ts + 1L).setValue((CharSequence)"1")});
                    cm4.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"Doe");
                    cm4.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"John");
                    cm4.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"2");
                    Assertions.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm4).getStatus());
                    ConditionalMutation cm5 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cva).setTimestamp(ts - 1L).setValue((CharSequence)"1")});
                    cm5.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"Doe");
                    cm5.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"John");
                    cm5.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"2");
                    Assertions.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm5).getStatus());
                    Map.Entry after = verifyValues.apply(scanner);
                    Assertions.assertEquals((long)ts, (long)((Key)after.getKey()).getTimestamp());
                    ConditionalMutation cm6 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cva).setTimestamp(ts).setValue((CharSequence)"1")});
                    cm6.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"Doe");
                    cm6.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"John");
                    cm6.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"2");
                    Assertions.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm6).getStatus());
                    scanner.fetchColumn((CharSequence)"tx", (CharSequence)"seq");
                    entry = this.getOnlyElement(scanner);
                    Assertions.assertEquals((Object)"2", (Object)entry.getValue().toString());
                }
            }
        }
    }

    @Test
    public void testBadColVis() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            Authorizations auths = new Authorizations(new String[]{"A", "B"});
            client.securityOperations().changeUserAuthorizations(ConditionalWriterIT.getAdminPrincipal(), auths);
            Authorizations filteredAuths = new Authorizations(new String[]{"A"});
            ColumnVisibility cva = new ColumnVisibility("A");
            ColumnVisibility cvb = new ColumnVisibility("B");
            ColumnVisibility cvc = new ColumnVisibility("C");
            try (ConditionalWriter cw = client.createConditionalWriter(tableName, new ConditionalWriterConfig().setAuthorizations(filteredAuths));){
                ConditionalMutation cm0 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvb)});
                cm0.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
                cm0.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
                cm0.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
                Assertions.assertEquals((Object)ConditionalWriter.Status.INVISIBLE_VISIBILITY, (Object)cw.write(cm0).getStatus());
                ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvb).setValue((CharSequence)"1")});
                cm1.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
                cm1.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
                cm1.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
                Assertions.assertEquals((Object)ConditionalWriter.Status.INVISIBLE_VISIBILITY, (Object)cw.write(cm1).getStatus());
                ConditionalMutation cm2 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvc)});
                cm2.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
                cm2.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
                cm2.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
                Assertions.assertEquals((Object)ConditionalWriter.Status.INVISIBLE_VISIBILITY, (Object)cw.write(cm2).getStatus());
                ConditionalMutation cm3 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvc).setValue((CharSequence)"1")});
                cm3.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
                cm3.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
                cm3.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
                Assertions.assertEquals((Object)ConditionalWriter.Status.INVISIBLE_VISIBILITY, (Object)cw.write(cm3).getStatus());
                ConditionalMutation cm4 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvb), new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cva)});
                cm4.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
                cm4.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
                cm4.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
                Assertions.assertEquals((Object)ConditionalWriter.Status.INVISIBLE_VISIBILITY, (Object)cw.write(cm4).getStatus());
                ConditionalMutation cm5 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvb).setValue((CharSequence)"1"), new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cva).setValue((CharSequence)"1")});
                cm5.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
                cm5.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
                cm5.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
                Assertions.assertEquals((Object)ConditionalWriter.Status.INVISIBLE_VISIBILITY, (Object)cw.write(cm5).getStatus());
                ConditionalMutation cm6 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvb).setValue((CharSequence)"1"), new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cva)});
                cm6.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
                cm6.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
                cm6.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
                Assertions.assertEquals((Object)ConditionalWriter.Status.INVISIBLE_VISIBILITY, (Object)cw.write(cm6).getStatus());
                ConditionalMutation cm7 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvb), new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cva).setValue((CharSequence)"1")});
                cm7.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
                cm7.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
                cm7.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
                Assertions.assertEquals((Object)ConditionalWriter.Status.INVISIBLE_VISIBILITY, (Object)cw.write(cm7).getStatus());
            }
            Authorizations exceedingAuths = new Authorizations(new String[]{"A", "B", "D"});
            try (ConditionalWriter cw2 = client.createConditionalWriter(tableName, new ConditionalWriterConfig().setAuthorizations(exceedingAuths));){
                ConditionalMutation cm8 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvb), new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cva).setValue((CharSequence)"1")});
                cm8.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
                cm8.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
                cm8.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
                Assertions.assertThrows(AccumuloSecurityException.class, () -> {
                    ConditionalWriter.Status status = cw2.write(cm8).getStatus();
                    log.error("Writing mutation with Authorizations the user doesn't have should fail. Got status: {}", (Object)status);
                });
            }
        }
    }

    @Test
    public void testConstraints() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            client.tableOperations().addConstraint(tableName, AlphaNumKeyConstraint.class.getName());
            client.tableOperations().clone(tableName, tableName + "_clone", true, new HashMap(), new HashSet());
            try (ConditionalWriter cw = client.createConditionalWriter(tableName + "_clone");
                 Scanner scanner = client.createScanner(tableName + "_clone", new Authorizations());){
                ConditionalMutation cm0 = new ConditionalMutation((CharSequence)"99006+", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq")});
                cm0.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
                Assertions.assertEquals((Object)ConditionalWriter.Status.VIOLATED, (Object)cw.write(cm0).getStatus());
                Assertions.assertFalse((boolean)scanner.iterator().hasNext(), (String)"Should find no results in the table is mutation result was violated");
                ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq")});
                cm1.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
                Assertions.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm1).getStatus());
                Assertions.assertTrue((boolean)scanner.iterator().hasNext(), (String)"Accepted result should be returned when reading table");
            }
        }
    }

    @Test
    public void testIterators() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName, new NewTableConfiguration().withoutDefaultIterators());
            try (BatchWriter bw = client.createBatchWriter(tableName);){
                Mutation m = new Mutation((CharSequence)"ACCUMULO-1000");
                m.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"1");
                bw.addMutation(m);
                bw.addMutation(m);
                bw.addMutation(m);
                m = new Mutation((CharSequence)"ACCUMULO-1001");
                m.put((CharSequence)"count2", (CharSequence)"comments", (CharSequence)"1");
                bw.addMutation(m);
                bw.addMutation(m);
                m = new Mutation((CharSequence)"ACCUMULO-1002");
                m.put((CharSequence)"count2", (CharSequence)"comments", (CharSequence)"1");
                bw.addMutation(m);
                bw.addMutation(m);
            }
            IteratorSetting iterConfig = new IteratorSetting(10, SummingCombiner.class);
            SummingCombiner.setEncodingType((IteratorSetting)iterConfig, (LongCombiner.Type)LongCombiner.Type.STRING);
            SummingCombiner.setColumns((IteratorSetting)iterConfig, Collections.singletonList(new IteratorSetting.Column("count")));
            IteratorSetting iterConfig2 = new IteratorSetting(10, SummingCombiner.class);
            SummingCombiner.setEncodingType((IteratorSetting)iterConfig2, (LongCombiner.Type)LongCombiner.Type.STRING);
            SummingCombiner.setColumns((IteratorSetting)iterConfig2, Collections.singletonList(new IteratorSetting.Column("count2", "comments")));
            IteratorSetting iterConfig3 = new IteratorSetting(5, VersioningIterator.class);
            VersioningIterator.setMaxVersions((IteratorSetting)iterConfig3, (int)1);
            try (Scanner scanner = client.createScanner(tableName, new Authorizations());){
                scanner.addScanIterator(iterConfig);
                scanner.setRange(new Range((CharSequence)"ACCUMULO-1000"));
                scanner.fetchColumn((CharSequence)"count", (CharSequence)"comments");
                Map.Entry<Key, Value> entry = this.getOnlyElement(scanner);
                Assertions.assertEquals((Object)"3", (Object)entry.getValue().toString());
                try (ConditionalWriter cw = client.createConditionalWriter(tableName);){
                    ConditionalMutation cm0 = new ConditionalMutation((CharSequence)"ACCUMULO-1000", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setValue((CharSequence)"3")});
                    cm0.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"1");
                    Assertions.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm0).getStatus());
                    entry = this.getOnlyElement(scanner);
                    Assertions.assertEquals((Object)"3", (Object)entry.getValue().toString());
                    ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"ACCUMULO-1000", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setIterators(new IteratorSetting[]{iterConfig}).setValue((CharSequence)"3")});
                    cm1.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"1");
                    Assertions.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm1).getStatus());
                    entry = this.getOnlyElement(scanner);
                    Assertions.assertEquals((Object)"4", (Object)entry.getValue().toString());
                    ConditionalMutation cm2 = new ConditionalMutation((CharSequence)"ACCUMULO-1000", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setValue((CharSequence)"4")});
                    cm2.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"1");
                    Assertions.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm1).getStatus());
                    entry = this.getOnlyElement(scanner);
                    Assertions.assertEquals((Object)"4", (Object)entry.getValue().toString());
                    ConditionalMutation cm3 = new ConditionalMutation((CharSequence)"ACCUMULO-1000", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setIterators(new IteratorSetting[]{iterConfig}).setValue((CharSequence)"4")});
                    cm3.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"1");
                    ConditionalMutation cm4 = new ConditionalMutation((CharSequence)"ACCUMULO-1001", new Condition[]{new Condition((CharSequence)"count2", (CharSequence)"comments").setIterators(new IteratorSetting[]{iterConfig2}).setValue((CharSequence)"2")});
                    cm4.put((CharSequence)"count2", (CharSequence)"comments", (CharSequence)"1");
                    ConditionalMutation cm5 = new ConditionalMutation((CharSequence)"ACCUMULO-1002", new Condition[]{new Condition((CharSequence)"count2", (CharSequence)"comments").setIterators(new IteratorSetting[]{iterConfig2, iterConfig3}).setValue((CharSequence)"2")});
                    cm5.put((CharSequence)"count2", (CharSequence)"comments", (CharSequence)"1");
                    Iterator results = cw.write(Arrays.asList(cm3, cm4, cm5).iterator());
                    HashMap<String, ConditionalWriter.Status> actual = new HashMap<String, ConditionalWriter.Status>();
                    while (results.hasNext()) {
                        ConditionalWriter.Result result = (ConditionalWriter.Result)results.next();
                        String k = new String(result.getMutation().getRow());
                        Assertions.assertFalse((boolean)actual.containsKey(k), (String)("Did not expect to see multiple results for the row: " + k));
                        actual.put(k, result.getStatus());
                    }
                    HashMap<String, ConditionalWriter.Status> expected = new HashMap<String, ConditionalWriter.Status>();
                    expected.put("ACCUMULO-1000", ConditionalWriter.Status.ACCEPTED);
                    expected.put("ACCUMULO-1001", ConditionalWriter.Status.ACCEPTED);
                    expected.put("ACCUMULO-1002", ConditionalWriter.Status.REJECTED);
                    Assertions.assertEquals(expected, actual);
                }
            }
        }
    }

    @Test
    public void testTableAndConditionIterators() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            IteratorSetting aiConfig1 = new IteratorSetting(30, "AI1", AddingIterator.class);
            aiConfig1.addOption("amount", "2");
            IteratorSetting aiConfig2 = new IteratorSetting(35, "MI1", MultiplyingIterator.class);
            aiConfig2.addOption("amount", "3");
            IteratorSetting aiConfig3 = new IteratorSetting(40, "AI2", AddingIterator.class);
            aiConfig3.addOption("amount", "5");
            client.tableOperations().create(tableName);
            try (BatchWriter bw = client.createBatchWriter(tableName);){
                Mutation m = new Mutation((CharSequence)"ACCUMULO-1000");
                m.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"6");
                bw.addMutation(m);
                m = new Mutation((CharSequence)"ACCUMULO-1001");
                m.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"7");
                bw.addMutation(m);
                m = new Mutation((CharSequence)"ACCUMULO-1002");
                m.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"8");
                bw.addMutation(m);
            }
            client.tableOperations().attachIterator(tableName, aiConfig1, EnumSet.of(IteratorUtil.IteratorScope.scan));
            client.tableOperations().offline(tableName, true);
            client.tableOperations().online(tableName, true);
            try (ConditionalWriter cw = client.createConditionalWriter(tableName);
                 Scanner scanner = client.createScanner(tableName, new Authorizations());){
                ConditionalMutation cm6 = new ConditionalMutation((CharSequence)"ACCUMULO-1000", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setValue((CharSequence)"8")});
                cm6.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"7");
                Assertions.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm6).getStatus());
                scanner.setRange(new Range((CharSequence)"ACCUMULO-1000"));
                scanner.fetchColumn((CharSequence)"count", (CharSequence)"comments");
                Map.Entry<Key, Value> entry = this.getOnlyElement(scanner);
                Assertions.assertEquals((Object)"9", (Object)entry.getValue().toString());
                ConditionalMutation cm7 = new ConditionalMutation((CharSequence)"ACCUMULO-1000", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setIterators(new IteratorSetting[]{aiConfig2}).setValue((CharSequence)"27")});
                cm7.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"8");
                Assertions.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm7).getStatus());
                entry = this.getOnlyElement(scanner);
                Assertions.assertEquals((Object)"10", (Object)entry.getValue().toString());
                ConditionalMutation cm8 = new ConditionalMutation((CharSequence)"ACCUMULO-1000", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setIterators(new IteratorSetting[]{aiConfig2, aiConfig3}).setValue((CharSequence)"35")});
                cm8.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"9");
                Assertions.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm8).getStatus());
                entry = this.getOnlyElement(scanner);
                Assertions.assertEquals((Object)"11", (Object)entry.getValue().toString());
                ConditionalMutation cm3 = new ConditionalMutation((CharSequence)"ACCUMULO-1000", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setIterators(new IteratorSetting[]{aiConfig2}).setValue((CharSequence)"33")});
                cm3.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"3");
                ConditionalMutation cm4 = new ConditionalMutation((CharSequence)"ACCUMULO-1001", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setIterators(new IteratorSetting[]{aiConfig3}).setValue((CharSequence)"14")});
                cm4.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"3");
                ConditionalMutation cm5 = new ConditionalMutation((CharSequence)"ACCUMULO-1002", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setIterators(new IteratorSetting[]{aiConfig3}).setValue((CharSequence)"10")});
                cm5.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"3");
                Iterator results = cw.write(Arrays.asList(cm3, cm4, cm5).iterator());
                HashMap<String, ConditionalWriter.Status> actual = new HashMap<String, ConditionalWriter.Status>();
                while (results.hasNext()) {
                    ConditionalWriter.Result result = (ConditionalWriter.Result)results.next();
                    String k = new String(result.getMutation().getRow());
                    Assertions.assertFalse((boolean)actual.containsKey(k), (String)("Did not expect to see multiple results for the row: " + k));
                    actual.put(k, result.getStatus());
                }
                HashMap<String, ConditionalWriter.Status> expected = new HashMap<String, ConditionalWriter.Status>();
                expected.put("ACCUMULO-1000", ConditionalWriter.Status.ACCEPTED);
                expected.put("ACCUMULO-1001", ConditionalWriter.Status.ACCEPTED);
                expected.put("ACCUMULO-1002", ConditionalWriter.Status.REJECTED);
                Assertions.assertEquals(expected, actual);
            }
        }
    }

    @Test
    public void testBatch() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            client.securityOperations().changeUserAuthorizations(ConditionalWriterIT.getAdminPrincipal(), new Authorizations(new String[]{"A", "B"}));
            ColumnVisibility cvab = new ColumnVisibility("A|B");
            ArrayList<ConditionalMutation> mutations = new ArrayList<ConditionalMutation>();
            ConditionalMutation cm0 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvab)});
            cm0.put((CharSequence)"name", (CharSequence)"last", cvab, (CharSequence)"doe");
            cm0.put((CharSequence)"name", (CharSequence)"first", cvab, (CharSequence)"john");
            cm0.put((CharSequence)"tx", (CharSequence)"seq", cvab, (CharSequence)"1");
            mutations.add(cm0);
            ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"59056", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvab)});
            cm1.put((CharSequence)"name", (CharSequence)"last", cvab, (CharSequence)"doe");
            cm1.put((CharSequence)"name", (CharSequence)"first", cvab, (CharSequence)"jane");
            cm1.put((CharSequence)"tx", (CharSequence)"seq", cvab, (CharSequence)"1");
            mutations.add(cm1);
            ConditionalMutation cm2 = new ConditionalMutation((CharSequence)"19059", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvab)});
            cm2.put((CharSequence)"name", (CharSequence)"last", cvab, (CharSequence)"doe");
            cm2.put((CharSequence)"name", (CharSequence)"first", cvab, (CharSequence)"jack");
            cm2.put((CharSequence)"tx", (CharSequence)"seq", cvab, (CharSequence)"1");
            mutations.add(cm2);
            try (ConditionalWriter cw = client.createConditionalWriter(tableName, new ConditionalWriterConfig().setAuthorizations(new Authorizations(new String[]{"A"})));
                 Scanner scanner = client.createScanner(tableName, new Authorizations(new String[]{"A"}));){
                Iterator results = cw.write(mutations.iterator());
                int count = 0;
                while (results.hasNext()) {
                    String[] result = (String[])results.next();
                    Assertions.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)result.getStatus());
                    ++count;
                }
                Assertions.assertEquals((int)3, (int)count);
                scanner.fetchColumn((CharSequence)"tx", (CharSequence)"seq");
                for (String row : new String[]{"99006", "59056", "19059"}) {
                    scanner.setRange(new Range((CharSequence)row));
                    Map.Entry<Key, Value> entry = this.getOnlyElement(scanner);
                    Assertions.assertEquals((Object)"1", (Object)entry.getValue().toString());
                }
                TreeSet<Text> splits = new TreeSet<Text>();
                splits.add(new Text("7"));
                splits.add(new Text("3"));
                client.tableOperations().addSplits(tableName, splits);
                mutations.clear();
                ConditionalMutation cm3 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvab).setValue((CharSequence)"1")});
                cm3.put((CharSequence)"name", (CharSequence)"last", cvab, (CharSequence)"Doe");
                cm3.put((CharSequence)"tx", (CharSequence)"seq", cvab, (CharSequence)"2");
                mutations.add(cm3);
                ConditionalMutation cm4 = new ConditionalMutation((CharSequence)"59056", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvab)});
                cm4.put((CharSequence)"name", (CharSequence)"last", cvab, (CharSequence)"Doe");
                cm4.put((CharSequence)"tx", (CharSequence)"seq", cvab, (CharSequence)"1");
                mutations.add(cm4);
                ConditionalMutation cm5 = new ConditionalMutation((CharSequence)"19059", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvab).setValue((CharSequence)"2")});
                cm5.put((CharSequence)"name", (CharSequence)"last", cvab, (CharSequence)"Doe");
                cm5.put((CharSequence)"tx", (CharSequence)"seq", cvab, (CharSequence)"3");
                mutations.add(cm5);
                results = cw.write(mutations.iterator());
                int accepted = 0;
                int rejected = 0;
                while (results.hasNext()) {
                    String[] result = (String[])results.next();
                    if (new String(result.getMutation().getRow()).equals("99006")) {
                        Assertions.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)result.getStatus());
                        ++accepted;
                        continue;
                    }
                    Assertions.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)result.getStatus());
                    ++rejected;
                }
                Assertions.assertEquals((int)1, (int)accepted, (String)"Expected only one accepted conditional mutation");
                Assertions.assertEquals((int)2, (int)rejected, (String)"Expected two rejected conditional mutations");
                for (String row : new String[]{"59056", "19059"}) {
                    scanner.setRange(new Range((CharSequence)row));
                    Map.Entry<Key, Value> entry = this.getOnlyElement(scanner);
                    Assertions.assertEquals((Object)"1", (Object)entry.getValue().toString());
                }
                scanner.setRange(new Range((CharSequence)"99006"));
                Map.Entry<Key, Value> entry = this.getOnlyElement(scanner);
                Assertions.assertEquals((Object)"2", (Object)entry.getValue().toString());
                scanner.clearColumns();
                scanner.fetchColumn((CharSequence)"name", (CharSequence)"last");
                entry = this.getOnlyElement(scanner);
                Assertions.assertEquals((Object)"Doe", (Object)entry.getValue().toString());
            }
        }
    }

    @Test
    public void testBigBatch() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            int i;
            String tableName = this.getUniqueNames(1)[0];
            NewTableConfiguration ntc = new NewTableConfiguration().withSplits(this.nss("2", "4", "6"));
            client.tableOperations().create(tableName, ntc);
            UtilWaitThread.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
            int num = 100;
            ArrayList<byte[]> rows = new ArrayList<byte[]>(num);
            ArrayList<ConditionalMutation> cml = new ArrayList<ConditionalMutation>(num);
            byte[] e = new byte[]{};
            for (i = 0; i < num; ++i) {
                rows.add(FastFormat.toZeroPaddedString((long)ConditionalWriterIT.abs(random.nextLong()), (int)16, (int)16, (byte[])e));
            }
            for (i = 0; i < num; ++i) {
                ConditionalMutation cm = new ConditionalMutation((byte[])rows.get(i), new Condition[]{new Condition((CharSequence)"meta", (CharSequence)"seq")});
                cm.put((CharSequence)"meta", (CharSequence)"seq", (CharSequence)"1");
                cm.put((CharSequence)"meta", (CharSequence)"tx", (CharSequence)UUID.randomUUID().toString());
                cml.add(cm);
            }
            try (ConditionalWriter cw = client.createConditionalWriter(tableName);){
                Iterator results = cw.write(cml.iterator());
                int count = 0;
                HashSet<String> rowsReceived = new HashSet<String>();
                while (results.hasNext()) {
                    ConditionalWriter.Result result = (ConditionalWriter.Result)results.next();
                    rowsReceived.add(new String(result.getMutation().getRow(), StandardCharsets.UTF_8));
                    Assertions.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)result.getStatus());
                    ++count;
                }
                Assertions.assertEquals((int)num, (int)count, (String)"Did not receive the expected number of results");
                Set rowsExpected = rows.stream().map(row -> new String((byte[])row, StandardCharsets.UTF_8)).collect(Collectors.toSet());
                Assertions.assertEquals(rowsExpected, rowsReceived, (String)"Did not receive all expected rows");
                ArrayList<ConditionalMutation> cml2 = new ArrayList<ConditionalMutation>(num);
                for (int i2 = 0; i2 < num; ++i2) {
                    ConditionalMutation cm = new ConditionalMutation((byte[])rows.get(i2), new Condition[]{new Condition((CharSequence)"meta", (CharSequence)"seq").setValue((CharSequence)"1")});
                    cm.put((CharSequence)"meta", (CharSequence)"seq", (CharSequence)"2");
                    cm.put((CharSequence)"meta", (CharSequence)"tx", (CharSequence)UUID.randomUUID().toString());
                    cml2.add(cm);
                }
                count = 0;
                results = cw.write(cml2.iterator());
                while (results.hasNext()) {
                    ConditionalWriter.Result result = (ConditionalWriter.Result)results.next();
                    Assertions.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)result.getStatus());
                    ++count;
                }
                Assertions.assertEquals((int)num, (int)count, (String)"Did not receive the expected number of results");
            }
        }
    }

    @Test
    public void testBatchErrors() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            client.tableOperations().addConstraint(tableName, AlphaNumKeyConstraint.class.getName());
            client.tableOperations().clone(tableName, tableName + "_clone", true, new HashMap(), new HashSet());
            client.securityOperations().changeUserAuthorizations(ConditionalWriterIT.getAdminPrincipal(), new Authorizations(new String[]{"A", "B"}));
            ColumnVisibility cvaob = new ColumnVisibility("A|B");
            ColumnVisibility cvaab = new ColumnVisibility("A&B");
            switch (random.nextInt(3)) {
                case 1: {
                    client.tableOperations().addSplits(tableName, this.nss("6"));
                    break;
                }
                case 2: {
                    client.tableOperations().addSplits(tableName, this.nss("2", "95"));
                }
            }
            ArrayList<ConditionalMutation> mutations = new ArrayList<ConditionalMutation>();
            ConditionalMutation cm0 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvaob)});
            cm0.put((CharSequence)"name+", (CharSequence)"last", cvaob, (CharSequence)"doe");
            cm0.put((CharSequence)"name", (CharSequence)"first", cvaob, (CharSequence)"john");
            cm0.put((CharSequence)"tx", (CharSequence)"seq", cvaob, (CharSequence)"1");
            mutations.add(cm0);
            ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"59056", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvaab)});
            cm1.put((CharSequence)"name", (CharSequence)"last", cvaab, (CharSequence)"doe");
            cm1.put((CharSequence)"name", (CharSequence)"first", cvaab, (CharSequence)"jane");
            cm1.put((CharSequence)"tx", (CharSequence)"seq", cvaab, (CharSequence)"1");
            mutations.add(cm1);
            ConditionalMutation cm2 = new ConditionalMutation((CharSequence)"19059", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvaob)});
            cm2.put((CharSequence)"name", (CharSequence)"last", cvaob, (CharSequence)"doe");
            cm2.put((CharSequence)"name", (CharSequence)"first", cvaob, (CharSequence)"jack");
            cm2.put((CharSequence)"tx", (CharSequence)"seq", cvaob, (CharSequence)"1");
            mutations.add(cm2);
            ConditionalMutation cm3 = new ConditionalMutation((CharSequence)"90909", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvaob).setValue((CharSequence)"1")});
            cm3.put((CharSequence)"name", (CharSequence)"last", cvaob, (CharSequence)"doe");
            cm3.put((CharSequence)"name", (CharSequence)"first", cvaob, (CharSequence)"john");
            cm3.put((CharSequence)"tx", (CharSequence)"seq", cvaob, (CharSequence)"2");
            mutations.add(cm3);
            try (ConditionalWriter cw = client.createConditionalWriter(tableName, new ConditionalWriterConfig().setAuthorizations(new Authorizations(new String[]{"A"})));
                 Scanner scanner = client.createScanner(tableName, new Authorizations(new String[]{"A"}));){
                Iterator results = cw.write(mutations.iterator());
                HashSet<String> rows = new HashSet<String>();
                while (results.hasNext()) {
                    String row;
                    ConditionalWriter.Result result = (ConditionalWriter.Result)results.next();
                    switch (row = new String(result.getMutation().getRow())) {
                        case "19059": {
                            Assertions.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)result.getStatus());
                            break;
                        }
                        case "59056": {
                            Assertions.assertEquals((Object)ConditionalWriter.Status.INVISIBLE_VISIBILITY, (Object)result.getStatus());
                            break;
                        }
                        case "99006": {
                            Assertions.assertEquals((Object)ConditionalWriter.Status.VIOLATED, (Object)result.getStatus());
                            break;
                        }
                        case "90909": {
                            Assertions.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)result.getStatus());
                        }
                    }
                    rows.add(row);
                }
                Assertions.assertEquals((int)4, (int)rows.size());
                scanner.fetchColumn((CharSequence)"tx", (CharSequence)"seq");
                Map.Entry<Key, Value> entry = this.getOnlyElement(scanner);
                Assertions.assertEquals((Object)"1", (Object)entry.getValue().toString());
            }
        }
    }

    @Test
    public void testSameRow() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            try (ConditionalWriter cw = client.createConditionalWriter(tableName);){
                ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq")});
                cm1.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
                cm1.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"a");
                Assertions.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm1).getStatus());
                ConditionalMutation cm2 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"1")});
                cm2.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"2");
                cm2.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"b");
                ConditionalMutation cm3 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"1")});
                cm3.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"2");
                cm3.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"c");
                ConditionalMutation cm4 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"1")});
                cm4.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"2");
                cm4.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"d");
                Iterator results = cw.write(Arrays.asList(cm2, cm3, cm4).iterator());
                int accepted = 0;
                int rejected = 0;
                int total = 0;
                while (results.hasNext()) {
                    ConditionalWriter.Status status = ((ConditionalWriter.Result)results.next()).getStatus();
                    if (status == ConditionalWriter.Status.ACCEPTED) {
                        ++accepted;
                    }
                    if (status == ConditionalWriter.Status.REJECTED) {
                        ++rejected;
                    }
                    ++total;
                }
                Assertions.assertEquals((int)1, (int)accepted, (String)"Expected one accepted result");
                Assertions.assertEquals((int)2, (int)rejected, (String)"Expected two rejected results");
                Assertions.assertEquals((int)3, (int)total, (String)"Expected three total results");
            }
        }
    }

    @Test
    public void testThreads() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            NewTableConfiguration ntc = new NewTableConfiguration();
            switch (random.nextInt(3)) {
                case 1: {
                    ntc = ntc.withSplits(this.nss("4"));
                    break;
                }
                case 2: {
                    ntc = ntc.withSplits(this.nss("3", "5"));
                }
            }
            client.tableOperations().create(tableName, ntc);
            try (ConditionalWriter cw = client.createConditionalWriter(tableName);){
                ArrayList<ByteSequence> rows = new ArrayList<ByteSequence>();
                for (int i = 0; i < 1000; ++i) {
                    rows.add((ByteSequence)new ArrayByteSequence(FastFormat.toZeroPaddedString((long)ConditionalWriterIT.abs(random.nextLong()), (int)16, (int)16, (byte[])new byte[0])));
                }
                ArrayList<ConditionalMutation> mutations = new ArrayList<ConditionalMutation>();
                for (ByteSequence row : rows) {
                    mutations.add(new Stats(row).toMutation());
                }
                ArrayList<ArrayByteSequence> rows2 = new ArrayList<ArrayByteSequence>();
                Iterator results = cw.write(mutations.iterator());
                while (results.hasNext()) {
                    ConditionalWriter.Result result = (ConditionalWriter.Result)results.next();
                    Assertions.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)result.getStatus());
                    rows2.add(new ArrayByteSequence(result.getMutation().getRow()));
                }
                Collections.sort(rows);
                Collections.sort(rows2);
                Assertions.assertEquals(rows, rows2);
                AtomicBoolean failed = new AtomicBoolean(false);
                ExecutorService tp = Executors.newFixedThreadPool(5);
                for (int i = 0; i < 5; ++i) {
                    tp.execute(new MutatorTask(tableName, client, rows, cw, failed));
                }
                tp.shutdown();
                while (!tp.isTerminated()) {
                    tp.awaitTermination(1L, TimeUnit.MINUTES);
                }
                Assertions.assertFalse((boolean)failed.get(), (String)"A MutatorTask failed with an exception");
            }
            try (Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);){
                RowIterator rowIter = new RowIterator((Iterable)scanner);
                while (rowIter.hasNext()) {
                    Iterator row = rowIter.next();
                    new Stats(row);
                }
            }
        }
    }

    private SortedSet<Text> nss(String ... splits) {
        TreeSet<Text> ret = new TreeSet<Text>();
        for (String split : splits) {
            ret.add(new Text(split));
        }
        return ret;
    }

    @Test
    public void testSecurity() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            ClusterUser user1 = this.getUser(0);
            String user = user1.getPrincipal();
            if (ConditionalWriterIT.saslEnabled()) {
                client.securityOperations().createLocalUser(user, null);
            } else {
                client.securityOperations().createLocalUser(user, new PasswordToken((CharSequence)user1.getPassword()));
            }
            String[] tables = this.getUniqueNames(3);
            String table1 = tables[0];
            String table2 = tables[1];
            String table3 = tables[2];
            client.tableOperations().create(table1);
            client.tableOperations().create(table2);
            client.tableOperations().create(table3);
            client.securityOperations().grantTablePermission(user, table1, TablePermission.READ);
            client.securityOperations().grantTablePermission(user, table2, TablePermission.WRITE);
            client.securityOperations().grantTablePermission(user, table3, TablePermission.READ);
            client.securityOperations().grantTablePermission(user, table3, TablePermission.WRITE);
            ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq")});
            cm1.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
            cm1.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"a");
            try (AccumuloClient client2 = (AccumuloClient)Accumulo.newClient().from(client.properties()).as((CharSequence)user, user1.getToken()).build();
                 ConditionalWriter cw1 = client2.createConditionalWriter(table1);
                 ConditionalWriter cw2 = client2.createConditionalWriter(table2);
                 ConditionalWriter cw3 = client2.createConditionalWriter(table3);){
                Assertions.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw3.write(cm1).getStatus());
                Assertions.assertThrows(AccumuloSecurityException.class, () -> {
                    ConditionalWriter.Status status = cw1.write(cm1).getStatus();
                    log.error("Expected exception writing conditional mutation to table the user doesn't have write access to, Got status: {}", (Object)status);
                });
                Assertions.assertThrows(AccumuloSecurityException.class, () -> {
                    ConditionalWriter.Status status = cw2.write(cm1).getStatus();
                    log.error("Expected exception writing conditional mutation to table the user doesn't have read access to. Got status: {}", (Object)status);
                });
            }
        }
    }

    @Test
    public void testTimeout() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            String table = this.getUniqueNames(1)[0];
            client.tableOperations().create(table);
            try (ConditionalWriter cw = client.createConditionalWriter(table, new ConditionalWriterConfig().setTimeout(3L, TimeUnit.SECONDS));
                 Scanner scanner = client.createScanner(table, Authorizations.EMPTY);){
                ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq")});
                cm1.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
                cm1.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"a");
                Assertions.assertEquals((Object)cw.write(cm1).getStatus(), (Object)ConditionalWriter.Status.ACCEPTED);
                IteratorSetting is = new IteratorSetting(5, SlowIterator.class);
                SlowIterator.setSeekSleepTime(is, 5000L);
                ConditionalMutation cm2 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"1").setIterators(new IteratorSetting[]{is})});
                cm2.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"2");
                cm2.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"b");
                Assertions.assertEquals((Object)cw.write(cm2).getStatus(), (Object)ConditionalWriter.Status.UNKNOWN);
                for (Map.Entry entry : scanner) {
                    String cf = ((Key)entry.getKey()).getColumnFamilyData().toString();
                    String cq = ((Key)entry.getKey()).getColumnQualifierData().toString();
                    String val = ((Value)entry.getValue()).toString();
                    if (cf.equals("tx") && cq.equals("seq")) {
                        Assertions.assertEquals((Object)"1", (Object)val, (String)"Unexpected value in tx:seq");
                        continue;
                    }
                    if (cf.equals("data") && cq.equals("x")) {
                        Assertions.assertEquals((Object)"a", (Object)val, (String)"Unexpected value in data:x");
                        continue;
                    }
                    Assertions.fail((String)("Saw unexpected column family and qualifier: " + entry));
                }
                ConditionalMutation cm3 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"1")});
                cm3.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"2");
                cm3.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"b");
                Assertions.assertEquals((Object)cw.write(cm3).getStatus(), (Object)ConditionalWriter.Status.ACCEPTED);
            }
        }
    }

    @Test
    public void testDeleteTable() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            Assertions.assertThrows(TableNotFoundException.class, () -> client.createConditionalWriter(table), (String)"Creating conditional writer for table that doesn't exist should fail");
            client.tableOperations().create(table);
            try (ConditionalWriter cw = client.createConditionalWriter(table);){
                client.tableOperations().delete(table);
                ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq")});
                cm1.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
                cm1.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"a");
                ConditionalWriter.Result result = cw.write(cm1);
                AccumuloException ae = (AccumuloException)Assertions.assertThrows(AccumuloException.class, () -> {
                    ConditionalWriter.Status status = result.getStatus();
                    log.error("Expected exception writing conditional mutation to deleted table. Got status: {}", (Object)status);
                });
                Assertions.assertSame(TableDeletedException.class, ae.getCause().getClass());
            }
        }
    }

    @Test
    public void testOffline() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            client.tableOperations().create(table);
            try (ConditionalWriter cw = client.createConditionalWriter(table);){
                client.tableOperations().offline(table, true);
                ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq")});
                cm1.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
                cm1.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"a");
                ConditionalWriter.Result result = cw.write(cm1);
                AccumuloException ae = (AccumuloException)Assertions.assertThrows(AccumuloException.class, () -> {
                    ConditionalWriter.Status status = result.getStatus();
                    log.error("Expected exception writing conditional mutation to offline table. Got status: {}", (Object)status);
                });
                Assertions.assertSame(TableOfflineException.class, ae.getCause().getClass());
                Assertions.assertThrows(TableOfflineException.class, () -> client.createConditionalWriter(table), (String)"Expected exception creating conditional writer to offline table");
            }
        }
    }

    @Test
    public void testError() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            client.tableOperations().create(table);
            try (ConditionalWriter cw = client.createConditionalWriter(table);){
                IteratorSetting iterSetting = new IteratorSetting(5, BadIterator.class);
                ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setIterators(new IteratorSetting[]{iterSetting})});
                cm1.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
                cm1.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"a");
                ConditionalWriter.Result result = cw.write(cm1);
                Assertions.assertThrows(AccumuloException.class, () -> {
                    ConditionalWriter.Status status = result.getStatus();
                    log.error("Expected exception using iterator which throws an error, Got status: {}", (Object)status);
                });
            }
        }
    }

    @Test
    public void testNoConditions() throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            client.tableOperations().create(table);
            try (ConditionalWriter cw = client.createConditionalWriter(table);){
                ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"r1", new Condition[0]);
                cm1.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
                cm1.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"a");
                Assertions.assertThrows(IllegalArgumentException.class, () -> cw.write(cm1));
            }
        }
    }

    @Test
    public void testCreateConditionalWriterUsesClientProps() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        Properties clientProps = ConditionalWriterIT.getClientProps();
        clientProps.setProperty(ClientProperty.CONDITIONAL_WRITER_TIMEOUT_MAX.getKey(), "99");
        clientProps.setProperty(ClientProperty.CONDITIONAL_WRITER_THREADS_MAX.getKey(), "101");
        clientProps.setProperty(ClientProperty.CONDITIONAL_WRITER_DURABILITY.getKey(), Durability.NONE.name());
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(clientProps).build();){
            client.tableOperations().create(tableName);
            try (ConditionalWriterImpl cw1 = (ConditionalWriterImpl)client.createConditionalWriter(tableName);
                 ConditionalWriterImpl cw2 = (ConditionalWriterImpl)client.createConditionalWriter(tableName, new ConditionalWriterConfig().setMaxWriteThreads(200));){
                Assertions.assertEquals((long)99L, (long)cw1.getConfig().getTimeout(TimeUnit.SECONDS));
                Assertions.assertEquals((int)101, (int)cw1.getConfig().getMaxWriteThreads());
                Assertions.assertEquals((Object)Durability.NONE, (Object)cw1.getConfig().getDurability());
                Assertions.assertEquals((long)99L, (long)cw2.getConfig().getTimeout(TimeUnit.SECONDS));
                Assertions.assertEquals((int)200, (int)cw2.getConfig().getMaxWriteThreads());
                Assertions.assertEquals((Object)Durability.NONE, (Object)cw2.getConfig().getDurability());
            }
        }
    }

    private static class Callback
    implements MiniClusterConfigurationCallback {
        private Callback() {
        }

        @Override
        public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
            Map siteConf = cfg.getSiteConfig();
            cfg.setSiteConfig(siteConf);
        }
    }

    public static class AddingIterator
    extends WrappingIterator {
        long amount = 0L;

        public Value getTopValue() {
            Value val = super.getTopValue();
            long l = Long.parseLong(val.toString());
            String newVal = "" + (l + this.amount);
            return new Value((CharSequence)newVal);
        }

        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) {
            this.setSource(source);
            this.amount = Long.parseLong(options.get("amount"));
        }
    }

    public static class MultiplyingIterator
    extends WrappingIterator {
        long amount = 0L;

        public Value getTopValue() {
            Value val = super.getTopValue();
            long l = Long.parseLong(val.toString());
            String newVal = "" + l * this.amount;
            return new Value((CharSequence)newVal);
        }

        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) {
            this.setSource(source);
            this.amount = Long.parseLong(options.get("amount"));
        }
    }

    private static class Stats {
        ByteSequence row = null;
        int seq;
        long sum;
        int[] data = new int[10];

        public Stats(Iterator<Map.Entry<Key, Value>> iterator) {
            while (iterator.hasNext()) {
                Map.Entry<Key, Value> entry = iterator.next();
                if (this.row == null) {
                    this.row = entry.getKey().getRowData();
                }
                String cf = entry.getKey().getColumnFamilyData().toString();
                String cq = entry.getKey().getColumnQualifierData().toString();
                if (cf.equals("data")) {
                    this.data[Integer.parseInt((String)cq)] = Integer.parseInt(entry.getValue().toString());
                    continue;
                }
                if (!cf.equals("meta")) continue;
                if (cq.equals("sum")) {
                    this.sum = Long.parseLong(entry.getValue().toString());
                    continue;
                }
                if (!cq.equals("seq")) continue;
                this.seq = Integer.parseInt(entry.getValue().toString());
            }
            long sum2 = 0L;
            for (int datum : this.data) {
                sum2 += (long)datum;
            }
            Assertions.assertEquals((long)sum2, (long)this.sum);
        }

        public Stats(ByteSequence row) {
            this.row = row;
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = 0;
            }
            this.seq = -1;
            this.sum = 0L;
        }

        void set(int index, int value) {
            this.sum -= (long)this.data[index];
            this.sum += (long)value;
            this.data[index] = value;
        }

        ConditionalMutation toMutation() {
            Condition cond = new Condition((CharSequence)"meta", (CharSequence)"seq");
            if (this.seq >= 0) {
                cond.setValue((CharSequence)("" + this.seq));
            }
            ConditionalMutation cm = new ConditionalMutation(this.row, new Condition[]{cond});
            cm.put((CharSequence)"meta", (CharSequence)"seq", (CharSequence)("" + (this.seq + 1)));
            cm.put((CharSequence)"meta", (CharSequence)"sum", (CharSequence)("" + this.sum));
            for (int i = 0; i < this.data.length; ++i) {
                cm.put((CharSequence)"data", (CharSequence)("" + i), (CharSequence)("" + this.data[i]));
            }
            return cm;
        }

        public String toString() {
            return this.row + " " + this.seq + " " + this.sum;
        }
    }

    private static class MutatorTask
    implements Runnable {
        String tableName;
        ArrayList<ByteSequence> rows;
        ConditionalWriter cw;
        AccumuloClient client;
        AtomicBoolean failed;

        public MutatorTask(String tableName, AccumuloClient client, ArrayList<ByteSequence> rows, ConditionalWriter cw, AtomicBoolean failed) {
            this.tableName = tableName;
            this.rows = rows;
            this.client = client;
            this.cw = cw;
            this.failed = failed;
        }

        @Override
        public void run() {
            try (IsolatedScanner scanner = new IsolatedScanner(this.client.createScanner(this.tableName, Authorizations.EMPTY));){
                for (int i = 0; i < 20; ++i) {
                    int numRows = AccumuloITBase.random.nextInt(10) + 1;
                    ArrayList<ByteSequence> changes = new ArrayList<ByteSequence>(numRows);
                    ArrayList<ConditionalMutation> mutations = new ArrayList<ConditionalMutation>();
                    for (int j = 0; j < numRows; ++j) {
                        changes.add(this.rows.get(AccumuloITBase.random.nextInt(this.rows.size())));
                    }
                    for (ByteSequence row : changes) {
                        scanner.setRange(new Range((CharSequence)row.toString()));
                        Stats stats = new Stats(scanner.iterator());
                        stats.set(AccumuloITBase.random.nextInt(10), AccumuloITBase.random.nextInt(Integer.MAX_VALUE));
                        mutations.add(stats.toMutation());
                    }
                    ArrayList<ArrayByteSequence> changed = new ArrayList<ArrayByteSequence>(numRows);
                    Iterator results = this.cw.write(mutations.iterator());
                    while (results.hasNext()) {
                        ConditionalWriter.Result result = (ConditionalWriter.Result)results.next();
                        changed.add(new ArrayByteSequence(result.getMutation().getRow()));
                    }
                    Collections.sort(changes);
                    Collections.sort(changed);
                    Assertions.assertEquals(changes, changed);
                }
            }
            catch (Exception e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
                this.failed.set(true);
            }
        }
    }
}

