/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.time.Duration;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class CreateTableIT
extends SharedMiniClusterBase {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(5L);
    }

    @BeforeAll
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniCluster();
    }

    @AfterAll
    public static void teardown() {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @Test
    public void testCreateLotsOfTables() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CreateTableIT.getClientProps()).build();){
            String[] tableNames = this.getUniqueNames(500);
            for (int i = 0; i < tableNames.length; ++i) {
                long start = System.currentTimeMillis();
                client.tableOperations().create(tableNames[i]);
                System.out.println("Table creation took: " + (System.currentTimeMillis() - start) + "ms");
            }
            Assertions.assertEquals((int)503, (int)client.tableOperations().list().size());
        }
    }
}

