/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.ConcurrentModificationException;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.conf.DeprecatedPropertyUtil;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.util.SystemPropUtil;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DeprecatedPropertyUtilIT
extends ConfigurableMacBase {
    private static final String OLD_SYSTEM_PREFIX = "old.system.custom.";
    private static final DeprecatedPropertyUtil.PropertyRenamer TEST_SYS_RENAMER = DeprecatedPropertyUtil.PropertyRenamer.renamePrefix((String)"old.system.custom.", (String)Property.GENERAL_ARBITRARY_PROP_PREFIX.getKey());

    @BeforeEach
    public void setUpRenamers() throws Exception {
        super.setUp();
        TestPropertyUtil.registerTestRenamer();
    }

    @AfterEach
    public void tearDownRenamers() {
        super.tearDown();
        TestPropertyUtil.removeTestRenamer();
    }

    @Test
    public void testSystemProperty() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String oldProp = "old.system.custom.test.prop";
            String newProp = Property.GENERAL_ARBITRARY_PROP_PREFIX.getKey() + "test.prop";
            String propValue = "dummy prop value";
            Map config = client.instanceOperations().getSystemConfiguration();
            Assertions.assertFalse((boolean)config.containsKey(newProp), (String)(oldProp + " was in the config!"));
            Assertions.assertFalse((boolean)config.containsKey(newProp), (String)(newProp + " was in the config!"));
            SystemPropUtil.setSystemProperty((ServerContext)this.getServerContext(), (String)oldProp, (String)propValue);
            config = client.instanceOperations().getSystemConfiguration();
            Assertions.assertFalse((boolean)config.containsKey(oldProp), (String)(oldProp + " was in the config after set call!"));
            Assertions.assertTrue((boolean)config.containsKey(newProp), (String)(newProp + " was not in the config after set call!"));
            Assertions.assertEquals((Object)propValue, config.get(newProp));
            SystemPropUtil.removeSystemProperty((ServerContext)this.getServerContext(), (String)newProp);
            config = client.instanceOperations().getSystemConfiguration();
            Assertions.assertFalse((boolean)config.containsKey(oldProp), (String)(oldProp + " was in the config after remove call!"));
            Assertions.assertFalse((boolean)config.containsKey(newProp), (String)(newProp + " was in the config after remove call!"));
            SystemPropUtil.setSystemProperty((ServerContext)this.getServerContext(), (String)newProp, (String)propValue);
            config = client.instanceOperations().getSystemConfiguration();
            Assertions.assertFalse((boolean)config.containsKey(oldProp), (String)(oldProp + " was in the config after set call!"));
            Assertions.assertTrue((boolean)config.containsKey(newProp), (String)(newProp + " was not in the config after set call!"));
            Assertions.assertEquals((Object)propValue, config.get(newProp));
            SystemPropUtil.removeSystemProperty((ServerContext)this.getServerContext(), (String)oldProp);
            config = client.instanceOperations().getSystemConfiguration();
            Assertions.assertFalse((boolean)config.containsKey(oldProp), (String)(oldProp + " was in the config after remove call!"));
            Assertions.assertFalse((boolean)config.containsKey(newProp), (String)(newProp + " was in the config after remove call!"));
        }
    }

    @Test
    public void testModifyProperties() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String oldProp = "old.system.custom.test.prop";
            String newProp = Property.GENERAL_ARBITRARY_PROP_PREFIX.getKey() + "test.prop";
            String propValue = "dummy prop value";
            Map config = client.instanceOperations().getSystemConfiguration();
            Assertions.assertFalse((boolean)config.containsKey(newProp), (String)(oldProp + " was in the config!"));
            Assertions.assertFalse((boolean)config.containsKey(newProp), (String)(newProp + " was in the config!"));
            SystemPropUtil.modifyProperties((ServerContext)this.getServerContext(), (long)0L, Map.of(oldProp, propValue));
            config = client.instanceOperations().getSystemConfiguration();
            Assertions.assertFalse((boolean)config.containsKey(oldProp), (String)(oldProp + " was in the config after set call!"));
            Assertions.assertTrue((boolean)config.containsKey(newProp), (String)(newProp + " was not in the config after set call!"));
            Assertions.assertEquals((Object)propValue, config.get(newProp));
            try {
                SystemPropUtil.modifyProperties((ServerContext)this.getServerContext(), (long)0L, Map.of());
                Assertions.fail((String)"Expected ConcurrentModificationException as version has changed");
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
            SystemPropUtil.modifyProperties((ServerContext)this.getServerContext(), (long)1L, Map.of());
            config = client.instanceOperations().getSystemConfiguration();
            Assertions.assertFalse((boolean)config.containsKey(oldProp), (String)(oldProp + " was in the config after remove call!"));
            Assertions.assertFalse((boolean)config.containsKey(newProp), (String)(newProp + " was in the config after remove call!"));
            SystemPropUtil.modifyProperties((ServerContext)this.getServerContext(), (long)2L, Map.of(newProp, propValue));
            config = client.instanceOperations().getSystemConfiguration();
            Assertions.assertFalse((boolean)config.containsKey(oldProp), (String)(oldProp + " was in the config after set call!"));
            Assertions.assertTrue((boolean)config.containsKey(newProp), (String)(newProp + " was not in the config after set call!"));
            Assertions.assertEquals((Object)propValue, config.get(newProp));
            SystemPropUtil.modifyProperties((ServerContext)this.getServerContext(), (long)3L, Map.of());
            config = client.instanceOperations().getSystemConfiguration();
            Assertions.assertFalse((boolean)config.containsKey(oldProp), (String)(oldProp + " was in the config after remove call!"));
            Assertions.assertFalse((boolean)config.containsKey(newProp), (String)(newProp + " was in the config after remove call!"));
        }
    }

    private static class TestPropertyUtil
    extends DeprecatedPropertyUtil {
        private TestPropertyUtil() {
        }

        public static void registerTestRenamer() {
            renamers.add(TEST_SYS_RENAMER);
        }

        public static void removeTestRenamer() {
            renamers.remove(TEST_SYS_RENAMER);
        }
    }
}

