/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.Collection;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.manager.thrift.ManagerMonitorInfo;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.miniclusterImpl.ProcessReference;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DetectDeadTabletServersIT
extends ConfigurableMacBase {
    @Override
    protected void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setClientProperty(ClientProperty.INSTANCE_ZOOKEEPERS_TIMEOUT, "15s");
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            log.info("verifying that everything is up");
            try (Scanner scanner = c.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                scanner.forEach((k, v) -> {});
            }
            ManagerMonitorInfo stats = this.getStats(c);
            Assertions.assertEquals((int)2, (int)stats.tServerInfo.size());
            Assertions.assertEquals((int)0, (int)stats.badTServers.size());
            Assertions.assertEquals((int)0, (int)stats.deadTabletServers.size());
            log.info("Killing a tablet server");
            this.getCluster().killProcess(ServerType.TABLET_SERVER, (ProcessReference)((Collection)this.getCluster().getProcesses().get(ServerType.TABLET_SERVER)).iterator().next());
            while (true) {
                stats = this.getStats(c);
                if (stats.tServerInfo.size() != 2) break;
                UtilWaitThread.sleep((long)500L);
            }
            Assertions.assertEquals((int)1, (int)stats.tServerInfo.size());
            Assertions.assertEquals((int)1, (int)(stats.badTServers.size() + stats.deadTabletServers.size()));
            while (true) {
                stats = this.getStats(c);
                if (!stats.deadTabletServers.isEmpty()) break;
                UtilWaitThread.sleep((long)500L);
            }
            Assertions.assertEquals((int)1, (int)stats.tServerInfo.size());
            Assertions.assertEquals((int)0, (int)stats.badTServers.size());
            Assertions.assertEquals((int)1, (int)stats.deadTabletServers.size());
        }
    }

    private ManagerMonitorInfo getStats(AccumuloClient c) throws Exception {
        ClientContext context = (ClientContext)c;
        return (ManagerMonitorInfo)ThriftClientTypes.MANAGER.execute(context, client -> client.getManagerStats(TraceUtil.traceInfo(), context.rpcCreds()));
    }
}

