/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.time.Duration;
import java.util.Collections;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.util.Admin;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class DumpConfigIT
extends ConfigurableMacBase {
    @TempDir
    private static File tempDir;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setSiteConfig(Collections.singletonMap(Property.TABLE_FILE_BLOCK_SIZE.getKey(), "1234567"));
    }

    @Test
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="user.dir is suitable test input")
    public void test() throws Exception {
        File folder = new File(tempDir, this.testName() + "/");
        Assertions.assertTrue((folder.isDirectory() || folder.mkdir() ? 1 : 0) != 0, (String)("failed to create dir: " + folder));
        File siteFileBackup = new File(folder, "accumulo.properties.bak");
        Assertions.assertFalse((boolean)siteFileBackup.exists());
        Assertions.assertEquals((int)0, (int)this.exec(Admin.class, "dumpConfig", "-a", "-d", folder.getPath()).waitFor());
        Assertions.assertTrue((boolean)siteFileBackup.exists());
        String site = FunctionalTestUtils.readAll(new FileInputStream(siteFileBackup));
        Assertions.assertTrue((boolean)site.contains(Property.TABLE_FILE_BLOCK_SIZE.getKey()));
        Assertions.assertTrue((boolean)site.contains("1234567"));
        String meta = FunctionalTestUtils.readAll(new FileInputStream(new File(folder, MetadataTable.NAME + ".cfg")));
        Assertions.assertTrue((boolean)meta.contains(Property.TABLE_FILE_REPLICATION.getKey()));
        String systemPerm = FunctionalTestUtils.readAll(new FileInputStream(new File(folder, "root_user.cfg")));
        Assertions.assertTrue((boolean)systemPerm.contains("grant System.ALTER_USER -s -u root"));
        Assertions.assertTrue((boolean)systemPerm.contains("grant Table.READ -t " + MetadataTable.NAME + " -u root"));
        Assertions.assertFalse((boolean)systemPerm.contains("grant Table.DROP -t " + MetadataTable.NAME + " -u root"));
    }
}

