/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.time.Duration;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.fate.AdminUtil;
import org.apache.accumulo.core.fate.ReadOnlyTStore;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.fate.ZooStore;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.util.FastFormat;
import org.apache.accumulo.core.util.compaction.ExternalCompactionUtil;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.util.Admin;
import org.apache.accumulo.server.util.fateCommand.FateSummaryReport;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.functional.ReadWriteIT;
import org.apache.accumulo.test.functional.SlowIterator;
import org.apache.accumulo.test.util.Wait;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.KeeperException;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FateSummaryIT
extends ConfigurableMacBase {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
    }

    @Test
    public void testFateSummaryCommandWithSlowCompaction() throws Exception {
        this.getCluster().getClusterControl().stopAllServers(ServerType.COMPACTOR);
        Wait.waitFor(() -> ExternalCompactionUtil.getCompactorAddrs((ClientContext)this.getCluster().getServerContext()).isEmpty(), 60000L);
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String namespace = "ns1";
            String table = namespace + "." + this.getUniqueNames(1)[0];
            client.namespaceOperations().create(namespace);
            TreeSet<Text> splits = new TreeSet<Text>();
            splits.add(new Text("h"));
            splits.add(new Text("m"));
            splits.add(new Text("r"));
            splits.add(new Text("w"));
            IteratorSetting is = new IteratorSetting(1, SlowIterator.class);
            is.addOption("sleepTime", "10000");
            NewTableConfiguration cfg = new NewTableConfiguration();
            cfg.withSplits(splits);
            cfg.attachIterator(is, EnumSet.of(IteratorUtil.IteratorScope.majc));
            client.tableOperations().create(table, cfg);
            ReadWriteIT.ingest(client, 10, 10, 10, 0, table);
            client.tableOperations().flush(table, null, null, true);
            MiniAccumuloClusterImpl.ProcessInfo p = this.getCluster().exec(Admin.class, new String[]{"fate", "--summary", "-j", "-s", "NEW", "-s", "IN_PROGRESS", "-s", "FAILED"});
            Assertions.assertEquals((int)0, (int)p.getProcess().waitFor());
            String result = p.readStdOut();
            result = result.substring(result.indexOf("{"), result.lastIndexOf("}") + 1);
            FateSummaryReport report = FateSummaryReport.fromJson((String)result);
            Assertions.assertNotNull((Object)report);
            Assertions.assertNotEquals((long)0L, (long)report.getReportTime());
            HashSet<String> expected = new HashSet<String>();
            expected.add("FAILED");
            expected.add("IN_PROGRESS");
            expected.add("NEW");
            Assertions.assertEquals(expected, (Object)report.getStatusFilterNames());
            Assertions.assertEquals(Map.of(), (Object)report.getStatusCounts());
            Assertions.assertEquals(Map.of(), (Object)report.getStepCounts());
            Assertions.assertEquals(Map.of(), (Object)report.getCmdCounts());
            client.tableOperations().compact(table, null, null, false, false);
            client.tableOperations().compact(table, null, null, false, false);
            p = this.getCluster().exec(Admin.class, new String[]{"fate", "--summary", "-j"});
            Assertions.assertEquals((int)0, (int)p.getProcess().waitFor());
            result = p.readStdOut();
            result = result.substring(result.indexOf("{"), result.lastIndexOf("}") + 1);
            report = FateSummaryReport.fromJson((String)result);
            Assertions.assertNotNull((Object)report);
            Assertions.assertNotEquals((long)0L, (long)report.getReportTime());
            Assertions.assertEquals(Set.of(), (Object)report.getStatusFilterNames());
            Assertions.assertFalse((boolean)report.getStatusCounts().isEmpty());
            Assertions.assertFalse((boolean)report.getStepCounts().isEmpty());
            Assertions.assertFalse((boolean)report.getCmdCounts().isEmpty());
            Assertions.assertEquals((int)2, (int)report.getFateDetails().size());
            ArrayList txns = new ArrayList();
            report.getFateDetails().forEach(d -> txns.add(d.getTxnId()));
            Assertions.assertEquals((int)2, (int)txns.size());
            p = this.getCluster().exec(Admin.class, new String[]{"fate", (String)txns.get(0), (String)txns.get(1), "--summary", "-j"});
            Assertions.assertEquals((int)0, (int)p.getProcess().waitFor());
            result = p.readStdOut();
            result = result.substring(result.indexOf("{"), result.lastIndexOf("}") + 1);
            report = FateSummaryReport.fromJson((String)result);
            Assertions.assertNotNull((Object)report);
            Assertions.assertNotEquals((long)0L, (long)report.getReportTime());
            Assertions.assertEquals(Set.of(), (Object)report.getStatusFilterNames());
            Assertions.assertFalse((boolean)report.getStatusCounts().isEmpty());
            Assertions.assertFalse((boolean)report.getStepCounts().isEmpty());
            Assertions.assertFalse((boolean)report.getCmdCounts().isEmpty());
            Assertions.assertEquals((int)2, (int)report.getFateDetails().size());
            p = this.getCluster().exec(Admin.class, new String[]{"fate", "--summary", "-j", "-s", "FAILED"});
            Assertions.assertEquals((int)0, (int)p.getProcess().waitFor());
            result = p.readStdOut();
            result = result.substring(result.indexOf("{"), result.lastIndexOf("}") + 1);
            report = FateSummaryReport.fromJson((String)result);
            Assertions.assertNotNull((Object)report);
            Assertions.assertNotEquals((long)0L, (long)report.getReportTime());
            Assertions.assertEquals(Set.of("FAILED"), (Object)report.getStatusFilterNames());
            Assertions.assertFalse((boolean)report.getStatusCounts().isEmpty());
            Assertions.assertFalse((boolean)report.getStepCounts().isEmpty());
            Assertions.assertFalse((boolean)report.getCmdCounts().isEmpty());
            Assertions.assertEquals((int)0, (int)report.getFateDetails().size());
            client.tableOperations().delete(table);
        }
    }

    @Test
    public void testFatePrintAndSummaryCommandsWithInProgressTxns() throws Exception {
        ServerContext sctx = this.getCluster().getServerContext();
        ZooStore zs = (ZooStore)EasyMock.createMockBuilder(ZooStore.class).withConstructor(new Class[]{String.class, ZooReaderWriter.class}).withArgs(new Object[]{sctx.getZooKeeperRoot() + "/fate", sctx.getZooReaderWriter()}).addMockedMethod("top").addMockedMethod("list").createMock();
        long tx1 = zs.create();
        long tx2 = zs.create();
        long tx3 = zs.create();
        EasyMock.expect((Object)zs.list()).andReturn(List.of(Long.valueOf(tx1), Long.valueOf(tx2), Long.valueOf(tx3))).once();
        EasyMock.expect((Object)zs.top(EasyMock.anyLong())).andReturn((Object)new TestRepo()).once();
        EasyMock.expect((Object)zs.top(EasyMock.anyLong())).andThrow((Throwable)new RuntimeException((Throwable)new KeeperException.NoNodeException())).once();
        EasyMock.expect((Object)zs.top(EasyMock.anyLong())).andReturn((Object)new TestRepo()).once();
        EasyMock.replay((Object[])new Object[]{zs});
        AdminUtil.FateStatus status = null;
        try {
            status = AdminUtil.getTransactionStatus((ReadOnlyTStore)zs, null, null, new HashMap(), new HashMap());
        }
        catch (Exception e) {
            Assertions.fail((String)("Either an unexpected error occurred in getTransactionStatus() or the NoNodeException which is expected to be handled in getTransactionStatus() was not handled. Error:\n" + e));
        }
        EasyMock.verify((Object[])new Object[]{zs});
        Assertions.assertNotNull((Object)status);
        Assertions.assertEquals((int)2, (int)status.getTransactions().size());
        Assertions.assertTrue((boolean)status.getTransactions().stream().map(AdminUtil.TransactionStatus::getTxid).collect(Collectors.toList()).containsAll(List.of(FastFormat.toHexString((long)tx1), FastFormat.toHexString((long)tx3))));
    }

    private static class TestRepo
    implements Repo<String> {
        private static final long serialVersionUID = 1L;

        private TestRepo() {
        }

        public long isReady(long tid, String environment) throws Exception {
            return 0L;
        }

        public String getName() {
            return null;
        }

        public Repo<String> call(long tid, String environment) throws Exception {
            return null;
        }

        public void undo(long tid, String environment) throws Exception {
        }

        public String getReturn() {
            return null;
        }
    }
}

