/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.ArrayList;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FindMaxIT
extends AccumuloClusterHarness {
    private static Mutation nm(byte[] row) {
        Mutation m = new Mutation(new Text(row));
        m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"v");
        return m;
    }

    private static Mutation nm(String row) {
        Mutation m = new Mutation((CharSequence)row);
        m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"v");
        return m;
    }

    @Test
    public void test1() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(FindMaxIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            try (BatchWriter bw = client.createBatchWriter(tableName);){
                bw.addMutation(FindMaxIT.nm(new byte[]{0}));
                bw.addMutation(FindMaxIT.nm(new byte[]{0, 0}));
                bw.addMutation(FindMaxIT.nm(new byte[]{0, 1}));
                bw.addMutation(FindMaxIT.nm(new byte[]{0, 1, 0}));
                bw.addMutation(FindMaxIT.nm(new byte[]{1, 0}));
                bw.addMutation(FindMaxIT.nm(new byte[]{97, 98, 99}));
                bw.addMutation(FindMaxIT.nm(new byte[]{-1}));
                bw.addMutation(FindMaxIT.nm(new byte[]{-1, -1, -1, -1, -1, -1}));
                for (int i = 0; i < 1000; i += 5) {
                    bw.addMutation(FindMaxIT.nm(String.format("r%05d", i)));
                }
            }
            try (Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);){
                ArrayList<Text> rows = new ArrayList<Text>();
                for (Map.Entry entry : scanner) {
                    rows.add(((Key)entry.getKey()).getRow());
                }
                for (int i = rows.size() - 1; i > 0; --i) {
                    Text max = client.tableOperations().getMaxRow(tableName, Authorizations.EMPTY, null, true, (Text)rows.get(i), false);
                    Assertions.assertEquals(rows.get(i - 1), (Object)max);
                    max = client.tableOperations().getMaxRow(tableName, Authorizations.EMPTY, (Text)rows.get(i - 1), true, (Text)rows.get(i), false);
                    Assertions.assertEquals(rows.get(i - 1), (Object)max);
                    max = client.tableOperations().getMaxRow(tableName, Authorizations.EMPTY, (Text)rows.get(i - 1), false, (Text)rows.get(i), false);
                    Assertions.assertNull((Object)max);
                    max = client.tableOperations().getMaxRow(tableName, Authorizations.EMPTY, null, true, (Text)rows.get(i), true);
                    Assertions.assertEquals(rows.get(i), (Object)max);
                    max = client.tableOperations().getMaxRow(tableName, Authorizations.EMPTY, (Text)rows.get(i), true, (Text)rows.get(i), true);
                    Assertions.assertEquals(rows.get(i), (Object)max);
                    max = client.tableOperations().getMaxRow(tableName, Authorizations.EMPTY, (Text)rows.get(i - 1), false, (Text)rows.get(i), true);
                    Assertions.assertEquals(rows.get(i), (Object)max);
                }
                Text max = client.tableOperations().getMaxRow(tableName, Authorizations.EMPTY, null, true, null, true);
                Assertions.assertEquals(rows.get(rows.size() - 1), (Object)max);
                max = client.tableOperations().getMaxRow(tableName, Authorizations.EMPTY, null, true, new Text(new byte[]{0}), false);
                Assertions.assertNull((Object)max);
                max = client.tableOperations().getMaxRow(tableName, Authorizations.EMPTY, null, true, new Text(new byte[]{0}), true);
                Assertions.assertEquals(rows.get(0), (Object)max);
            }
        }
    }
}

