/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.admin.CloneConfiguration;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.gc.Reference;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.gc.GCRun;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.server.ServerContext;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="MiniClusterOnly")
public class GCRunIT
extends SharedMiniClusterBase {
    public static final Logger log = LoggerFactory.getLogger(GCRunIT.class);

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofSeconds(30L);
    }

    @BeforeAll
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniCluster();
    }

    @AfterAll
    public static void teardown() {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @Test
    public void goPath() throws Exception {
        String[] names = this.getUniqueNames(2);
        String table1 = names[0];
        String clone1 = names[1];
        this.fillMetadataEntries(table1, clone1);
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(GCRunIT.getClientProps()).build();){
            ServerContext context = GCRunIT.getCluster().getServerContext();
            this.scanReferences(new GCRun(Ample.DataLevel.ROOT, context));
            this.scanReferences(new GCRun(Ample.DataLevel.METADATA, context));
            this.scanReferences(new GCRun(Ample.DataLevel.USER, context));
            client.tableOperations().delete(clone1);
        }
    }

    @Test
    public void forceMissingDirTest() throws Exception {
        String[] names = this.getUniqueNames(2);
        String table1 = names[0];
        String clone1 = names[1];
        this.fillMetadataEntries(table1, clone1);
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(GCRunIT.getClientProps()).build();){
            client.securityOperations().grantTablePermission(GCRunIT.getAdminPrincipal(), MetadataTable.NAME, TablePermission.WRITE);
            String cloneId = (String)client.tableOperations().tableIdMap().get(clone1);
            Mutation m = new Mutation(new Text(cloneId + "<"));
            Text colf = new Text(MetadataSchema.TabletsSection.ServerColumnFamily.NAME);
            Text colq = new Text("dir");
            m.putDelete(colf, colq, new ColumnVisibility());
            try (BatchWriter bw = client.createBatchWriter(MetadataTable.NAME, new BatchWriterConfig().setMaxMemory(Math.max(m.estimatedMemoryUsed(), 1024L)).setMaxWriteThreads(1).setTimeout(5000L, TimeUnit.MILLISECONDS));){
                log.info("forcing delete of srv:dir with mutation {}", (Object)m.prettyPrint());
                bw.addMutation(m);
            }
            ServerContext context = GCRunIT.getCluster().getServerContext();
            this.scanReferences(new GCRun(Ample.DataLevel.ROOT, context));
            this.scanReferences(new GCRun(Ample.DataLevel.METADATA, context));
            Assertions.assertThrows(IllegalStateException.class, () -> this.scanReferences(new GCRun(Ample.DataLevel.USER, context)));
            client.tableOperations().delete(clone1);
        }
    }

    @Test
    @Disabled(value="deleting prev row causes scan to fail before row read validation")
    public void forceMissingPrevRowTest() {
    }

    private void scanReferences(GCRun userGC) {
        AtomicInteger counter = new AtomicInteger(0);
        Iterator userTableIter = userGC.getReferences().iterator();
        while (userTableIter.hasNext()) {
            Reference ref = (Reference)userTableIter.next();
            counter.incrementAndGet();
            log.trace("user ref: {}", (Object)ref);
        }
        Assertions.assertTrue((counter.get() > 0 ? 1 : 0) != 0);
    }

    private void fillMetadataEntries(String table1, String clone1) throws Exception {
        GCRunIT.getCluster().getClusterControl().stop(ServerType.GARBAGE_COLLECTOR);
        TreeSet<Text> splits = new TreeSet<Text>(List.of(new Text("3"), new Text("5"), new Text("7")));
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(GCRunIT.getClientProps()).build();){
            NewTableConfiguration ntc = new NewTableConfiguration().withSplits(splits);
            ntc.withSplits(splits);
            client.tableOperations().create(table1, ntc);
            client.tableOperations().compact(table1, new CompactionConfig().setWait(true));
            BatchWriterConfig config = new BatchWriterConfig();
            config.setMaxMemory(0L);
            try (BatchWriter writer = client.createBatchWriter(table1, config);){
                for (int i = 0; i < 10; ++i) {
                    Mutation m = new Mutation((CharSequence)(i + "_row"));
                    m.put((CharSequence)"cf", (CharSequence)"cq", new Value((CharSequence)("value " + i)));
                    writer.addMutation(m);
                }
            }
            client.tableOperations().flush(table1, null, null, true);
            client.tableOperations().clone(table1, clone1, CloneConfiguration.empty());
            client.tableOperations().compact(table1, new CompactionConfig().setWait(true));
            client.tableOperations().delete(table1);
            client.tableOperations().flush(MetadataTable.NAME, null, null, true);
            client.tableOperations().flush(RootTable.NAME, null, null, true);
        }
    }
}

