/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.time.Duration;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.RemoteIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GarbageCollectWALIT
extends ConfigurableMacBase {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(3L);
    }

    @Override
    protected void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.INSTANCE_ZK_HOST, "5s");
        cfg.setProperty(Property.GC_CYCLE_START, "1s");
        cfg.setProperty(Property.GC_CYCLE_DELAY, "1s");
        cfg.setNumTservers(1);
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Test
    public void test() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        this.cluster.getClusterControl().stop(ServerType.GARBAGE_COLLECTOR);
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            c.tableOperations().create(tableName);
            Assertions.assertEquals((int)2, (int)this.countWALsInFS(this.cluster));
            this.cluster.getClusterControl().stop(ServerType.TABLET_SERVER);
            this.cluster.getClusterControl().start(ServerType.GARBAGE_COLLECTOR);
            this.cluster.getClusterControl().start(ServerType.TABLET_SERVER);
            try (Scanner scanner = c.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                scanner.forEach((k, v) -> {});
            }
            UtilWaitThread.sleep((long)15000L);
            Assertions.assertEquals((int)2, (int)this.countWALsInFS(this.cluster));
        }
    }

    private int countWALsInFS(MiniAccumuloClusterImpl cluster) throws Exception {
        FileSystem fs = cluster.getFileSystem();
        RemoteIterator iterator = fs.listFiles(new Path(cluster.getConfig().getAccumuloDir() + "/wal"), true);
        int result = 0;
        while (iterator.hasNext()) {
            LocatedFileStatus next = (LocatedFileStatus)iterator.next();
            if (next.isDirectory()) continue;
            ++result;
        }
        return result;
    }
}

