/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.manager.thrift.DeadServer;
import org.apache.accumulo.core.manager.thrift.ManagerMonitorInfo;
import org.apache.accumulo.core.master.thrift.BulkImportStatus;
import org.apache.accumulo.core.master.thrift.RecoveryStatus;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.util.TableInfoUtil;

public class GetManagerStats {
    public static void main(String[] args) throws Exception {
        ManagerMonitorInfo stats = null;
        ServerContext context = new ServerContext(SiteConfiguration.auto());
        stats = (ManagerMonitorInfo)ThriftClientTypes.MANAGER.execute((ClientContext)context, client -> client.getManagerStats(TraceUtil.traceInfo(), context.rpcCreds()));
        GetManagerStats.out(0, "State: " + stats.state.name(), new Object[0]);
        GetManagerStats.out(0, "Goal State: " + stats.goalState.name(), new Object[0]);
        if (stats.serversShuttingDown != null && !stats.serversShuttingDown.isEmpty()) {
            GetManagerStats.out(0, "Servers to shutdown", new Object[0]);
            for (String string : stats.serversShuttingDown) {
                GetManagerStats.out(1, "%s", string);
            }
        }
        GetManagerStats.out(0, "Unassigned tablets: %d", stats.unassignedTablets);
        if (stats.badTServers != null && !stats.badTServers.isEmpty()) {
            GetManagerStats.out(0, "Bad servers", new Object[0]);
            for (Map.Entry entry : stats.badTServers.entrySet()) {
                GetManagerStats.out(1, "%s: %d", entry.getKey(), (Byte)entry.getValue());
            }
        }
        GetManagerStats.out(0, "Dead tablet servers count: %s", stats.deadTabletServers.size());
        for (DeadServer deadServer : stats.deadTabletServers) {
            GetManagerStats.out(1, "Dead tablet server: %s", deadServer.server);
            GetManagerStats.out(2, "Last report: %s", new SimpleDateFormat().format(new Date(deadServer.lastStatus)));
            GetManagerStats.out(2, "Cause: %s", deadServer.status);
        }
        GetManagerStats.out(0, "Bulk imports: %s", stats.bulkImports.size());
        for (BulkImportStatus bulkImportStatus : stats.bulkImports) {
            GetManagerStats.out(1, "Import directory: %s", bulkImportStatus.filename);
            GetManagerStats.out(2, "Bulk state %s", bulkImportStatus.state);
            GetManagerStats.out(2, "Bulk start %s", bulkImportStatus.startTime);
        }
        if (stats.tableMap != null && !stats.tableMap.isEmpty()) {
            GetManagerStats.out(0, "Tables", new Object[0]);
            for (Map.Entry entry : stats.tableMap.entrySet()) {
                TableInfo v = (TableInfo)entry.getValue();
                GetManagerStats.out(1, "%s", entry.getKey());
                GetManagerStats.out(2, "Records: %d", v.recs);
                GetManagerStats.out(2, "Records in Memory: %d", v.recsInMemory);
                GetManagerStats.out(2, "Tablets: %d", v.tablets);
                GetManagerStats.out(2, "Online Tablets: %d", v.onlineTablets);
                GetManagerStats.out(2, "Ingest Rate: %.2f", v.ingestRate);
                GetManagerStats.out(2, "Query Rate: %.2f", v.queryRate);
            }
        }
        if (stats.tServerInfo != null && !stats.tServerInfo.isEmpty()) {
            GetManagerStats.out(0, "Tablet Servers", new Object[0]);
            long now = System.currentTimeMillis();
            for (TabletServerStatus server : stats.tServerInfo) {
                TableInfo summary = TableInfoUtil.summarizeTableStats((TabletServerStatus)server);
                GetManagerStats.out(1, "Name: %s", server.name);
                GetManagerStats.out(2, "Ingest: %.2f", summary.ingestRate);
                GetManagerStats.out(2, "Last Contact: %s", server.lastContact);
                GetManagerStats.out(2, "OS Load Average: %.2f", server.osLoad);
                GetManagerStats.out(2, "Queries: %.2f", summary.queryRate);
                GetManagerStats.out(2, "Time Difference: %.1f", (double)(now - server.lastContact) / 1000.0);
                GetManagerStats.out(2, "Total Records: %d", summary.recs);
                GetManagerStats.out(2, "Lookups: %d", server.lookups);
                if (server.holdTime > 0L) {
                    GetManagerStats.out(2, "Hold Time: %d", server.holdTime);
                }
                if (server.tableMap != null && !server.tableMap.isEmpty()) {
                    GetManagerStats.out(2, "Tables", new Object[0]);
                    for (Map.Entry status : server.tableMap.entrySet()) {
                        TableInfo info = (TableInfo)status.getValue();
                        GetManagerStats.out(3, "Table: %s", status.getKey());
                        GetManagerStats.out(4, "Tablets: %d", info.onlineTablets);
                        GetManagerStats.out(4, "Records: %d", info.recs);
                        GetManagerStats.out(4, "Records in Memory: %d", info.recsInMemory);
                        GetManagerStats.out(4, "Ingest: %.2f", info.ingestRate);
                        GetManagerStats.out(4, "Queries: %.2f", info.queryRate);
                        GetManagerStats.out(4, "Major Compacting: %d", info.majors == null ? 0 : info.majors.running);
                        GetManagerStats.out(4, "Queued for Major Compaction: %d", info.majors == null ? 0 : info.majors.queued);
                        GetManagerStats.out(4, "Minor Compacting: %d", info.minors == null ? 0 : info.minors.running);
                        GetManagerStats.out(4, "Queued for Minor Compaction: %d", info.minors == null ? 0 : info.minors.queued);
                    }
                }
                GetManagerStats.out(2, "Recoveries: %d", server.logSorts.size());
                for (RecoveryStatus sort : server.logSorts) {
                    GetManagerStats.out(3, "File: %s", sort.name);
                    GetManagerStats.out(3, "Progress: %.2f%%", sort.progress * 100.0);
                    GetManagerStats.out(3, "Time running: %s", (double)sort.runtime / 1000.0);
                }
                GetManagerStats.out(3, "Bulk imports: %s", stats.bulkImports.size());
                for (BulkImportStatus bulk : stats.bulkImports) {
                    GetManagerStats.out(4, "Import file: %s", bulk.filename);
                    GetManagerStats.out(5, "Bulk state %s", bulk.state);
                    GetManagerStats.out(5, "Bulk start %s", bulk.startTime);
                }
            }
        }
    }

    private static void out(int indent, String fmtString, Object ... args) {
        for (int i = 0; i < indent; ++i) {
            System.out.print(" ");
        }
        System.out.printf(fmtString + "%n", args);
    }
}

