/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.Duration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.cluster.AccumuloCluster;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.ImportConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.manager.state.tables.TableState;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportExportIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(ImportExportIT.class);

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    @Test
    public void testExportImportThenScan() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ImportExportIT.getClientProps()).build();){
            String line;
            String[] tableNames = this.getUniqueNames(2);
            String srcTable = tableNames[0];
            String destTable = tableNames[1];
            client.tableOperations().create(srcTable);
            try (BatchWriter bw = client.createBatchWriter(srcTable);){
                for (int row = 0; row < 1000; ++row) {
                    Mutation m = new Mutation((CharSequence)Integer.toString(row));
                    for (int col = 0; col < 100; ++col) {
                        m.put((CharSequence)Integer.toString(col), (CharSequence)"", (CharSequence)Integer.toString(col * 2));
                    }
                    bw.addMutation(m);
                }
            }
            client.tableOperations().compact(srcTable, null, null, true, true);
            FileSystem fs = cluster.getFileSystem();
            log.info("Using FileSystem: " + fs);
            Path baseDir = new Path(cluster.getTemporaryPath(), this.getClass().getName());
            fs.deleteOnExit(baseDir);
            if (fs.exists(baseDir)) {
                log.info("{} exists on filesystem, deleting", (Object)baseDir);
                Assertions.assertTrue((boolean)fs.delete(baseDir, true), (String)("Failed to deleted " + baseDir));
            }
            log.info("Creating {}", (Object)baseDir);
            Assertions.assertTrue((boolean)fs.mkdirs(baseDir), (String)("Failed to create " + baseDir));
            Path exportDir = new Path(baseDir, "export");
            fs.deleteOnExit(exportDir);
            Path importDirA = new Path(baseDir, "import-a");
            Path importDirB = new Path(baseDir, "import-b");
            fs.deleteOnExit(importDirA);
            fs.deleteOnExit(importDirB);
            for (Path p : new Path[]{exportDir, importDirA, importDirB}) {
                Assertions.assertTrue((boolean)fs.mkdirs(p), (String)("Failed to create " + p));
            }
            Set<String> importDirs = Set.of(importDirA.toString(), importDirB.toString());
            Path[] importDirAry = new Path[]{importDirA, importDirB};
            log.info("Exporting table to {}", (Object)exportDir);
            log.info("Importing table from {}", importDirs);
            Assertions.assertThrows(IllegalStateException.class, () -> client.tableOperations().exportTable(srcTable, exportDir.toString()));
            client.tableOperations().offline(srcTable, true);
            client.tableOperations().exportTable(srcTable, exportDir.toString());
            Path distcp = new Path(exportDir, "distcp.txt");
            fs.deleteOnExit(distcp);
            Assertions.assertTrue((boolean)fs.exists(distcp), (String)"Distcp file doesn't exist");
            FSDataInputStream is = fs.open(distcp);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is));
            while ((line = reader.readLine()) != null) {
                Path p = new Path(line.substring(5));
                Assertions.assertTrue((boolean)fs.exists(p), (String)("File doesn't exist: " + p));
                Path importDir = importDirAry[random.nextInt(importDirAry.length)];
                Path dest = new Path(importDir, p.getName());
                Assertions.assertFalse((boolean)fs.exists(dest), (String)("Did not expect " + dest + " to exist"));
                FileUtil.copy((FileSystem)fs, (Path)p, (FileSystem)fs, (Path)dest, (boolean)false, (Configuration)fs.getConf());
            }
            reader.close();
            log.info("Import dir A: {}", (Object)Arrays.toString(fs.listStatus(importDirA)));
            log.info("Import dir B: {}", (Object)Arrays.toString(fs.listStatus(importDirB)));
            client.tableOperations().importTable(destTable, importDirs, ImportConfiguration.empty());
            String tableId = (String)client.tableOperations().tableIdMap().get(destTable);
            Assertions.assertNotNull((Object)tableId);
            log.info("Imported into table with ID: {}", (Object)tableId);
            try (Scanner s = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                s.setRange(MetadataSchema.TabletsSection.getRange((TableId)TableId.of((String)tableId)));
                s.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.fetch((ScannerBase)s);
                for (Map.Entry fileEntry : s) {
                    Key k = (Key)fileEntry.getKey();
                    String value = ((Value)fileEntry.getValue()).toString();
                    if (k.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) {
                        String fileUri = k.getColumnQualifier().toString();
                        Assertions.assertFalse((boolean)this.looksLikeRelativePath(fileUri), (String)("Imported files should have absolute URIs, not relative: " + fileUri));
                        continue;
                    }
                    if (k.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.ServerColumnFamily.NAME)) {
                        Assertions.assertFalse((boolean)this.looksLikeRelativePath(value), (String)("Server directory should have absolute URI, not relative: " + value));
                        continue;
                    }
                    Assertions.fail((String)("Got expected pair: " + k + "=" + fileEntry.getValue()));
                }
            }
            client.tableOperations().online(srcTable, true);
            this.verifyTableEquality(client, srcTable, destTable);
        }
    }

    @Test
    public void testExportImportOffline() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ImportExportIT.getClientProps()).build();){
            String line;
            String[] tableNames = this.getUniqueNames(2);
            String srcTable = tableNames[0];
            String destTable = tableNames[1];
            client.tableOperations().create(srcTable);
            try (BatchWriter bw = client.createBatchWriter(srcTable);){
                for (int row = 0; row < 1000; ++row) {
                    Mutation m = new Mutation((CharSequence)Integer.toString(row));
                    for (int col = 0; col < 100; ++col) {
                        m.put((CharSequence)Integer.toString(col), (CharSequence)"", (CharSequence)Integer.toString(col * 2));
                    }
                    bw.addMutation(m);
                }
            }
            client.tableOperations().compact(srcTable, new CompactionConfig());
            FileSystem fs = cluster.getFileSystem();
            log.info("Using FileSystem: " + fs);
            Path baseDir = new Path(cluster.getTemporaryPath(), this.getClass().getName());
            fs.deleteOnExit(baseDir);
            if (fs.exists(baseDir)) {
                log.info("{} exists on filesystem, deleting", (Object)baseDir);
                Assertions.assertTrue((boolean)fs.delete(baseDir, true), (String)("Failed to deleted " + baseDir));
            }
            log.info("Creating {}", (Object)baseDir);
            Assertions.assertTrue((boolean)fs.mkdirs(baseDir), (String)("Failed to create " + baseDir));
            Path exportDir = new Path(baseDir, "export");
            fs.deleteOnExit(exportDir);
            Path importDirA = new Path(baseDir, "import-a");
            Path importDirB = new Path(baseDir, "import-b");
            fs.deleteOnExit(importDirA);
            fs.deleteOnExit(importDirB);
            for (Path p : new Path[]{exportDir, importDirA, importDirB}) {
                Assertions.assertTrue((boolean)fs.mkdirs(p), (String)("Failed to create " + p));
            }
            Set<String> importDirs = Set.of(importDirA.toString(), importDirB.toString());
            Path[] importDirAry = new Path[]{importDirA, importDirB};
            log.info("Exporting table to {}", (Object)exportDir);
            log.info("Importing table from {}", importDirs);
            client.tableOperations().offline(srcTable, true);
            client.tableOperations().exportTable(srcTable, exportDir.toString());
            Path distcp = new Path(exportDir, "distcp.txt");
            fs.deleteOnExit(distcp);
            Assertions.assertTrue((boolean)fs.exists(distcp), (String)"Distcp file doesn't exist");
            FSDataInputStream is = fs.open(distcp);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is));
            while ((line = reader.readLine()) != null) {
                Path p = new Path(line.substring(5));
                Assertions.assertTrue((boolean)fs.exists(p), (String)("File doesn't exist: " + p));
                Path importDir = importDirAry[random.nextInt(importDirAry.length)];
                Path dest = new Path(importDir, p.getName());
                Assertions.assertFalse((boolean)fs.exists(dest), (String)("Did not expect " + dest + " to exist"));
                FileUtil.copy((FileSystem)fs, (Path)p, (FileSystem)fs, (Path)dest, (boolean)false, (Configuration)fs.getConf());
            }
            reader.close();
            log.info("Import dir A: {}", (Object)Arrays.toString(fs.listStatus(importDirA)));
            log.info("Import dir B: {}", (Object)Arrays.toString(fs.listStatus(importDirB)));
            ImportConfiguration importConfig = ImportConfiguration.builder().setKeepOffline(true).setKeepMappings(true).build();
            client.tableOperations().importTable(destTable, importDirs, importConfig);
            String tableId = (String)client.tableOperations().tableIdMap().get(destTable);
            Assertions.assertNotNull((Object)tableId);
            log.info("Imported into table with ID: {}", (Object)tableId);
            Assertions.assertFalse((boolean)client.tableOperations().isOnline(destTable), (String)"Table should have been offline.");
            Assertions.assertEquals((Object)ImportExportIT.getServerContext().getTableState(TableId.of((String)tableId)), (Object)TableState.OFFLINE);
            client.tableOperations().online(destTable, true);
            try (Scanner s = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                s.setRange(MetadataSchema.TabletsSection.getRange((TableId)TableId.of((String)tableId)));
                s.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.fetch((ScannerBase)s);
                for (Map.Entry fileEntry : s) {
                    Key k = (Key)fileEntry.getKey();
                    String value = ((Value)fileEntry.getValue()).toString();
                    if (k.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) {
                        String fileUri = k.getColumnQualifier().toString();
                        Assertions.assertFalse((boolean)this.looksLikeRelativePath(fileUri), (String)("Imported files should have absolute URIs, not relative: " + fileUri));
                        continue;
                    }
                    if (k.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.ServerColumnFamily.NAME)) {
                        Assertions.assertFalse((boolean)this.looksLikeRelativePath(value), (String)("Server directory should have absolute URI, not relative: " + value));
                        continue;
                    }
                    Assertions.fail((String)("Got expected pair: " + k + "=" + fileEntry.getValue()));
                }
            }
            client.tableOperations().online(srcTable, true);
            this.verifyTableEquality(client, srcTable, destTable);
            Assertions.assertTrue((boolean)this.verifyMappingsFile(tableId), (String)"Did not find mappings file");
        }
    }

    private boolean verifyMappingsFile(String destTableId) throws IOException {
        FileStatus[] status;
        AccumuloCluster cluster = ImportExportIT.getCluster();
        Assertions.assertTrue((boolean)(cluster instanceof MiniAccumuloClusterImpl));
        MiniAccumuloClusterImpl mac = (MiniAccumuloClusterImpl)cluster;
        String rootPath = mac.getConfig().getDir().getAbsolutePath();
        FileSystem fs = ImportExportIT.getCluster().getFileSystem();
        for (FileStatus tabletDir : status = fs.listStatus(new Path(rootPath + "/accumulo/tables/" + destTableId))) {
            FileStatus[] contents;
            for (FileStatus file : contents = fs.listStatus(tabletDir.getPath())) {
                if (!file.isFile() || !file.getPath().getName().equals("mappings.txt")) continue;
                log.debug("Found mappings file: {}", (Object)file);
                return true;
            }
        }
        return false;
    }

    private void verifyTableEquality(AccumuloClient client, String srcTable, String destTable) throws Exception {
        Iterator src = client.createScanner(srcTable, Authorizations.EMPTY).iterator();
        Iterator dest = client.createScanner(destTable, Authorizations.EMPTY).iterator();
        Assertions.assertTrue((boolean)src.hasNext(), (String)"Could not read any data from source table");
        Assertions.assertTrue((boolean)dest.hasNext(), (String)"Could not read any data from destination table");
        while (src.hasNext() && dest.hasNext()) {
            Map.Entry orig = (Map.Entry)src.next();
            Map.Entry copy = (Map.Entry)dest.next();
            Assertions.assertEquals(orig.getKey(), copy.getKey());
            Assertions.assertEquals(orig.getValue(), copy.getValue());
        }
        Assertions.assertFalse((boolean)src.hasNext(), (String)"Source table had more data to read");
        Assertions.assertFalse((boolean)dest.hasNext(), (String)"Dest table had more data to read");
    }

    private boolean looksLikeRelativePath(String uri) {
        if (uri.startsWith("/b-")) {
            return uri.charAt(10) == '/';
        }
        return uri.startsWith("/c-");
    }
}

