/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.harness.WithTestNames;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.test.functional.NativeMapIT;
import org.apache.accumulo.tserver.InMemoryMap;
import org.apache.accumulo.tserver.MemKey;
import org.apache.accumulo.tserver.memory.NativeMapLoader;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="SunnyDay")
public class InMemoryMapIT
extends WithTestNames {
    private static final Logger log = LoggerFactory.getLogger(InMemoryMapIT.class);
    @TempDir
    private static File tempDir;

    @BeforeAll
    public static void ensureNativeLibrary() {
        File nativeMapLocation = NativeMapIT.nativeMapLocation();
        NativeMapLoader.loadForTest(List.of(nativeMapLocation), () -> Assertions.fail((String)"Can't load native maps"));
    }

    public static ServerContext getServerContext() {
        ServerContext context = (ServerContext)EasyMock.createMock(ServerContext.class);
        EasyMock.replay((Object[])new Object[]{context});
        return context;
    }

    @Test
    public void testOneMutationOneKey() {
        Mutation m = new Mutation((CharSequence)"a");
        m.put((CharSequence)"1cf", (CharSequence)"1cq", (CharSequence)"vala");
        this.assertEquivalentMutate(m);
    }

    @Test
    public void testOneMutationManyKeys() {
        Mutation m = new Mutation((CharSequence)"a");
        for (int i = 1; i < 6; ++i) {
            m.put((CharSequence)("2cf" + i), (CharSequence)("2cq" + i), (CharSequence)Integer.toString(i));
        }
        this.assertEquivalentMutate(m);
    }

    @Test
    public void testOneMutationManySameKeys() {
        Mutation m = new Mutation((CharSequence)"a");
        for (int i = 1; i <= 5; ++i) {
            m.put((CharSequence)"3cf", (CharSequence)"3cq", (CharSequence)Integer.toString(i));
        }
        this.assertEquivalentMutate(m);
    }

    @Test
    public void testMultipleMutationsOneKey() {
        Mutation m1 = new Mutation((CharSequence)"a");
        m1.put((CharSequence)"4cf", (CharSequence)"4cq", (CharSequence)"vala");
        Mutation m2 = new Mutation((CharSequence)"b");
        m2.put((CharSequence)"4cf", (CharSequence)"4cq", (CharSequence)"vala");
        this.assertEquivalentMutate(Arrays.asList(m1, m2));
    }

    @Test
    public void testMultipleMutationsSameOneKey() {
        Mutation m1 = new Mutation((CharSequence)"a");
        m1.put((CharSequence)"5cf", (CharSequence)"5cq", (CharSequence)"vala");
        Mutation m2 = new Mutation((CharSequence)"a");
        m2.put((CharSequence)"5cf", (CharSequence)"5cq", (CharSequence)"vala");
        this.assertEquivalentMutate(Arrays.asList(m1, m2));
    }

    @Test
    public void testMutlipleMutationsMultipleKeys() {
        Mutation m1 = new Mutation((CharSequence)"a");
        for (int i = 1; i < 6; ++i) {
            m1.put((CharSequence)("6cf" + i), (CharSequence)("6cq" + i), (CharSequence)Integer.toString(i));
        }
        Mutation m2 = new Mutation((CharSequence)"b");
        for (int i = 1; i < 3; ++i) {
            m2.put((CharSequence)("6cf" + i), (CharSequence)("6cq" + i), (CharSequence)Integer.toString(i));
        }
        this.assertEquivalentMutate(Arrays.asList(m1, m2));
    }

    @Test
    public void testMultipleMutationsMultipleSameKeys() {
        Mutation m1 = new Mutation((CharSequence)"a");
        for (int i = 1; i < 3; ++i) {
            m1.put((CharSequence)"7cf", (CharSequence)"7cq", (CharSequence)Integer.toString(i));
        }
        Mutation m2 = new Mutation((CharSequence)"a");
        for (int i = 1; i < 4; ++i) {
            m2.put((CharSequence)"7cf", (CharSequence)"7cq", (CharSequence)Integer.toString(i));
        }
        this.assertEquivalentMutate(Arrays.asList(m1, m2));
    }

    @Test
    public void testMultipleMutationsMultipleKeysSomeSame() {
        int i;
        int i2;
        Mutation m1 = new Mutation((CharSequence)"a");
        for (i2 = 1; i2 < 2; ++i2) {
            m1.put((CharSequence)"8cf", (CharSequence)"8cq", (CharSequence)Integer.toString(i2));
        }
        for (i2 = 1; i2 < 3; ++i2) {
            m1.put((CharSequence)("8cf" + i2), (CharSequence)("8cq" + i2), (CharSequence)Integer.toString(i2));
        }
        for (i2 = 1; i2 < 2; ++i2) {
            m1.put((CharSequence)("8cf" + i2), (CharSequence)("8cq" + i2), (CharSequence)Integer.toString(i2));
        }
        Mutation m2 = new Mutation((CharSequence)"a");
        for (i = 1; i < 3; ++i) {
            m2.put((CharSequence)"8cf", (CharSequence)"8cq", (CharSequence)Integer.toString(i));
        }
        for (i = 1; i < 4; ++i) {
            m2.put((CharSequence)("8cf" + i), (CharSequence)("8cq" + i), (CharSequence)Integer.toString(i));
        }
        Mutation m3 = new Mutation((CharSequence)"b");
        for (int i3 = 1; i3 < 3; ++i3) {
            m3.put((CharSequence)("8cf" + i3), (CharSequence)("8cq" + i3), (CharSequence)Integer.toString(i3));
        }
        this.assertEquivalentMutate(Arrays.asList(m1, m2, m3));
    }

    private void assertEquivalentMutate(Mutation m) {
        this.assertEquivalentMutate(Collections.singletonList(m));
    }

    private void assertEquivalentMutate(List<Mutation> mutations) {
        String[] tempFolders = new String[4];
        for (int i = 0; i < tempFolders.length; ++i) {
            File dir = new File(tempDir, this.testName() + "_" + i);
            Assertions.assertTrue((dir.isDirectory() || dir.mkdir() ? 1 : 0) != 0);
            tempFolders[i] = dir.getAbsolutePath();
        }
        HashMap<String, String> defaultMapConfig = new HashMap<String, String>();
        defaultMapConfig.put(Property.TSERV_NATIVEMAP_ENABLED.getKey(), "false");
        defaultMapConfig.put(Property.TSERV_MEMDUMP_DIR.getKey(), tempFolders[0]);
        defaultMapConfig.put(Property.TABLE_LOCALITY_GROUPS.getKey(), "");
        HashMap<String, String> nativeMapConfig = new HashMap<String, String>();
        nativeMapConfig.put(Property.TSERV_NATIVEMAP_ENABLED.getKey(), "true");
        nativeMapConfig.put(Property.TSERV_MEMDUMP_DIR.getKey(), tempFolders[1]);
        nativeMapConfig.put(Property.TABLE_LOCALITY_GROUPS.getKey(), "");
        HashMap<String, String> localityGroupConfig = new HashMap<String, String>();
        localityGroupConfig.put(Property.TSERV_NATIVEMAP_ENABLED.getKey(), "false");
        localityGroupConfig.put(Property.TSERV_MEMDUMP_DIR.getKey(), tempFolders[2]);
        HashMap<String, String> localityGroupNativeConfig = new HashMap<String, String>();
        localityGroupNativeConfig.put(Property.TSERV_NATIVEMAP_ENABLED.getKey(), "true");
        localityGroupNativeConfig.put(Property.TSERV_MEMDUMP_DIR.getKey(), tempFolders[3]);
        TableId testId = TableId.of((String)"TEST");
        try {
            InMemoryMap defaultMap = new InMemoryMap((AccumuloConfiguration)new ConfigurationCopy(defaultMapConfig), InMemoryMapIT.getServerContext(), testId);
            InMemoryMap nativeMapWrapper = new InMemoryMap((AccumuloConfiguration)new ConfigurationCopy(nativeMapConfig), InMemoryMapIT.getServerContext(), testId);
            InMemoryMap localityGroupMap = new InMemoryMap((AccumuloConfiguration)this.updateConfigurationForLocalityGroups(new ConfigurationCopy(localityGroupConfig)), InMemoryMapIT.getServerContext(), testId);
            InMemoryMap localityGroupMapWithNative = new InMemoryMap((AccumuloConfiguration)this.updateConfigurationForLocalityGroups(new ConfigurationCopy(localityGroupNativeConfig)), InMemoryMapIT.getServerContext(), testId);
            Assertions.assertEquals((Object)"DefaultMap", (Object)defaultMap.getMapType(), (String)"Not a DefaultMap");
            Assertions.assertEquals((Object)"NativeMapWrapper", (Object)nativeMapWrapper.getMapType(), (String)"Not a NativeMapWrapper");
            Assertions.assertEquals((Object)"LocalityGroupMap", (Object)localityGroupMap.getMapType(), (String)"Not a LocalityGroupMap");
            Assertions.assertEquals((Object)"LocalityGroupMap with native", (Object)localityGroupMapWithNative.getMapType(), (String)"Not a LocalityGroupMap with native");
            int count = 0;
            for (Mutation m : mutations) {
                count += m.size();
            }
            defaultMap.mutate(mutations, count);
            nativeMapWrapper.mutate(mutations, count);
            localityGroupMap.mutate(mutations, count);
            localityGroupMapWithNative.mutate(mutations, count);
            this.assertMutatesEquivalent(mutations, defaultMap, nativeMapWrapper);
            this.assertMutatesEquivalent(mutations, defaultMap, localityGroupMap);
            this.assertMutatesEquivalent(mutations, defaultMap, localityGroupMapWithNative);
        }
        catch (Exception e) {
            log.error("Error getting new InMemoryMap ", (Throwable)e);
            Assertions.fail((String)e.getMessage());
        }
    }

    private void assertMutatesEquivalent(List<Mutation> mutations, InMemoryMap imm1, InMemoryMap imm2) {
        int mutationKVPairs = this.countKVPairs(mutations);
        List<MemKey> memKeys1 = this.getArrayOfMemKeys(imm1);
        List<MemKey> memKeys2 = this.getArrayOfMemKeys(imm2);
        Assertions.assertEquals((int)mutationKVPairs, (int)memKeys1.size(), (String)("Not all key value pairs included: " + this.dumpInMemoryMap(imm1, memKeys1)));
        Assertions.assertEquals((int)memKeys1.size(), (int)memKeys2.size(), (String)("InMemoryMaps differ in size: " + this.dumpInMemoryMap(imm1, memKeys1) + "\n" + this.dumpInMemoryMap(imm2, memKeys2)));
        Assertions.assertEquals((int)mutationKVPairs, (int)this.getUniqKVCount(memKeys1), (String)("InMemoryMap did not have distinct kvCounts " + this.dumpInMemoryMap(imm1, memKeys1)));
        Assertions.assertEquals((int)mutationKVPairs, (int)this.getUniqKVCount(memKeys2), (String)("InMemoryMap did not have distinct kvCounts " + this.dumpInMemoryMap(imm2, memKeys2)));
    }

    private int countKVPairs(List<Mutation> mutations) {
        int count = 0;
        for (Mutation m : mutations) {
            count += m.size();
        }
        return count;
    }

    private List<MemKey> getArrayOfMemKeys(InMemoryMap imm) {
        SortedKeyValueIterator skvi = imm.compactionIterator();
        ArrayList<MemKey> memKeys = new ArrayList<MemKey>();
        try {
            skvi.seek(new Range(), new ArrayList(), false);
            while (skvi.hasTop()) {
                memKeys.add((MemKey)skvi.getTopKey());
                skvi.next();
            }
        }
        catch (IOException ex) {
            log.error("Error getting memkeys", (Throwable)ex);
            throw new UncheckedIOException(ex);
        }
        return memKeys;
    }

    private String dumpInMemoryMap(InMemoryMap map, List<MemKey> memkeys) {
        StringBuilder sb = new StringBuilder();
        sb.append("InMemoryMap type ");
        sb.append(map.getMapType());
        sb.append("\n");
        for (MemKey mk : memkeys) {
            sb.append("  ");
            sb.append(mk);
            sb.append("\n");
        }
        return sb.toString();
    }

    private int getUniqKVCount(List<MemKey> memKeys) {
        ArrayList<Integer> kvCounts = new ArrayList<Integer>();
        for (MemKey m : memKeys) {
            kvCounts.add(m.getKVCount());
        }
        return Set.copyOf(kvCounts).size();
    }

    private ConfigurationCopy updateConfigurationForLocalityGroups(ConfigurationCopy configuration) {
        Map<String, Set<ByteSequence>> locGroups = this.getLocalityGroups();
        StringBuilder enabledLGs = new StringBuilder();
        for (Map.Entry<String, Set<ByteSequence>> entry : locGroups.entrySet()) {
            if (enabledLGs.length() > 0) {
                enabledLGs.append(",");
            }
            StringBuilder value = new StringBuilder();
            for (ByteSequence bytes : entry.getValue()) {
                if (value.length() > 0) {
                    value.append(",");
                }
                value.append(new String(bytes.toArray()));
            }
            configuration.set("table.group." + entry.getKey(), value.toString());
            enabledLGs.append(entry.getKey());
        }
        configuration.set(Property.TABLE_LOCALITY_GROUPS, enabledLGs.toString());
        return configuration;
    }

    private Map<String, Set<ByteSequence>> getLocalityGroups() {
        HashMap<String, Set<ByteSequence>> locgro = new HashMap<String, Set<ByteSequence>>();
        locgro.put("a", this.newCFSet("cf", "cf2"));
        locgro.put("b", this.newCFSet("cf3", "cf4"));
        return locgro;
    }

    private Set<ByteSequence> newCFSet(String ... cfs) {
        HashSet<ByteSequence> cfSet = new HashSet<ByteSequence>();
        for (String cf : cfs) {
            cfSet.add((ByteSequence)new ArrayByteSequence(cf));
        }
        return cfSet;
    }
}

