/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterators;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.ActiveScan;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.SlowIterator;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InterruptibleScannersIT
extends AccumuloClusterHarness {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(InterruptibleScannersIT.getClientProps()).build();){
            client.tableOperations().create(tableName);
            try (Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);){
                IteratorSetting cfg = new IteratorSetting(100, SlowIterator.class);
                SlowIterator.setSeekSleepTime(cfg, TimeUnit.MINUTES.toMillis(1L));
                scanner.addScanIterator(cfg);
                Thread scanThread = Thread.currentThread();
                Thread thread = new Thread(() -> {
                    try {
                        ArrayList<ActiveScan> scans;
                        String tserver = (String)client.instanceOperations().getTabletServers().iterator().next();
                        do {
                            scans = new ArrayList<ActiveScan>(client.instanceOperations().getActiveScans(tserver));
                            scans.removeIf(scan -> !InterruptibleScannersIT.getAdminPrincipal().equals(scan.getUser()) || !tableName.equals(scan.getTable()));
                        } while (scans.isEmpty());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    scanThread.interrupt();
                });
                thread.start();
                try {
                    Assertions.assertThrows(RuntimeException.class, () -> Iterators.size((Iterator)scanner.iterator()), (String)"Scan should not succeed");
                }
                finally {
                    thread.join();
                }
            }
        }
    }
}

