/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.iterators.user.IntersectingIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IsolationAndDeepCopyIT
extends AccumuloClusterHarness {
    @Test
    public void testBugFix() throws Exception {
        String table = super.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(IsolationAndDeepCopyIT.getClientProps()).build();){
            client.tableOperations().create(table);
            try (BatchWriter bw = client.createBatchWriter(table);){
                this.addDocument(bw, "000A", "dog", "cat", "hamster", "iguana", "the");
                this.addDocument(bw, "000B", "java", "perl", "C++", "pascal", "the");
                this.addDocument(bw, "000C", "chrome", "firefox", "safari", "opera", "the");
                this.addDocument(bw, "000D", "logarithmic", "quadratic", "linear", "exponential", "the");
            }
            client.tableOperations().flush(table, null, null, true);
            IteratorSetting iterCfg = new IteratorSetting(30, "ayeaye", IntersectingIterator.class.getName());
            IntersectingIterator.setColumnFamilies((IteratorSetting)iterCfg, (Text[])new Text[]{new Text("the"), new Text("hamster")});
            try (Scanner scanner = client.createScanner(table, Authorizations.EMPTY);){
                scanner.enableIsolation();
                scanner.addScanIterator(iterCfg);
                for (int i = 0; i < 100; ++i) {
                    String actual = this.getOnlyElement(scanner).getKey().getColumnQualifierData().toString();
                    Assertions.assertEquals((Object)"000A", (Object)actual);
                }
            }
        }
    }

    private void addDocument(BatchWriter bw, String docId, String ... terms) throws MutationsRejectedException {
        Mutation m = new Mutation((CharSequence)String.format("%04d", docId.hashCode() % 10));
        for (String term : terms) {
            m.put((CharSequence)term, (CharSequence)docId, (CharSequence)"");
        }
        bw.addMutation(m);
    }
}

