/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.PluginEnvironment;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;
import org.apache.accumulo.core.spi.common.ServiceEnvironment;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IteratorEnvIT
extends AccumuloClusterHarness {
    private AccumuloClient client;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
    }

    private static void testEnv(IteratorUtil.IteratorScope scope, Map<String, String> opts, IteratorEnvironment env) {
        PluginEnvironment pluginEnv;
        TableId expectedTableId = TableId.of((String)opts.get("expected.table.id"));
        ServiceEnvironment serviceEnv = env.getServiceEnv();
        if (serviceEnv != (pluginEnv = env.getPluginEnv())) {
            throw new RuntimeException("Test failed - assertSame(getServiceEnv(),getPluginEnv())");
        }
        String accTableConf = env.getConfig().get("table.custom.iterator.env.test");
        if (!"value1".equals(accTableConf)) {
            throw new RuntimeException("Test failed - Expected table property not found in getConfig().");
        }
        PluginEnvironment.Configuration tableConf = pluginEnv.getConfiguration(env.getTableId());
        if (!"value1".equals(tableConf.get("table.custom.iterator.env.test"))) {
            throw new RuntimeException("Test failed - Expected table property not found in table conf.");
        }
        if (!"value1".equals(tableConf.getTableCustom("iterator.env.test"))) {
            throw new RuntimeException("Test failed - Expected table property not found in table conf.");
        }
        PluginEnvironment.Configuration systemConf = pluginEnv.getConfiguration();
        if (systemConf.get("table.custom.iterator.env.test") != null) {
            throw new RuntimeException("Test failed - Unexpected table property found in system conf.");
        }
        if (!scope.equals((Object)env.getIteratorScope())) {
            throw new RuntimeException("Test failed - Error getting iterator scope");
        }
        if (env.isSamplingEnabled()) {
            throw new RuntimeException("Test failed - isSamplingEnabled returned true, expected false");
        }
        if (!expectedTableId.equals((Object)env.getTableId())) {
            throw new RuntimeException("Test failed - Error getting Table ID");
        }
    }

    @BeforeEach
    public void setup() {
        this.client = (AccumuloClient)Accumulo.newClient().from(IteratorEnvIT.getClientProps()).build();
    }

    @AfterEach
    public void finish() {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Test
    public void test() throws Exception {
        String[] tables = this.getUniqueNames(3);
        this.testScan(tables[0], ScanIter.class);
        this.testCompact(tables[1], MajcIter.class);
        this.testMinCompact(tables[2], MincIter.class);
    }

    private void testScan(String tableName, Class<? extends SortedKeyValueIterator<Key, Value>> iteratorClass) throws Exception {
        this.writeData(tableName);
        IteratorSetting cfg = new IteratorSetting(1, iteratorClass);
        cfg.addOption("expected.table.id", (String)this.client.tableOperations().tableIdMap().get(tableName));
        try (Scanner scan = this.client.createScanner(tableName);){
            scan.addScanIterator(cfg);
            Iterator iter = scan.iterator();
            iter.forEachRemaining(e -> Assertions.assertEquals((Object)"cf1", (Object)((Key)e.getKey()).getColumnFamily().toString()));
        }
    }

    public void testCompact(String tableName, Class<? extends SortedKeyValueIterator<Key, Value>> iteratorClass) throws Exception {
        this.writeData(tableName);
        IteratorSetting cfg = new IteratorSetting(1, iteratorClass);
        cfg.addOption("expected.table.id", (String)this.client.tableOperations().tableIdMap().get(tableName));
        CompactionConfig config = new CompactionConfig();
        config.setIterators(Collections.singletonList(cfg));
        this.client.tableOperations().compact(tableName, config);
    }

    public void testMinCompact(String tableName, Class<? extends SortedKeyValueIterator<Key, Value>> iteratorClass) throws Exception {
        this.writeData(tableName);
        IteratorSetting cfg = new IteratorSetting(1, iteratorClass);
        cfg.addOption("expected.table.id", (String)this.client.tableOperations().tableIdMap().get(tableName));
        this.client.tableOperations().attachIterator(tableName, cfg, EnumSet.of(IteratorUtil.IteratorScope.minc));
        this.client.tableOperations().flush(tableName);
    }

    private NewTableConfiguration getTableConfig() {
        NewTableConfiguration ntc = new NewTableConfiguration();
        ntc.setProperties(Collections.singletonMap("table.custom.iterator.env.test", "value1"));
        return ntc;
    }

    private void writeData(String tableName) throws Exception {
        this.client.tableOperations().create(tableName, this.getTableConfig());
        try (BatchWriter bw = this.client.createBatchWriter(tableName);){
            Mutation m = new Mutation((CharSequence)"row1");
            m.at().family((CharSequence)"cf1").qualifier((CharSequence)"cq1").put((CharSequence)"val1");
            bw.addMutation(m);
            m = new Mutation((CharSequence)"row2");
            m.at().family((CharSequence)"cf1").qualifier((CharSequence)"cq1").put((CharSequence)"val2");
            bw.addMutation(m);
            m = new Mutation((CharSequence)"row3");
            m.at().family((CharSequence)"cf1").qualifier((CharSequence)"cq1").put((CharSequence)"val3");
            bw.addMutation(m);
        }
    }

    public static class ScanIter
    extends WrappingIterator {
        IteratorUtil.IteratorScope scope = IteratorUtil.IteratorScope.scan;

        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
            super.init(source, options, env);
            IteratorEnvIT.testEnv(this.scope, options, env);
            try {
                env.isUserCompaction();
                throw new RuntimeException("Test failed - Expected to throw IllegalStateException when checking compaction on a scan.");
            }
            catch (IllegalStateException illegalStateException) {
                try {
                    env.isFullMajorCompaction();
                    throw new RuntimeException("Test failed - Expected to throw IllegalStateException when checking compaction on a scan.");
                }
                catch (IllegalStateException illegalStateException2) {
                    return;
                }
            }
        }
    }

    public static class MajcIter
    extends WrappingIterator {
        IteratorUtil.IteratorScope scope = IteratorUtil.IteratorScope.majc;

        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
            super.init(source, options, env);
            IteratorEnvIT.testEnv(this.scope, options, env);
            try {
                env.isUserCompaction();
            }
            catch (IllegalStateException e) {
                throw new RuntimeException("Test failed");
            }
            try {
                env.isFullMajorCompaction();
            }
            catch (IllegalStateException e) {
                throw new RuntimeException("Test failed");
            }
        }
    }

    public static class MincIter
    extends WrappingIterator {
        IteratorUtil.IteratorScope scope = IteratorUtil.IteratorScope.minc;

        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
            super.init(source, options, env);
            IteratorEnvIT.testEnv(this.scope, options, env);
            try {
                env.isUserCompaction();
                throw new RuntimeException("Test failed - Expected to throw IllegalStateException when checking compaction on a scan.");
            }
            catch (IllegalStateException illegalStateException) {
                try {
                    env.isFullMajorCompaction();
                    throw new RuntimeException("Test failed - Expected to throw IllegalStateException when checking compaction on a scan.");
                }
                catch (IllegalStateException illegalStateException2) {
                    return;
                }
            }
        }
    }
}

