/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KeyValueEqualityIT
extends AccumuloClusterHarness {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    @Test
    public void testEquality() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(KeyValueEqualityIT.getClientProps()).build();){
            String[] tables = this.getUniqueNames(2);
            String table1 = tables[0];
            String table2 = tables[1];
            TableOperations tops = client.tableOperations();
            tops.create(table1);
            tops.create(table2);
            try (BatchWriter bw1 = client.createBatchWriter(table1);
                 BatchWriter bw2 = client.createBatchWriter(table2);){
                for (int row = 0; row < 100; ++row) {
                    Mutation m = new Mutation((CharSequence)Integer.toString(row));
                    for (int col = 0; col < 10; ++col) {
                        m.put((CharSequence)Integer.toString(col), (CharSequence)"", System.currentTimeMillis(), (CharSequence)Integer.toString(col * 2));
                    }
                    bw1.addMutation(m);
                    bw2.addMutation(m);
                }
            }
            Iterator t1 = client.createScanner(table1, Authorizations.EMPTY).iterator();
            Iterator t2 = client.createScanner(table2, Authorizations.EMPTY).iterator();
            while (t1.hasNext() && t2.hasNext()) {
                Map.Entry e1 = (Map.Entry)t1.next();
                Map.Entry e2 = (Map.Entry)t2.next();
                Assertions.assertEquals((Object)e1, (Object)e2);
                Assertions.assertEquals((int)e1.hashCode(), (int)e2.hashCode());
            }
            Assertions.assertFalse((boolean)t1.hasNext(), (String)"table1 had more data to read");
            Assertions.assertFalse((boolean)t2.hasNext(), (String)"table2 had more data to read");
        }
    }
}

