/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.clientImpl.AccumuloServerException;
import org.apache.accumulo.core.clientImpl.Namespace;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.util.Wait;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LargeSplitRowIT
extends ConfigurableMacBase {
    private static final Logger log = LoggerFactory.getLogger(LargeSplitRowIT.class);

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
        Map<String, String> siteConfig = Map.of(Property.TSERV_MAJC_DELAY.getKey(), "50ms");
        cfg.setSiteConfig(siteConfig);
    }

    @Test
    public void userAddedSplit() throws Exception {
        log.info("User added split");
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            Map<String, String> props = Map.of(Property.TABLE_MAX_END_ROW_SIZE.getKey(), "1000");
            client.tableOperations().create(tableName, new NewTableConfiguration().setProperties(props));
            try (BatchWriter batchWriter = client.createBatchWriter(tableName);){
                Mutation m = new Mutation((CharSequence)"Row");
                m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
                batchWriter.addMutation(m);
            }
            TreeSet<Text> partitionKeys = new TreeSet<Text>();
            byte[] data = new byte[(int)(ConfigurationTypeHelper.getFixedMemoryAsBytes((String)Property.TABLE_MAX_END_ROW_SIZE.getDefaultValue()) + 2L)];
            Arrays.fill(data, (byte)109);
            partitionKeys.add(new Text(data));
            Assertions.assertThrows(AccumuloServerException.class, () -> client.tableOperations().addSplits(tableName, partitionKeys));
            try (Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);){
                Map.Entry<Key, Value> entry = this.getOnlyElement(scanner);
                Key k = entry.getKey();
                Assertions.assertEquals((Object)"Row", (Object)k.getRow().toString());
                Assertions.assertEquals((Object)"cf", (Object)k.getColumnFamily().toString());
                Assertions.assertEquals((Object)"cq", (Object)k.getColumnQualifier().toString());
                Assertions.assertEquals((Object)"value", (Object)entry.getValue().toString());
            }
        }
    }

    @Test
    @Timeout(value=60L)
    public void automaticSplitWith250Same() throws Exception {
        log.info("Automatic with 250 with same prefix");
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            Map<String, String> props = Map.of(Property.TABLE_SPLIT_THRESHOLD.getKey(), "10K", Property.TABLE_FILE_COMPRESSION_TYPE.getKey(), "none", Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE.getKey(), "64", Property.TABLE_MAX_END_ROW_SIZE.getKey(), "1000");
            client.tableOperations().create(tableName, new NewTableConfiguration().setProperties(props));
            byte[] data = new byte[(int)(ConfigurationTypeHelper.getFixedMemoryAsBytes((String)Property.TABLE_MAX_END_ROW_SIZE.getDefaultValue()) + 2L)];
            Arrays.fill(data, 0, data.length - 2, (byte)109);
            int numOfMutations = 250;
            try (BatchWriter batchWriter = client.createBatchWriter(tableName);){
                for (int i = 0; i < 250; ++i) {
                    data[data.length - 1] = (byte)i;
                    Mutation m = new Mutation(data);
                    m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
                    batchWriter.addMutation(m);
                }
            }
            client.tableOperations().flush(tableName, new Text(), new Text("z"), true);
            Thread.sleep(500L);
            int count = 0;
            try (Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);){
                for (Map.Entry entry : scanner) {
                    Key k = (Key)entry.getKey();
                    data[data.length - 1] = (byte)count;
                    String expected = new String(data, StandardCharsets.UTF_8);
                    Assertions.assertEquals((Object)expected, (Object)k.getRow().toString());
                    Assertions.assertEquals((Object)"cf", (Object)k.getColumnFamily().toString());
                    Assertions.assertEquals((Object)"cq", (Object)k.getColumnQualifier().toString());
                    Assertions.assertEquals((Object)"value", (Object)((Value)entry.getValue()).toString());
                    ++count;
                }
            }
            Assertions.assertEquals((int)250, (int)count);
            Assertions.assertTrue((boolean)client.tableOperations().listSplits(tableName).isEmpty());
        }
    }

    @Test
    @Timeout(value=60L)
    public void automaticSplitWithGaps() throws Exception {
        log.info("Automatic Split With Gaps");
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            this.automaticSplit(client, 30, 2);
        }
    }

    @Test
    @Timeout(value=60L)
    public void automaticSplitWithoutGaps() throws Exception {
        log.info("Automatic Split Without Gaps");
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            this.automaticSplit(client, 15, 1);
        }
    }

    @Test
    @Timeout(value=120L)
    public void automaticSplitLater() throws Exception {
        log.info("Split later");
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            int max = 15;
            this.automaticSplit(client, 15, 1);
            Predicate<String> isNotNamespaceTable = table -> !table.startsWith(Namespace.ACCUMULO.name() + ".");
            String tableName = client.tableOperations().list().stream().filter(isNotNamespaceTable).findAny().orElseGet(() -> (String)Assertions.fail((String)"couldn't find a table"));
            try (BatchWriter batchWriter = client.createBatchWriter(tableName);){
                byte[] data = new byte[10];
                for (int j = 15; j < 150; ++j) {
                    Arrays.fill(data, 0, data.length - 2, (byte)j);
                    for (int i = 0; i < 25; ++i) {
                        data[data.length - 1] = (byte)i;
                        Mutation m = new Mutation(data);
                        m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
                        batchWriter.addMutation(m);
                    }
                }
            }
            client.tableOperations().flush(tableName, new Text(), new Text("z"), true);
            Wait.Condition splitsToBePresent = () -> client.tableOperations().listSplits(tableName).stream().findAny().isPresent();
            Wait.waitFor(splitsToBePresent, TimeUnit.SECONDS.toMillis(60L), 250L);
        }
    }

    private void automaticSplit(AccumuloClient client, int max, int spacing) throws Exception {
        Map<String, String> props = Map.of(Property.TABLE_SPLIT_THRESHOLD.getKey(), "10K", Property.TABLE_FILE_COMPRESSION_TYPE.getKey(), "none", Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE.getKey(), "64", Property.TABLE_MAX_END_ROW_SIZE.getKey(), "1000");
        String tableName = this.getUniqueNames(1)[0];
        client.tableOperations().create(tableName, new NewTableConfiguration().setProperties(props));
        byte[] data = new byte[(int)(ConfigurationTypeHelper.getFixedMemoryAsBytes((String)Property.TABLE_MAX_END_ROW_SIZE.getDefaultValue()) + 2L)];
        int numOfMutations = 10;
        try (BatchWriter batchWriter = client.createBatchWriter(tableName);){
            for (int j = 0; j < max; j += spacing) {
                Arrays.fill(data, 0, data.length - 2, (byte)j);
                for (int i = 0; i < 10; ++i) {
                    data[data.length - 1] = (byte)i;
                    Mutation m = new Mutation(data);
                    m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
                    batchWriter.addMutation(m);
                }
            }
        }
        client.tableOperations().flush(tableName, new Text(), new Text("z"), true);
        Thread.sleep(500L);
        int count = 0;
        int extra = 10;
        try (Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);){
            for (Map.Entry entry : scanner) {
                if (extra == 10) {
                    extra = 0;
                    Arrays.fill(data, 0, data.length - 2, (byte)count);
                    count += spacing;
                }
                Key k = (Key)entry.getKey();
                data[data.length - 1] = (byte)extra;
                String expected = new String(data, StandardCharsets.UTF_8);
                Assertions.assertEquals((Object)expected, (Object)k.getRow().toString());
                Assertions.assertEquals((Object)"cf", (Object)k.getColumnFamily().toString());
                Assertions.assertEquals((Object)"cq", (Object)k.getColumnQualifier().toString());
                Assertions.assertEquals((Object)"value", (Object)((Value)entry.getValue()).toString());
                ++extra;
            }
        }
        Assertions.assertEquals((int)10, (int)extra);
        Assertions.assertEquals((int)max, (int)count);
        Assertions.assertTrue((boolean)client.tableOperations().listSplits(tableName).isEmpty());
    }
}

