/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.admin.Locations;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.TabletIdImpl;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LocatorIT
extends AccumuloClusterHarness {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    private void assertContains(Locations locations, HashSet<String> tservers, Map<Range, Set<TabletId>> expected1, Map<TabletId, Set<Range>> expected2) {
        HashMap gbr = new HashMap();
        for (Map.Entry entry : locations.groupByRange().entrySet()) {
            gbr.put((Range)entry.getKey(), new HashSet((Collection)entry.getValue()));
        }
        Assertions.assertEquals(expected1, gbr);
        HashMap gbt = new HashMap();
        for (Map.Entry entry : locations.groupByTablet().entrySet()) {
            gbt.put((TabletId)entry.getKey(), new HashSet((Collection)entry.getValue()));
            TabletId tid = (TabletId)entry.getKey();
            String location = locations.getTabletLocation(tid);
            Assertions.assertNotNull((Object)location, (String)("Location for " + tid + " was null"));
            Assertions.assertTrue((boolean)tservers.contains(location), (String)("Unknown location " + location));
            Assertions.assertEquals((int)2, (int)location.split(":").length, (String)("Expected <host>:<port> " + location));
        }
        Assertions.assertEquals(expected2, gbt);
    }

    private static TabletId newTabletId(String tableId, String endRow, String prevRow) {
        return new TabletIdImpl(new KeyExtent(TableId.of((String)tableId), endRow == null ? null : new Text(endRow), prevRow == null ? null : new Text(prevRow)));
    }

    @Test
    public void testBasic() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(LocatorIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            TableOperations tableOps = client.tableOperations();
            tableOps.create(tableName);
            Range r1 = new Range((CharSequence)"m");
            Range r2 = new Range((CharSequence)"o", (CharSequence)"x");
            String tableId = (String)tableOps.tableIdMap().get(tableName);
            TabletId t1 = LocatorIT.newTabletId(tableId, null, null);
            TabletId t2 = LocatorIT.newTabletId(tableId, "r", null);
            TabletId t3 = LocatorIT.newTabletId(tableId, null, "r");
            ArrayList<Range> ranges = new ArrayList<Range>();
            HashSet<String> tservers = new HashSet<String>(client.instanceOperations().getTabletServers());
            ranges.add(r1);
            Locations ret = tableOps.locate(tableName, ranges);
            this.assertContains(ret, tservers, Map.of(r1, Set.of(t1)), Map.of(t1, Set.of(r1)));
            ranges.add(r2);
            ret = tableOps.locate(tableName, ranges);
            this.assertContains(ret, tservers, Map.of(r1, Set.of(t1), r2, Set.of(t1)), Map.of(t1, Set.of(r1, r2)));
            TreeSet<Text> splits = new TreeSet<Text>();
            splits.add(new Text("r"));
            tableOps.addSplits(tableName, splits);
            ret = tableOps.locate(tableName, ranges);
            this.assertContains(ret, tservers, Map.of(r1, Set.of(t2), r2, Set.of(t2, t3)), Map.of(t2, Set.of(r1, r2), t3, Set.of(r2)));
            tableOps.offline(tableName, true);
            Assertions.assertThrows(TableOfflineException.class, () -> tableOps.locate(tableName, (Collection)ranges));
            tableOps.delete(tableName);
            Assertions.assertThrows(TableNotFoundException.class, () -> tableOps.locate(tableName, (Collection)ranges));
        }
    }
}

