/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.TabletLocationState;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.miniclusterImpl.ProcessReference;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.manager.state.ClosableIterator;
import org.apache.accumulo.server.manager.state.TabletStateStore;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagerRepairsDualAssignmentIT
extends ConfigurableMacBase {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(5L);
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setProperty(Property.MANAGER_RECOVERY_DELAY, "5s");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            boolean allAssigned;
            ClientContext context = (ClientContext)c;
            ServerContext serverContext = this.cluster.getServerContext();
            String table = this.getUniqueNames(1)[0];
            c.securityOperations().grantTablePermission("root", MetadataTable.NAME, TablePermission.WRITE);
            c.securityOperations().grantTablePermission("root", RootTable.NAME, TablePermission.WRITE);
            TreeSet<Text> partitions = new TreeSet<Text>();
            for (String part : "a b c d e f g h i j k l m n o p q r s t u v w x y z".split(" ")) {
                partitions.add(new Text(part));
            }
            NewTableConfiguration ntc = new NewTableConfiguration().withSplits(partitions);
            c.tableOperations().create(table, ntc);
            HashSet<TabletMetadata.Location> states = new HashSet<TabletMetadata.Location>();
            HashSet<TabletLocationState> oldLocations = new HashSet<TabletLocationState>();
            TabletStateStore store = TabletStateStore.getStoreForLevel((Ample.DataLevel)Ample.DataLevel.USER, (ClientContext)context);
            while (states.size() < 2) {
                UtilWaitThread.sleep((long)250L);
                oldLocations.clear();
                for (TabletLocationState tls : store) {
                    if (tls.current == null) continue;
                    states.add(tls.current);
                    oldLocations.add(tls);
                }
            }
            Assertions.assertEquals((int)2, (int)states.size());
            this.cluster.killProcess(ServerType.TABLET_SERVER, (ProcessReference)((Collection)this.cluster.getProcesses().get(ServerType.TABLET_SERVER)).iterator().next());
            HashSet<TabletMetadata.Location> replStates = new HashSet<TabletMetadata.Location>();
            TableId repTable = ReplicationTable.ID;
            do {
                UtilWaitThread.sleep((long)1000L);
                states.clear();
                replStates.clear();
                allAssigned = true;
                for (TabletLocationState tls : store) {
                    if (tls != null && tls.current != null) {
                        states.add(tls.current);
                        continue;
                    }
                    if (tls != null && tls.extent.equals((Object)new KeyExtent(repTable, null, null))) {
                        replStates.add(tls.current);
                        continue;
                    }
                    allAssigned = false;
                }
                System.out.println(states + " size " + states.size() + " allAssigned " + allAssigned);
            } while (states.size() == 2 || !allAssigned);
            Assertions.assertEquals((int)1, (int)replStates.size());
            Assertions.assertEquals((int)1, (int)states.size());
            TabletLocationState moved = null;
            for (TabletLocationState old : oldLocations) {
                if (states.contains(old.current)) continue;
                moved = old;
            }
            Assertions.assertNotEquals(null, moved);
            Ample.TabletMutator tabletMutator = serverContext.getAmple().mutateTablet(moved.extent);
            tabletMutator.putLocation(moved.current);
            tabletMutator.mutate();
            this.waitForCleanStore(store);
            tabletMutator = serverContext.getAmple().mutateTablet(new KeyExtent(MetadataTable.ID, null, null));
            tabletMutator.putLocation(moved.current);
            tabletMutator.mutate();
            this.waitForCleanStore(TabletStateStore.getStoreForLevel((Ample.DataLevel)Ample.DataLevel.METADATA, (ClientContext)context));
        }
    }

    private void waitForCleanStore(TabletStateStore store) {
        while (true) {
            try (ClosableIterator iter = store.iterator();){
                iter.forEachRemaining(t -> {});
            }
            catch (Exception ex) {
                System.out.println(ex);
                UtilWaitThread.sleep((long)250L);
                continue;
            }
            break;
        }
    }
}

