/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.time.Duration;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MetaConstraintRetryIT
extends AccumuloClusterHarness {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofSeconds(30L);
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(MetaConstraintRetryIT.getClientProps()).build();){
            client.securityOperations().grantTablePermission(MetaConstraintRetryIT.getAdminPrincipal(), MetadataTable.NAME, TablePermission.WRITE);
            ServerContext context = MetaConstraintRetryIT.getServerContext();
            KeyExtent extent = new KeyExtent(TableId.of((String)"5"), null, null);
            Mutation m = new Mutation(extent.toMetaRow());
            m.put((CharSequence)"badcolfam", (CharSequence)"badcolqual", (CharSequence)"3");
            IllegalArgumentException iae = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> MetadataTableUtil.update((ServerContext)context, null, (Mutation)m, (KeyExtent)extent));
            Assertions.assertEquals(MutationsRejectedException.class, iae.getCause().getClass());
            MutationsRejectedException mre = (MutationsRejectedException)iae.getCause();
            Assertions.assertFalse((boolean)mre.getConstraintViolationSummaries().isEmpty());
        }
    }
}

