/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.time.Duration;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.functional.SlowIterator;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.Assertions;

public class MetaGetsReadersIT
extends ConfigurableMacBase {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
        cfg.setProperty(Property.TSERV_SCAN_MAX_OPENFILES, "2");
        cfg.setProperty(Property.TABLE_BLOCKCACHE_ENABLED, "false");
    }

    private static Thread slowScan(AccumuloClient c, String tableName, AtomicBoolean stop) {
        return new Thread(() -> {
            try {
                while (!stop.get()) {
                    Scanner s = c.createScanner(tableName, Authorizations.EMPTY);
                    try {
                        IteratorSetting is = new IteratorSetting(50, SlowIterator.class);
                        SlowIterator.setSleepTime(is, 10L);
                        s.addScanIterator(is);
                        Iterator iterator = s.iterator();
                        while (iterator.hasNext() && !stop.get()) {
                            iterator.next();
                        }
                    }
                    finally {
                        if (s == null) continue;
                        s.close();
                    }
                }
                return;
            }
            catch (Exception ex) {
                log.trace("{}", (Object)ex.getMessage(), (Object)ex);
                stop.set(true);
            }
        });
    }

    public void test() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            c.tableOperations().create(tableName);
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                for (int i = 0; i < 50000; ++i) {
                    byte[] row = new byte[100];
                    random.nextBytes(row);
                    Mutation m = new Mutation(row);
                    m.put((CharSequence)"", (CharSequence)"", (CharSequence)"");
                    bw.addMutation(m);
                }
            }
            c.tableOperations().flush(tableName, null, null, true);
            AtomicBoolean stop = new AtomicBoolean(false);
            Thread t1 = MetaGetsReadersIT.slowScan(c, tableName, stop);
            t1.start();
            Thread t2 = MetaGetsReadersIT.slowScan(c, tableName, stop);
            t2.start();
            UtilWaitThread.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
            long now = System.currentTimeMillis();
            try (Scanner s = c.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                s.forEach((k, v) -> {});
            }
            long delay = System.currentTimeMillis() - now;
            System.out.println("Delay = " + delay);
            Assertions.assertTrue((delay < 1000L ? 1 : 0) != 0, (String)"metadata table scan was slow");
            Assertions.assertFalse((boolean)stop.get());
            stop.set(true);
            t1.interrupt();
            t2.interrupt();
            t1.join();
            t2.join();
        }
    }
}

