/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaSplitIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(MetaSplitIT.class);
    private Collection<Text> metadataSplits = null;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(3L);
    }

    @BeforeEach
    public void saveMetadataSplits() throws Exception {
        if (MetaSplitIT.getClusterType() == AccumuloClusterHarness.ClusterType.STANDALONE) {
            try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(MetaSplitIT.getClientProps()).build();){
                Collection splits = client.tableOperations().listSplits(MetadataTable.NAME);
                if (!splits.equals(Arrays.asList(new Text("~")))) {
                    log.info("Existing splits on metadata table. Saving them, and applying single original split of '~'");
                    this.metadataSplits = splits;
                    client.tableOperations().merge(MetadataTable.NAME, null, null);
                    client.tableOperations().addSplits(MetadataTable.NAME, new TreeSet<Text>(Collections.singleton(new Text("~"))));
                }
            }
        }
    }

    @AfterEach
    public void restoreMetadataSplits() throws Exception {
        if (this.metadataSplits != null) {
            log.info("Restoring split on metadata table");
            try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(MetaSplitIT.getClientProps()).build();){
                client.tableOperations().merge(MetadataTable.NAME, null, null);
                client.tableOperations().addSplits(MetadataTable.NAME, new TreeSet<Text>(this.metadataSplits));
            }
        }
    }

    @Test
    public void testRootTableSplit() {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(MetaSplitIT.getClientProps()).build();){
            TreeSet<Text> splits = new TreeSet<Text>();
            splits.add(new Text("5"));
            Assertions.assertThrows(AccumuloException.class, () -> client.tableOperations().addSplits(RootTable.NAME, splits));
        }
    }

    @Test
    public void testRootTableMerge() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(MetaSplitIT.getClientProps()).build();){
            client.tableOperations().merge(RootTable.NAME, null, null);
        }
    }

    private void addSplits(TableOperations opts, String ... points) throws Exception {
        TreeSet<Text> splits = new TreeSet<Text>();
        for (String point : points) {
            splits.add(new Text(point));
        }
        opts.addSplits(MetadataTable.NAME, splits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetadataTableSplit() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(MetaSplitIT.getClientProps()).build();){
            int i;
            TableOperations opts = client.tableOperations();
            for (i = 1; i <= 10; ++i) {
                opts.create(Integer.toString(i));
            }
            try {
                opts.merge(MetadataTable.NAME, new Text("01"), new Text("02"));
                MetaSplitIT.checkMetadataSplits(1, opts);
                this.addSplits(opts, "4 5 6 7 8".split(" "));
                MetaSplitIT.checkMetadataSplits(6, opts);
                opts.merge(MetadataTable.NAME, new Text("6"), new Text("9"));
                MetaSplitIT.checkMetadataSplits(4, opts);
                this.addSplits(opts, "44 55 66 77 88".split(" "));
                MetaSplitIT.checkMetadataSplits(9, opts);
                opts.merge(MetadataTable.NAME, new Text("5"), new Text("7"));
                MetaSplitIT.checkMetadataSplits(6, opts);
                opts.merge(MetadataTable.NAME, null, null);
                MetaSplitIT.checkMetadataSplits(0, opts);
            }
            finally {
                for (i = 1; i <= 10; ++i) {
                    opts.delete(Integer.toString(i));
                }
            }
        }
    }

    private static void checkMetadataSplits(int numSplits, TableOperations opts) throws AccumuloSecurityException, TableNotFoundException, AccumuloException, InterruptedException {
        for (int i = 0; i < 10 && opts.listSplits(MetadataTable.NAME).size() != numSplits; ++i) {
            Thread.sleep(2000L);
        }
        Collection splits = opts.listSplits(MetadataTable.NAME);
        Assertions.assertEquals((int)numSplits, (int)splits.size(), (String)("Actual metadata table splits: " + splits));
    }
}

