/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterables;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.UUID;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MissingWalHeaderCompletesRecoveryIT
extends ConfigurableMacBase {
    private static final Logger log = LoggerFactory.getLogger(MissingWalHeaderCompletesRecoveryIT.class);
    private boolean rootHasWritePermission;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration conf) {
        cfg.setNumTservers(1);
        cfg.setProperty(Property.MANAGER_RECOVERY_DELAY, "1s");
        cfg.setProperty(Property.GC_CYCLE_START, "999999s");
        conf.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @BeforeEach
    public void setupMetadataPermission() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            this.rootHasWritePermission = client.securityOperations().hasTablePermission("root", MetadataTable.NAME, TablePermission.WRITE);
            if (!this.rootHasWritePermission) {
                client.securityOperations().grantTablePermission("root", MetadataTable.NAME, TablePermission.WRITE);
                Thread.sleep(5000L);
            }
        }
    }

    @AfterEach
    public void resetMetadataPermission() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            if (this.rootHasWritePermission != client.securityOperations().hasTablePermission("root", MetadataTable.NAME, TablePermission.WRITE)) {
                if (this.rootHasWritePermission) {
                    client.securityOperations().grantTablePermission("root", MetadataTable.NAME, TablePermission.WRITE);
                } else {
                    client.securityOperations().revokeTablePermission("root", MetadataTable.NAME, TablePermission.WRITE);
                }
            }
        }
    }

    @Test
    public void testEmptyWalRecoveryCompletes() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            MiniAccumuloClusterImpl cluster = this.getCluster();
            FileSystem fs = cluster.getFileSystem();
            String fakeServer = "127.0.0.1:12345";
            File walogs = new File(cluster.getConfig().getAccumuloDir(), "wal");
            File walogServerDir = new File(walogs, fakeServer.replace(':', '+'));
            File emptyWalog = new File(walogServerDir, UUID.randomUUID().toString());
            log.info("Created empty WAL at {}", (Object)emptyWalog.toURI());
            fs.create(new Path(emptyWalog.toURI())).close();
            Assertions.assertTrue((boolean)client.securityOperations().hasTablePermission("root", MetadataTable.NAME, TablePermission.WRITE), (String)"root user did not have write permission to metadata table");
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            TableId tableId = TableId.of((String)((String)client.tableOperations().tableIdMap().get(tableName)));
            Assertions.assertNotNull((Object)tableId, (String)"Table ID was null");
            LogEntry logEntry = new LogEntry(new KeyExtent(tableId, null, null), 0L, emptyWalog.toURI().toString());
            log.info("Taking {} offline", (Object)tableName);
            client.tableOperations().offline(tableName, true);
            log.info("{} is offline", (Object)tableName);
            Text row = MetadataSchema.TabletsSection.encodeRow((TableId)tableId, null);
            Mutation m = new Mutation(row);
            m.put(logEntry.getColumnFamily(), logEntry.getColumnQualifier(), logEntry.getValue());
            try (BatchWriter bw = client.createBatchWriter(MetadataTable.NAME);){
                bw.addMutation(m);
            }
            log.info("Bringing {} online", (Object)tableName);
            client.tableOperations().online(tableName, true);
            log.info("{} is online", (Object)tableName);
            try (Scanner s = client.createScanner(tableName, Authorizations.EMPTY);){
                Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)s));
            }
        }
    }

    @Test
    public void testPartialHeaderWalRecoveryCompletes() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            MiniAccumuloClusterImpl cluster = this.getCluster();
            FileSystem fs = this.getCluster().getFileSystem();
            String fakeServer = "127.0.0.1:12345";
            File walogs = new File(cluster.getConfig().getAccumuloDir(), "wal");
            File walogServerDir = new File(walogs, fakeServer.replace(':', '+'));
            File partialHeaderWalog = new File(walogServerDir, UUID.randomUUID().toString());
            log.info("Created WAL with malformed header at {}", (Object)partialHeaderWalog.toURI());
            FSDataOutputStream wal = fs.create(new Path(partialHeaderWalog.toURI()));
            wal.write("--- Log File Header (v4) ---".getBytes(StandardCharsets.UTF_8), 0, "--- Log File Header (v4) ---".length() / 2);
            wal.close();
            Assertions.assertTrue((boolean)client.securityOperations().hasTablePermission("root", MetadataTable.NAME, TablePermission.WRITE), (String)"root user did not have write permission to metadata table");
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            TableId tableId = TableId.of((String)((String)client.tableOperations().tableIdMap().get(tableName)));
            Assertions.assertNotNull((Object)tableId, (String)"Table ID was null");
            LogEntry logEntry = new LogEntry(null, 0L, partialHeaderWalog.toURI().toString());
            log.info("Taking {} offline", (Object)tableName);
            client.tableOperations().offline(tableName, true);
            log.info("{} is offline", (Object)tableName);
            Text row = MetadataSchema.TabletsSection.encodeRow((TableId)tableId, null);
            Mutation m = new Mutation(row);
            m.put(logEntry.getColumnFamily(), logEntry.getColumnQualifier(), logEntry.getValue());
            try (BatchWriter bw = client.createBatchWriter(MetadataTable.NAME);){
                bw.addMutation(m);
            }
            log.info("Bringing {} online", (Object)tableName);
            client.tableOperations().online(tableName, true);
            log.info("{} is online", (Object)tableName);
            try (Scanner s = client.createScanner(tableName, Authorizations.EMPTY);){
                Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)s));
            }
        }
    }
}

