/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Maps;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MultiTableBatchWriterIT
extends AccumuloClusterHarness {
    private AccumuloClient accumuloClient;
    private MultiTableBatchWriter mtbw;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(5L);
    }

    @BeforeEach
    public void setUpArgs() {
        this.accumuloClient = (AccumuloClient)Accumulo.newClient().from(MultiTableBatchWriterIT.getClientProps()).build();
        this.mtbw = this.getMultiTableBatchWriter();
    }

    @AfterEach
    public void closeClient() {
        this.accumuloClient.close();
    }

    public MultiTableBatchWriter getMultiTableBatchWriter() {
        return this.accumuloClient.createMultiTableBatchWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableRenameDataValidation() throws Exception {
        try {
            String[] names = this.getUniqueNames(2);
            String table1 = names[0];
            String table2 = names[1];
            TableOperations tops = this.accumuloClient.tableOperations();
            tops.create(table1);
            BatchWriter bw1 = this.mtbw.getBatchWriter(table1);
            Mutation m1 = new Mutation((CharSequence)"foo");
            m1.put((CharSequence)"col1", (CharSequence)"", (CharSequence)"val1");
            bw1.addMutation(m1);
            tops.rename(table1, table2);
            tops.create(table1);
            BatchWriter bw2 = this.mtbw.getBatchWriter(table1);
            Mutation m2 = new Mutation((CharSequence)"bar");
            m2.put((CharSequence)"col1", (CharSequence)"", (CharSequence)"val1");
            bw1.addMutation(m2);
            bw2.addMutation(m2);
            this.mtbw.close();
            HashMap<Map.Entry, String> table1Expectations = new HashMap<Map.Entry, String>();
            table1Expectations.put(Maps.immutableEntry((Object)"bar", (Object)"col1"), "val1");
            HashMap<Map.Entry, String> table2Expectations = new HashMap<Map.Entry, String>();
            table2Expectations.put(Maps.immutableEntry((Object)"foo", (Object)"col1"), "val1");
            table2Expectations.put(Maps.immutableEntry((Object)"bar", (Object)"col1"), "val1");
            HashMap<Map.Entry, String> actual = new HashMap<Map.Entry, String>();
            try (Scanner s = this.accumuloClient.createScanner(table1, new Authorizations());){
                s.setRange(new Range());
                for (Map.Entry entry : s) {
                    actual.put(Maps.immutableEntry((Object)((Key)entry.getKey()).getRow().toString(), (Object)((Key)entry.getKey()).getColumnFamily().toString()), ((Value)entry.getValue()).toString());
                }
                Assertions.assertEquals(table1Expectations, actual, (String)("Differing results for " + table1));
            }
            s = this.accumuloClient.createScanner(table2, new Authorizations());
            try {
                s.setRange(new Range());
                actual = new HashMap();
                for (Map.Entry entry : s) {
                    actual.put(Maps.immutableEntry((Object)((Key)entry.getKey()).getRow().toString(), (Object)((Key)entry.getKey()).getColumnFamily().toString()), ((Value)entry.getValue()).toString());
                }
                Assertions.assertEquals(table2Expectations, actual, (String)("Differing results for " + table2));
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        finally {
            if (this.mtbw != null) {
                this.mtbw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableRenameSameWriters() throws Exception {
        try {
            String[] names = this.getUniqueNames(4);
            String table1 = names[0];
            String table2 = names[1];
            String newTable1 = names[2];
            String newTable2 = names[3];
            TableOperations tops = this.accumuloClient.tableOperations();
            tops.create(table1);
            tops.create(table2);
            BatchWriter bw1 = this.mtbw.getBatchWriter(table1);
            BatchWriter bw2 = this.mtbw.getBatchWriter(table2);
            Mutation m1 = new Mutation((CharSequence)"foo");
            m1.put((CharSequence)"col1", (CharSequence)"", (CharSequence)"val1");
            m1.put((CharSequence)"col2", (CharSequence)"", (CharSequence)"val2");
            bw1.addMutation(m1);
            bw2.addMutation(m1);
            tops.rename(table1, newTable1);
            tops.rename(table2, newTable2);
            Mutation m2 = new Mutation((CharSequence)"bar");
            m2.put((CharSequence)"col1", (CharSequence)"", (CharSequence)"val1");
            m2.put((CharSequence)"col2", (CharSequence)"", (CharSequence)"val2");
            bw1.addMutation(m2);
            bw2.addMutation(m2);
            this.mtbw.close();
            HashMap<Map.Entry, String> expectations = new HashMap<Map.Entry, String>();
            expectations.put(Maps.immutableEntry((Object)"foo", (Object)"col1"), "val1");
            expectations.put(Maps.immutableEntry((Object)"foo", (Object)"col2"), "val2");
            expectations.put(Maps.immutableEntry((Object)"bar", (Object)"col1"), "val1");
            expectations.put(Maps.immutableEntry((Object)"bar", (Object)"col2"), "val2");
            for (String table : Arrays.asList(newTable1, newTable2)) {
                Scanner s = this.accumuloClient.createScanner(table, new Authorizations());
                try {
                    s.setRange(new Range());
                    HashMap<Map.Entry, String> actual = new HashMap<Map.Entry, String>();
                    for (Map.Entry entry : s) {
                        actual.put(Maps.immutableEntry((Object)((Key)entry.getKey()).getRow().toString(), (Object)((Key)entry.getKey()).getColumnFamily().toString()), ((Value)entry.getValue()).toString());
                    }
                    Assertions.assertEquals(expectations, actual, (String)("Differing results for " + table));
                }
                finally {
                    if (s == null) continue;
                    s.close();
                }
            }
        }
        finally {
            if (this.mtbw != null) {
                this.mtbw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableRenameNewWriters() throws Exception {
        try {
            String[] names = this.getUniqueNames(4);
            String table1 = names[0];
            String table2 = names[1];
            String newTable1 = names[2];
            String newTable2 = names[3];
            TableOperations tops = this.accumuloClient.tableOperations();
            tops.create(table1);
            tops.create(table2);
            BatchWriter bw1 = this.mtbw.getBatchWriter(table1);
            BatchWriter bw2 = this.mtbw.getBatchWriter(table2);
            Mutation m1 = new Mutation((CharSequence)"foo");
            m1.put((CharSequence)"col1", (CharSequence)"", (CharSequence)"val1");
            m1.put((CharSequence)"col2", (CharSequence)"", (CharSequence)"val2");
            bw1.addMutation(m1);
            bw2.addMutation(m1);
            tops.rename(table1, newTable1);
            Assertions.assertThrows(TableNotFoundException.class, () -> this.mtbw.getBatchWriter(table1), (String)"Should not be able to find this table");
            tops.rename(table2, newTable2);
            Assertions.assertThrows(TableNotFoundException.class, () -> this.mtbw.getBatchWriter(table2), (String)"Should not be able to find this table");
            bw1 = this.mtbw.getBatchWriter(newTable1);
            bw2 = this.mtbw.getBatchWriter(newTable2);
            Mutation m2 = new Mutation((CharSequence)"bar");
            m2.put((CharSequence)"col1", (CharSequence)"", (CharSequence)"val1");
            m2.put((CharSequence)"col2", (CharSequence)"", (CharSequence)"val2");
            bw1.addMutation(m2);
            bw2.addMutation(m2);
            this.mtbw.close();
            HashMap<Map.Entry, String> expectations = new HashMap<Map.Entry, String>();
            expectations.put(Maps.immutableEntry((Object)"foo", (Object)"col1"), "val1");
            expectations.put(Maps.immutableEntry((Object)"foo", (Object)"col2"), "val2");
            expectations.put(Maps.immutableEntry((Object)"bar", (Object)"col1"), "val1");
            expectations.put(Maps.immutableEntry((Object)"bar", (Object)"col2"), "val2");
            for (String table : Arrays.asList(newTable1, newTable2)) {
                Scanner s = this.accumuloClient.createScanner(table, new Authorizations());
                try {
                    s.setRange(new Range());
                    HashMap<Map.Entry, String> actual = new HashMap<Map.Entry, String>();
                    for (Map.Entry entry : s) {
                        actual.put(Maps.immutableEntry((Object)((Key)entry.getKey()).getRow().toString(), (Object)((Key)entry.getKey()).getColumnFamily().toString()), ((Value)entry.getValue()).toString());
                    }
                    Assertions.assertEquals(expectations, actual, (String)("Differing results for " + table));
                }
                finally {
                    if (s == null) continue;
                    s.close();
                }
            }
        }
        finally {
            if (this.mtbw != null) {
                this.mtbw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableRenameNewWritersNoCaching() throws Exception {
        this.mtbw = this.getMultiTableBatchWriter();
        try {
            String[] names = this.getUniqueNames(4);
            String table1 = names[0];
            String table2 = names[1];
            String newTable1 = names[2];
            String newTable2 = names[3];
            TableOperations tops = this.accumuloClient.tableOperations();
            tops.create(table1);
            tops.create(table2);
            BatchWriter bw1 = this.mtbw.getBatchWriter(table1);
            BatchWriter bw2 = this.mtbw.getBatchWriter(table2);
            Mutation m1 = new Mutation((CharSequence)"foo");
            m1.put((CharSequence)"col1", (CharSequence)"", (CharSequence)"val1");
            m1.put((CharSequence)"col2", (CharSequence)"", (CharSequence)"val2");
            bw1.addMutation(m1);
            bw2.addMutation(m1);
            tops.rename(table1, newTable1);
            tops.rename(table2, newTable2);
            Assertions.assertThrows(TableNotFoundException.class, () -> this.mtbw.getBatchWriter(table1), (String)("Should not have gotten batchwriter for " + table1));
            Assertions.assertThrows(TableNotFoundException.class, () -> this.mtbw.getBatchWriter(table2), (String)("Should not have gotten batchwriter for " + table2));
        }
        finally {
            if (this.mtbw != null) {
                this.mtbw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableDelete() throws Exception {
        boolean mutationsRejected = false;
        try {
            String[] names = this.getUniqueNames(2);
            String table1 = names[0];
            String table2 = names[1];
            TableOperations tops = this.accumuloClient.tableOperations();
            tops.create(table1);
            tops.create(table2);
            BatchWriter bw1 = this.mtbw.getBatchWriter(table1);
            BatchWriter bw2 = this.mtbw.getBatchWriter(table2);
            Mutation m1 = new Mutation((CharSequence)"foo");
            m1.put((CharSequence)"col1", (CharSequence)"", (CharSequence)"val1");
            m1.put((CharSequence)"col2", (CharSequence)"", (CharSequence)"val2");
            bw1.addMutation(m1);
            bw2.addMutation(m1);
            tops.delete(table1);
            tops.delete(table2);
            Mutation m2 = new Mutation((CharSequence)"bar");
            m2.put((CharSequence)"col1", (CharSequence)"", (CharSequence)"val1");
            m2.put((CharSequence)"col2", (CharSequence)"", (CharSequence)"val2");
            try {
                bw1.addMutation(m2);
                bw2.addMutation(m2);
            }
            catch (MutationsRejectedException e) {
                mutationsRejected = true;
            }
        }
        finally {
            if (this.mtbw != null) {
                try {
                    this.mtbw.close();
                }
                catch (MutationsRejectedException e) {
                    mutationsRejected = true;
                }
            }
        }
        Assertions.assertTrue((boolean)mutationsRejected, (String)"Expected mutations to be rejected.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOfflineTable() throws Exception {
        boolean mutationsRejected = false;
        try {
            String[] names = this.getUniqueNames(2);
            String table1 = names[0];
            String table2 = names[1];
            TableOperations tops = this.accumuloClient.tableOperations();
            tops.create(table1);
            tops.create(table2);
            BatchWriter bw1 = this.mtbw.getBatchWriter(table1);
            BatchWriter bw2 = this.mtbw.getBatchWriter(table2);
            Mutation m1 = new Mutation((CharSequence)"foo");
            m1.put((CharSequence)"col1", (CharSequence)"", (CharSequence)"val1");
            m1.put((CharSequence)"col2", (CharSequence)"", (CharSequence)"val2");
            bw1.addMutation(m1);
            bw2.addMutation(m1);
            tops.offline(table1, true);
            tops.offline(table2, true);
            Mutation m2 = new Mutation((CharSequence)"bar");
            m2.put((CharSequence)"col1", (CharSequence)"", (CharSequence)"val1");
            m2.put((CharSequence)"col2", (CharSequence)"", (CharSequence)"val2");
            try {
                bw1.addMutation(m2);
                bw2.addMutation(m2);
            }
            catch (MutationsRejectedException e) {
                mutationsRejected = true;
            }
        }
        finally {
            if (this.mtbw != null) {
                try {
                    this.mtbw.close();
                }
                catch (MutationsRejectedException e) {
                    mutationsRejected = true;
                }
            }
        }
        Assertions.assertTrue((boolean)mutationsRejected, (String)"Expected mutations to be rejected.");
    }
}

