/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.NamespaceExistsException;
import org.apache.accumulo.core.client.NamespaceNotEmptyException;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.ImportConfiguration;
import org.apache.accumulo.core.client.admin.NamespaceOperations;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.clientImpl.Namespace;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.clientImpl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ConstraintViolationSummary;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Filter;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.user.VersioningIterator;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.NamespacePermission;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.util.tables.TableNameUtil;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.test.constraints.NumericValueConstraint;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

@Tag(value="MiniClusterOnly")
public class NamespacesIT
extends SharedMiniClusterBase {
    private AccumuloClient c;
    private String namespace;
    private static final int MAX_NAMESPACE_LEN = 1024;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    @BeforeAll
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniCluster();
    }

    @AfterAll
    public static void teardown() {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @BeforeEach
    public void setupConnectorAndNamespace() {
        this.c = (AccumuloClient)Accumulo.newClient().from(NamespacesIT.getClientProps()).build();
        this.namespace = "ns_" + this.getUniqueNames(1)[0];
    }

    @AfterEach
    public void swingMj\u00f6lnir() throws Exception {
        if (this.c == null) {
            return;
        }
        for (String t : this.c.tableOperations().list()) {
            if (((String)TableNameUtil.qualify((String)t).getFirst()).equals(Namespace.ACCUMULO.name())) continue;
            this.c.tableOperations().delete(t);
        }
        Assertions.assertEquals((int)3, (int)this.c.tableOperations().list().size());
        for (String n : this.c.namespaceOperations().list()) {
            if (n.equals(Namespace.ACCUMULO.name()) || n.equals(Namespace.DEFAULT.name())) continue;
            this.c.namespaceOperations().delete(n);
        }
        Assertions.assertEquals((int)2, (int)this.c.namespaceOperations().list().size());
        for (String u : this.c.securityOperations().listLocalUsers()) {
            if (NamespacesIT.getAdminPrincipal().equals(u)) continue;
            this.c.securityOperations().dropLocalUser(u);
        }
        Assertions.assertEquals((int)1, (int)this.c.securityOperations().listLocalUsers().size());
        this.c.close();
    }

    @Test
    public void checkReservedNamespaces() {
        Assertions.assertEquals((Object)this.c.namespaceOperations().defaultNamespace(), (Object)Namespace.DEFAULT.name());
        Assertions.assertEquals((Object)this.c.namespaceOperations().systemNamespace(), (Object)Namespace.ACCUMULO.name());
    }

    @Test
    public void checkBuiltInNamespaces() throws Exception {
        Assertions.assertTrue((boolean)this.c.namespaceOperations().exists(Namespace.DEFAULT.name()));
        Assertions.assertTrue((boolean)this.c.namespaceOperations().exists(Namespace.ACCUMULO.name()));
    }

    @Test
    public void createTableInDefaultNamespace() throws Exception {
        String tableName = "1";
        this.c.tableOperations().create(tableName);
        Assertions.assertTrue((boolean)this.c.tableOperations().exists(tableName));
    }

    @Test
    public void createTableInAccumuloNamespace() {
        String tableName = Namespace.ACCUMULO.name() + ".1";
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(tableName));
        Assertions.assertThrows(AccumuloException.class, () -> this.c.tableOperations().create(tableName));
    }

    @Test
    public void deleteBuiltinNamespaces() {
        Assertions.assertThrows(AccumuloSecurityException.class, () -> this.c.namespaceOperations().delete(Namespace.DEFAULT.name()));
        Assertions.assertThrows(AccumuloSecurityException.class, () -> this.c.namespaceOperations().delete(Namespace.ACCUMULO.name()));
    }

    @Test
    public void createTableInMissingNamespace() throws Exception {
        String t = this.namespace + ".1";
        Assertions.assertFalse((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t));
        AccumuloException e = (AccumuloException)Assertions.assertThrows(AccumuloException.class, () -> this.c.tableOperations().create(t));
        Assertions.assertEquals(NamespaceNotFoundException.class, e.getCause().getClass());
        Assertions.assertFalse((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t));
    }

    @Test
    public void createNamespaceWithNamespaceLengthLimit() throws AccumuloException, AccumuloSecurityException, NamespaceExistsException {
        NamespaceOperations nsOps = this.c.namespaceOperations();
        String n0 = StringUtils.repeat((char)'a', (int)1023);
        nsOps.create(n0);
        Assertions.assertTrue((boolean)nsOps.exists(n0));
        String n1 = StringUtils.repeat((char)'b', (int)1024);
        nsOps.create(n1);
        Assertions.assertTrue((boolean)nsOps.exists(n1));
        String n2 = StringUtils.repeat((char)'c', (int)1025);
        Assertions.assertThrows(IllegalArgumentException.class, () -> nsOps.create(n2));
        Assertions.assertFalse((boolean)nsOps.exists(n2));
    }

    @Test
    public void createAndDeleteNamespace() throws Exception {
        String t1 = this.namespace + ".1";
        String t2 = this.namespace + ".2";
        Assertions.assertFalse((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t1));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t2));
        Assertions.assertThrows(NamespaceNotFoundException.class, () -> this.c.namespaceOperations().delete(this.namespace));
        TableNotFoundException e = (TableNotFoundException)Assertions.assertThrows(TableNotFoundException.class, () -> this.c.tableOperations().delete(t1));
        Assertions.assertEquals(NamespaceNotFoundException.class, e.getCause().getClass());
        this.c.namespaceOperations().create(this.namespace);
        Assertions.assertTrue((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t1));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t2));
        this.c.tableOperations().create(t1);
        Assertions.assertTrue((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assertions.assertTrue((boolean)this.c.tableOperations().exists(t1));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t2));
        this.c.tableOperations().create(t2);
        Assertions.assertTrue((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assertions.assertTrue((boolean)this.c.tableOperations().exists(t1));
        Assertions.assertTrue((boolean)this.c.tableOperations().exists(t2));
        this.c.tableOperations().delete(t1);
        Assertions.assertTrue((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t1));
        Assertions.assertTrue((boolean)this.c.tableOperations().exists(t2));
        this.c.tableOperations().delete(t2);
        Assertions.assertTrue((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t1));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t2));
        this.c.namespaceOperations().delete(this.namespace);
        Assertions.assertFalse((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t1));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t2));
    }

    @Test
    public void deleteNonEmptyNamespace() throws Exception {
        String tableName1 = this.namespace + ".1";
        Assertions.assertFalse((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(tableName1));
        this.c.namespaceOperations().create(this.namespace);
        this.c.tableOperations().create(tableName1);
        Assertions.assertTrue((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assertions.assertTrue((boolean)this.c.tableOperations().exists(tableName1));
        Assertions.assertThrows(NamespaceNotEmptyException.class, () -> this.c.namespaceOperations().delete(this.namespace));
    }

    @Test
    public void setProperties() throws Exception {
        this.c.namespaceOperations().create(this.namespace);
        Property prop = Property.TABLE_BLOOM_ENABLED;
        this.c.namespaceOperations().setProperty(this.namespace, prop.getKey(), "true");
        Assertions.assertTrue((boolean)this.checkNamespaceHasProp(this.namespace, prop.getKey(), "true"));
        Assertions.assertThrows(AccumuloException.class, () -> this.c.namespaceOperations().setProperty(this.namespace, prop.getKey(), "foo"));
        Assertions.assertFalse((boolean)this.checkNamespaceHasProp(this.namespace, prop.getKey(), "foo"));
    }

    @Test
    public void verifyPropertyInheritance() throws Exception {
        try (AccumuloClient client = NamespacesIT.getCluster().createAccumuloClient(NamespacesIT.getPrincipal(), (AuthenticationToken)new PasswordToken((CharSequence)NamespacesIT.getRootPassword()));){
            client.securityOperations().grantNamespacePermission(NamespacesIT.getPrincipal(), "", NamespacePermission.ALTER_NAMESPACE);
        }
        String t0 = "0";
        String t1 = this.namespace + ".1";
        String t2 = this.namespace + ".2";
        String k = Property.TABLE_SCAN_MAXMEM.getKey();
        String v = "42K";
        Assertions.assertFalse((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t1));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t2));
        this.c.namespaceOperations().create(this.namespace);
        this.c.tableOperations().create(t1);
        this.c.tableOperations().create(t0);
        Assertions.assertTrue((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assertions.assertTrue((boolean)this.c.tableOperations().exists(t1));
        Assertions.assertTrue((boolean)this.c.tableOperations().exists(t0));
        Assertions.assertFalse((boolean)this.checkNamespaceHasProp(this.namespace, k, v));
        Assertions.assertFalse((boolean)this.checkTableHasProp(t1, k, v));
        Assertions.assertFalse((boolean)this.checkNamespaceHasProp(Namespace.DEFAULT.name(), k, v));
        Assertions.assertFalse((boolean)this.checkTableHasProp(t0, k, v));
        this.c.namespaceOperations().setProperty(this.namespace, k, v);
        Assertions.assertTrue((boolean)this.checkNamespaceHasProp(this.namespace, k, v));
        Assertions.assertTrue((boolean)this.checkTableHasProp(t1, k, v));
        Assertions.assertFalse((boolean)this.checkNamespaceHasProp(Namespace.DEFAULT.name(), k, v));
        Assertions.assertFalse((boolean)this.checkTableHasProp(t0, k, v));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t2));
        this.c.tableOperations().create(t2);
        Assertions.assertTrue((boolean)this.c.tableOperations().exists(t2));
        Assertions.assertTrue((boolean)this.checkNamespaceHasProp(this.namespace, k, v));
        Assertions.assertTrue((boolean)this.checkTableHasProp(t1, k, v));
        Assertions.assertTrue((boolean)this.checkTableHasProp(t2, k, v));
        Assertions.assertFalse((boolean)this.checkNamespaceHasProp(Namespace.DEFAULT.name(), k, v));
        Assertions.assertFalse((boolean)this.checkTableHasProp(t0, k, v));
        this.c.namespaceOperations().removeProperty(this.namespace, k);
        Assertions.assertFalse((boolean)this.checkNamespaceHasProp(this.namespace, k, v));
        Assertions.assertFalse((boolean)this.checkTableHasProp(t1, k, v));
        Assertions.assertFalse((boolean)this.checkTableHasProp(t2, k, v));
        Assertions.assertFalse((boolean)this.checkNamespaceHasProp(Namespace.DEFAULT.name(), k, v));
        Assertions.assertFalse((boolean)this.checkTableHasProp(t0, k, v));
        this.c.namespaceOperations().setProperty(Namespace.DEFAULT.name(), k, v);
        Assertions.assertFalse((boolean)this.checkNamespaceHasProp(this.namespace, k, v));
        Assertions.assertFalse((boolean)this.checkTableHasProp(t1, k, v));
        Assertions.assertFalse((boolean)this.checkTableHasProp(t2, k, v));
        Assertions.assertTrue((boolean)this.checkNamespaceHasProp(Namespace.DEFAULT.name(), k, v));
        Assertions.assertTrue((boolean)this.checkTableHasProp(t0, k, v));
        String k2 = Property.TABLE_FILE_MAX.getKey();
        String v2 = "42";
        String table_v2 = "13";
        this.c.namespaceOperations().setProperty(this.namespace, k2, v2);
        this.c.tableOperations().setProperty(t2, k2, table_v2);
        Assertions.assertTrue((boolean)this.checkNamespaceHasProp(this.namespace, k2, v2));
        Assertions.assertTrue((boolean)this.checkTableHasProp(t1, k2, v2));
        Assertions.assertTrue((boolean)this.checkTableHasProp(t2, k2, table_v2));
        String k3 = Property.TABLE_FILE_BLOCK_SIZE.getKey();
        String v3 = "52";
        String table_v3 = "73";
        this.c.namespaceOperations().modifyProperties(this.namespace, properties -> {
            properties.remove(k2);
            properties.put(k3, v3);
        });
        this.c.tableOperations().modifyProperties(t2, properties -> {
            properties.remove(k2);
            properties.put(k3, table_v3);
        });
        Assertions.assertTrue((boolean)this.checkNamespaceHasProp(this.namespace, k3, v3));
        Assertions.assertTrue((boolean)this.checkTableHasProp(t1, k3, v3));
        Assertions.assertTrue((boolean)this.checkTableHasProp(t2, k3, table_v3));
        Assertions.assertFalse((boolean)this.checkNamespaceHasProp(this.namespace, k2, v2));
        Assertions.assertFalse((boolean)this.checkTableHasProp(t1, k2, v2));
        Assertions.assertFalse((boolean)this.checkTableHasProp(t2, k2, table_v2));
        this.c.tableOperations().delete(t1);
        this.c.tableOperations().delete(t2);
        this.c.tableOperations().delete(t0);
        this.c.namespaceOperations().delete(this.namespace);
    }

    @Test
    public void verifyIteratorInheritance() throws Exception {
        String t1 = this.namespace + ".1";
        this.c.namespaceOperations().create(this.namespace);
        this.c.tableOperations().create(t1);
        String iterName = this.namespace + "_iter";
        try (BatchWriter bw = this.c.createBatchWriter(t1);){
            Mutation m = new Mutation((CharSequence)"r");
            m.put((CharSequence)"a", (CharSequence)"b", new Value((CharSequence)"abcde"));
            bw.addMutation(m);
            bw.flush();
        }
        IteratorSetting setting = new IteratorSetting(250, iterName, SimpleFilter.class.getName());
        try (Scanner s = this.c.createScanner(t1);){
            Assertions.assertTrue((boolean)s.iterator().hasNext());
            Assertions.assertFalse((boolean)this.c.namespaceOperations().listIterators(this.namespace).containsKey(iterName));
            Assertions.assertFalse((boolean)this.c.tableOperations().listIterators(t1).containsKey(iterName));
            this.c.namespaceOperations().checkIteratorConflicts(this.namespace, setting, EnumSet.allOf(IteratorUtil.IteratorScope.class));
            this.c.namespaceOperations().attachIterator(this.namespace, setting);
            UtilWaitThread.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
            AccumuloException e = (AccumuloException)Assertions.assertThrows(AccumuloException.class, () -> this.c.namespaceOperations().checkIteratorConflicts(this.namespace, setting, EnumSet.allOf(IteratorUtil.IteratorScope.class)));
            Assertions.assertEquals(IllegalArgumentException.class, e.getCause().getClass());
            IteratorSetting setting2 = this.c.namespaceOperations().getIteratorSetting(this.namespace, setting.getName(), IteratorUtil.IteratorScope.scan);
            Assertions.assertEquals((Object)setting, (Object)setting2);
            Assertions.assertTrue((boolean)this.c.namespaceOperations().listIterators(this.namespace).containsKey(iterName));
            Assertions.assertTrue((boolean)this.c.tableOperations().listIterators(t1).containsKey(iterName));
        }
        s = this.c.createScanner(t1, Authorizations.EMPTY);
        try {
            Assertions.assertFalse((boolean)s.iterator().hasNext());
            this.c.namespaceOperations().removeIterator(this.namespace, setting.getName(), EnumSet.allOf(IteratorUtil.IteratorScope.class));
            UtilWaitThread.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
            Assertions.assertFalse((boolean)this.c.namespaceOperations().listIterators(this.namespace).containsKey(iterName));
            Assertions.assertFalse((boolean)this.c.tableOperations().listIterators(t1).containsKey(iterName));
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
        s = this.c.createScanner(t1, Authorizations.EMPTY);
        try {
            Assertions.assertTrue((boolean)s.iterator().hasNext());
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }

    @Test
    public void cloneTable() throws Exception {
        String namespace2 = this.namespace + "_clone";
        String t1 = this.namespace + ".1";
        String t2 = this.namespace + ".2";
        String t3 = namespace2 + ".2";
        String k1 = Property.TABLE_FILE_MAX.getKey();
        String k2 = Property.TABLE_FILE_REPLICATION.getKey();
        String k1v1 = "55";
        String k1v2 = "66";
        String k2v1 = "5";
        String k2v2 = "6";
        this.c.namespaceOperations().create(this.namespace);
        this.c.tableOperations().create(t1);
        Assertions.assertTrue((boolean)this.c.tableOperations().exists(t1));
        Assertions.assertFalse((boolean)this.c.namespaceOperations().exists(namespace2));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t2));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t3));
        AccumuloException e = (AccumuloException)Assertions.assertThrows(AccumuloException.class, () -> this.c.tableOperations().clone(t1, t3, false, null, null));
        Assertions.assertEquals(NamespaceNotFoundException.class, e.getCause().getClass());
        this.c.namespaceOperations().create(namespace2);
        this.c.tableOperations().create(t2);
        this.c.tableOperations().create(t3);
        for (String t : Arrays.asList(t2, t3)) {
            Assertions.assertThrows(TableExistsException.class, () -> this.c.tableOperations().clone(t1, t, false, null, null));
            this.c.tableOperations().delete(t);
        }
        Assertions.assertTrue((boolean)this.c.tableOperations().exists(t1));
        Assertions.assertTrue((boolean)this.c.namespaceOperations().exists(namespace2));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t2));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t3));
        Assertions.assertFalse((boolean)this.checkNamespaceHasProp(this.namespace, k1, k1v1));
        Assertions.assertFalse((boolean)this.checkNamespaceHasProp(namespace2, k1, k1v2));
        Assertions.assertFalse((boolean)this.checkTableHasProp(t1, k1, k1v1));
        Assertions.assertFalse((boolean)this.checkTableHasProp(t1, k1, k1v2));
        Assertions.assertFalse((boolean)this.checkNamespaceHasProp(this.namespace, k2, k2v1));
        Assertions.assertFalse((boolean)this.checkNamespaceHasProp(namespace2, k2, k2v1));
        Assertions.assertFalse((boolean)this.checkTableHasProp(t1, k2, k2v1));
        Assertions.assertFalse((boolean)this.checkTableHasProp(t1, k2, k2v2));
        this.c.namespaceOperations().setProperty(this.namespace, k1, k1v1);
        this.c.namespaceOperations().setProperty(namespace2, k1, k1v2);
        this.c.namespaceOperations().setProperty(this.namespace, k2, k2v1);
        this.c.namespaceOperations().setProperty(namespace2, k2, k2v1);
        this.c.tableOperations().setProperty(t1, k2, k2v2);
        Assertions.assertTrue((boolean)this.checkNamespaceHasProp(this.namespace, k1, k1v1));
        Assertions.assertTrue((boolean)this.checkNamespaceHasProp(namespace2, k1, k1v2));
        Assertions.assertTrue((boolean)this.checkTableHasProp(t1, k1, k1v1));
        Assertions.assertFalse((boolean)this.checkTableHasProp(t1, k1, k1v2));
        Assertions.assertTrue((boolean)this.checkNamespaceHasProp(this.namespace, k2, k2v1));
        Assertions.assertTrue((boolean)this.checkNamespaceHasProp(namespace2, k2, k2v1));
        Assertions.assertFalse((boolean)this.checkTableHasProp(t1, k2, k2v1));
        Assertions.assertTrue((boolean)this.checkTableHasProp(t1, k2, k2v2));
        for (String t : Arrays.asList(t2, t3)) {
            this.c.tableOperations().clone(t1, t, false, null, null);
        }
        Assertions.assertTrue((boolean)this.c.namespaceOperations().exists(namespace2));
        Assertions.assertTrue((boolean)this.c.tableOperations().exists(t1));
        Assertions.assertTrue((boolean)this.c.tableOperations().exists(t2));
        Assertions.assertTrue((boolean)this.c.tableOperations().exists(t3));
        Assertions.assertTrue((boolean)this.checkTableHasProp(t1, k1, k1v1));
        Assertions.assertTrue((boolean)this.checkTableHasProp(t2, k1, k1v1));
        Assertions.assertTrue((boolean)this.checkTableHasProp(t3, k1, k1v2));
        Assertions.assertTrue((boolean)this.checkTableHasProp(t1, k2, k2v2));
        Assertions.assertTrue((boolean)this.checkTableHasProp(t2, k2, k2v2));
        Assertions.assertTrue((boolean)this.checkTableHasProp(t3, k2, k2v2));
    }

    @Test
    public void renameNamespaceWithTable() throws Exception {
        String namespace2 = this.namespace + "_renamed";
        String t1 = this.namespace + ".t";
        String t2 = namespace2 + ".t";
        this.c.namespaceOperations().create(this.namespace);
        this.c.tableOperations().create(t1);
        Assertions.assertTrue((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assertions.assertTrue((boolean)this.c.tableOperations().exists(t1));
        Assertions.assertFalse((boolean)this.c.namespaceOperations().exists(namespace2));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t2));
        String namespaceId = (String)this.c.namespaceOperations().namespaceIdMap().get(this.namespace);
        String tableId = (String)this.c.tableOperations().tableIdMap().get(t1);
        this.c.namespaceOperations().rename(this.namespace, namespace2);
        Assertions.assertFalse((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t1));
        Assertions.assertTrue((boolean)this.c.namespaceOperations().exists(namespace2));
        Assertions.assertTrue((boolean)this.c.tableOperations().exists(t2));
        String namespaceId2 = (String)this.c.namespaceOperations().namespaceIdMap().get(namespace2);
        String tableId2 = (String)this.c.tableOperations().tableIdMap().get(t2);
        Assertions.assertEquals((Object)namespaceId, (Object)namespaceId2);
        Assertions.assertEquals((Object)tableId, (Object)tableId2);
    }

    @Test
    public void verifyConstraintInheritance() throws Exception {
        String t1 = this.namespace + ".1";
        this.c.namespaceOperations().create(this.namespace);
        this.c.tableOperations().create(t1, new NewTableConfiguration().withoutDefaultIterators());
        String constraintClassName = NumericValueConstraint.class.getName();
        Assertions.assertFalse((boolean)this.c.namespaceOperations().listConstraints(this.namespace).containsKey(constraintClassName));
        Assertions.assertFalse((boolean)this.c.tableOperations().listConstraints(t1).containsKey(constraintClassName));
        this.c.namespaceOperations().addConstraint(this.namespace, constraintClassName);
        while (!this.c.namespaceOperations().listConstraints(this.namespace).containsKey(constraintClassName) || !this.c.tableOperations().listConstraints(t1).containsKey(constraintClassName)) {
            Thread.sleep(500L);
        }
        Integer namespaceNum = null;
        Integer tableNum = null;
        while (namespaceNum == null || tableNum == null) {
            namespaceNum = (Integer)this.c.namespaceOperations().listConstraints(this.namespace).get(constraintClassName);
            tableNum = (Integer)this.c.tableOperations().listConstraints(t1).get(constraintClassName);
            if (namespaceNum != null && tableNum != null) continue;
            Thread.sleep(500L);
        }
        Assertions.assertEquals(namespaceNum, tableNum);
        Mutation m1 = new Mutation((CharSequence)"r1");
        Mutation m2 = new Mutation((CharSequence)"r2");
        Mutation m3 = new Mutation((CharSequence)"r3");
        m1.put((CharSequence)"a", (CharSequence)"b", new Value((CharSequence)"abcde"));
        m2.put((CharSequence)"e", (CharSequence)"f", new Value((CharSequence)"123"));
        m3.put((CharSequence)"c", (CharSequence)"d", new Value((CharSequence)"zyxwv"));
        boolean mutationsRejected = false;
        while (!mutationsRejected) {
            BatchWriter bw = this.c.createBatchWriter(t1);
            bw.addMutations(Arrays.asList(m1, m2, m3));
            try {
                bw.close();
                Thread.sleep(500L);
            }
            catch (MutationsRejectedException e) {
                mutationsRejected = true;
                Assertions.assertEquals((int)1, (int)e.getConstraintViolationSummaries().size());
                Assertions.assertEquals((long)2L, (long)((ConstraintViolationSummary)e.getConstraintViolationSummaries().get(0)).getNumberOfViolatingMutations());
            }
        }
        Assertions.assertNotNull((Object)namespaceNum, (String)"Namespace constraint ID should not be null");
        this.c.namespaceOperations().removeConstraint(this.namespace, namespaceNum.intValue());
        while (this.c.namespaceOperations().listConstraints(this.namespace).containsKey(constraintClassName) || this.c.tableOperations().listConstraints(t1).containsKey(constraintClassName)) {
            Thread.sleep(500L);
        }
        boolean mutationsAccepted = false;
        while (!mutationsAccepted) {
            BatchWriter bw = this.c.createBatchWriter(t1);
            try {
                bw.addMutations(Arrays.asList(m1, m2, m3));
                bw.close();
                mutationsAccepted = true;
            }
            catch (MutationsRejectedException e) {
                Thread.sleep(500L);
            }
        }
    }

    @Test
    public void renameTable() throws Exception {
        String namespace2 = this.namespace + "_renamed";
        String t1 = this.namespace + ".1";
        String t2 = namespace2 + ".2";
        String t3 = this.namespace + ".3";
        String t4 = this.namespace + ".4";
        String t5 = "5";
        this.c.namespaceOperations().create(this.namespace);
        this.c.namespaceOperations().create(namespace2);
        Assertions.assertTrue((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assertions.assertTrue((boolean)this.c.namespaceOperations().exists(namespace2));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t1));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t2));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t3));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t4));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t5));
        this.c.tableOperations().create(t1);
        AccumuloException e1 = (AccumuloException)Assertions.assertThrows(AccumuloException.class, () -> this.c.tableOperations().rename(t1, t2));
        Assertions.assertEquals(ThriftTableOperationException.class, e1.getCause().getClass());
        Assertions.assertEquals((Object)TableOperation.RENAME, (Object)((ThriftTableOperationException)e1.getCause()).getOp());
        Assertions.assertEquals((Object)TableOperationExceptionType.INVALID_NAME, (Object)((ThriftTableOperationException)e1.getCause()).getType());
        AccumuloException e2 = (AccumuloException)Assertions.assertThrows(AccumuloException.class, () -> this.c.tableOperations().rename(t1, t5));
        Assertions.assertEquals(ThriftTableOperationException.class, e2.getCause().getClass());
        Assertions.assertEquals((Object)TableOperation.RENAME, (Object)((ThriftTableOperationException)e2.getCause()).getOp());
        Assertions.assertEquals((Object)TableOperationExceptionType.INVALID_NAME, (Object)((ThriftTableOperationException)e2.getCause()).getType());
        Assertions.assertTrue((boolean)this.c.tableOperations().exists(t1));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t2));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t3));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t4));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t5));
        this.c.tableOperations().rename(t1, t3);
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t1));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t2));
        Assertions.assertTrue((boolean)this.c.tableOperations().exists(t3));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t4));
        Assertions.assertFalse((boolean)this.c.tableOperations().exists(t5));
    }

    private void loginAs(ClusterUser user) throws IOException {
        user.getToken();
    }

    @Test
    public void testPermissions() throws Exception {
        ClusterUser user1 = this.getUser(0);
        ClusterUser user2 = this.getUser(1);
        ClusterUser root = this.getAdminUser();
        String u1 = user1.getPrincipal();
        String u2 = user2.getPrincipal();
        PasswordToken pass = user1.getPassword() != null ? new PasswordToken((CharSequence)user1.getPassword()) : null;
        String n1 = this.namespace;
        String t1 = n1 + ".1";
        String t2 = n1 + ".2";
        String t3 = n1 + ".3";
        String n2 = this.namespace + "_2";
        this.loginAs(root);
        this.c.namespaceOperations().create(n1);
        this.c.tableOperations().create(t1);
        this.c.securityOperations().createLocalUser(u1, pass);
        this.loginAs(user1);
        try (AccumuloClient user1Con = (AccumuloClient)Accumulo.newClient().from(this.c.properties()).as((CharSequence)u1, user1.getToken()).build();){
            this.assertSecurityException(SecurityErrorCode.PERMISSION_DENIED, () -> user1Con.tableOperations().create(t2));
            this.loginAs(root);
            this.c.securityOperations().grantNamespacePermission(u1, n1, NamespacePermission.CREATE_TABLE);
            this.loginAs(user1);
            user1Con.tableOperations().create(t2);
            this.loginAs(root);
            Assertions.assertTrue((boolean)this.c.tableOperations().list().contains(t2));
            this.c.securityOperations().revokeNamespacePermission(u1, n1, NamespacePermission.CREATE_TABLE);
            this.loginAs(user1);
            this.assertSecurityException(SecurityErrorCode.PERMISSION_DENIED, () -> user1Con.tableOperations().delete(t1));
            this.loginAs(root);
            this.c.securityOperations().grantNamespacePermission(u1, n1, NamespacePermission.DROP_TABLE);
            this.loginAs(user1);
            user1Con.tableOperations().delete(t1);
            this.loginAs(root);
            Assertions.assertFalse((boolean)this.c.tableOperations().list().contains(t1));
            this.c.securityOperations().revokeNamespacePermission(u1, n1, NamespacePermission.DROP_TABLE);
            this.c.tableOperations().create(t3);
            try (BatchWriter bw = this.c.createBatchWriter(t3);){
                Mutation m = new Mutation((CharSequence)"row");
                m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
                bw.addMutation(m);
            }
            this.loginAs(user1);
            Iterator i1 = user1Con.createScanner(t3, new Authorizations()).iterator();
            RuntimeException e1 = (RuntimeException)Assertions.assertThrows(RuntimeException.class, i1::next);
            Assertions.assertEquals(AccumuloSecurityException.class, e1.getCause().getClass());
            Assertions.assertSame((Object)SecurityErrorCode.PERMISSION_DENIED, (Object)((AccumuloSecurityException)e1.getCause()).getSecurityErrorCode());
            this.loginAs(user1);
            Mutation m = new Mutation((CharSequence)u1);
            m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"turtles");
            BatchWriter bw = user1Con.createBatchWriter(t3);
            bw.addMutation(m);
            MutationsRejectedException e = (MutationsRejectedException)Assertions.assertThrows(MutationsRejectedException.class, () -> ((BatchWriter)bw).close());
            Assertions.assertEquals((int)1, (int)e.getSecurityErrorCodes().size());
            Assertions.assertEquals((int)1, (int)((Set)e.getSecurityErrorCodes().entrySet().iterator().next().getValue()).size());
            Assertions.assertSame((Object)SecurityErrorCode.PERMISSION_DENIED, ((Set)e.getSecurityErrorCodes().entrySet().iterator().next().getValue()).iterator().next());
            this.loginAs(root);
            this.c.securityOperations().grantNamespacePermission(u1, n1, NamespacePermission.READ);
            this.loginAs(user1);
            Iterator i2 = user1Con.createScanner(t3, new Authorizations()).iterator();
            Assertions.assertTrue((boolean)i2.hasNext());
            this.loginAs(root);
            this.c.securityOperations().revokeNamespacePermission(u1, n1, NamespacePermission.READ);
            this.c.securityOperations().grantNamespacePermission(u1, n1, NamespacePermission.WRITE);
            this.loginAs(user1);
            try (BatchWriter bw2 = user1Con.createBatchWriter(t3);){
                m = new Mutation((CharSequence)u1);
                m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"turtles");
                bw2.addMutation(m);
            }
            this.loginAs(root);
            this.c.securityOperations().revokeNamespacePermission(u1, n1, NamespacePermission.WRITE);
            this.loginAs(user1);
            this.assertSecurityException(SecurityErrorCode.PERMISSION_DENIED, () -> user1Con.tableOperations().setProperty(t3, Property.TABLE_FILE_MAX.getKey(), "42"));
            this.assertSecurityException(SecurityErrorCode.PERMISSION_DENIED, () -> user1Con.tableOperations().modifyProperties(t3, properties -> properties.put(Property.TABLE_FILE_MAX.getKey(), "55")));
            this.loginAs(root);
            this.c.securityOperations().grantNamespacePermission(u1, n1, NamespacePermission.ALTER_TABLE);
            this.c.securityOperations().grantTablePermission(u1, t3, TablePermission.ALTER_TABLE);
            this.loginAs(user1);
            user1Con.tableOperations().setProperty(t3, Property.TABLE_FILE_MAX.getKey(), "42");
            user1Con.tableOperations().modifyProperties(t3, properties -> properties.put(Property.TABLE_FILE_MAX.getKey(), "43"));
            user1Con.tableOperations().removeProperty(t3, Property.TABLE_FILE_MAX.getKey());
            this.loginAs(root);
            this.c.securityOperations().revokeNamespacePermission(u1, n1, NamespacePermission.ALTER_TABLE);
            this.loginAs(user1);
            this.assertSecurityException(SecurityErrorCode.PERMISSION_DENIED, () -> user1Con.namespaceOperations().setProperty(n1, Property.TABLE_FILE_MAX.getKey(), "55"));
            this.assertSecurityException(SecurityErrorCode.PERMISSION_DENIED, () -> user1Con.namespaceOperations().modifyProperties(n1, properties -> properties.put(Property.TABLE_FILE_MAX.getKey(), "55")));
            this.loginAs(root);
            this.c.securityOperations().grantNamespacePermission(u1, n1, NamespacePermission.ALTER_NAMESPACE);
            this.loginAs(user1);
            user1Con.namespaceOperations().setProperty(n1, Property.TABLE_FILE_MAX.getKey(), "42");
            user1Con.namespaceOperations().modifyProperties(n1, properties -> properties.put(Property.TABLE_FILE_MAX.getKey(), "43"));
            user1Con.namespaceOperations().removeProperty(n1, Property.TABLE_FILE_MAX.getKey());
            this.loginAs(root);
            this.c.securityOperations().revokeNamespacePermission(u1, n1, NamespacePermission.ALTER_NAMESPACE);
            this.loginAs(root);
            this.c.securityOperations().createLocalUser(u2, root.getPassword() == null ? null : new PasswordToken((CharSequence)user2.getPassword()));
            this.loginAs(user1);
            this.assertSecurityException(SecurityErrorCode.PERMISSION_DENIED, () -> user1Con.securityOperations().grantNamespacePermission(u2, n1, NamespacePermission.ALTER_NAMESPACE));
            this.loginAs(root);
            this.c.securityOperations().grantNamespacePermission(u1, n1, NamespacePermission.GRANT);
            this.loginAs(user1);
            user1Con.securityOperations().grantNamespacePermission(u2, n1, NamespacePermission.ALTER_NAMESPACE);
            user1Con.securityOperations().revokeNamespacePermission(u2, n1, NamespacePermission.ALTER_NAMESPACE);
            this.loginAs(root);
            this.c.securityOperations().revokeNamespacePermission(u1, n1, NamespacePermission.GRANT);
            this.loginAs(user1);
            this.assertSecurityException(SecurityErrorCode.PERMISSION_DENIED, () -> user1Con.namespaceOperations().create(n2));
            this.loginAs(root);
            this.c.securityOperations().grantSystemPermission(u1, SystemPermission.CREATE_NAMESPACE);
            this.loginAs(user1);
            user1Con.namespaceOperations().create(n2);
            this.loginAs(root);
            this.c.securityOperations().revokeSystemPermission(u1, SystemPermission.CREATE_NAMESPACE);
            this.c.securityOperations().revokeNamespacePermission(u1, n2, NamespacePermission.DROP_NAMESPACE);
            this.loginAs(user1);
            this.assertSecurityException(SecurityErrorCode.PERMISSION_DENIED, () -> user1Con.namespaceOperations().delete(n2));
            this.loginAs(root);
            this.c.securityOperations().grantSystemPermission(u1, SystemPermission.DROP_NAMESPACE);
            this.loginAs(user1);
            user1Con.namespaceOperations().delete(n2);
            this.loginAs(root);
            this.c.securityOperations().revokeSystemPermission(u1, SystemPermission.DROP_NAMESPACE);
            this.loginAs(user1);
            this.assertSecurityException(SecurityErrorCode.PERMISSION_DENIED, () -> user1Con.namespaceOperations().setProperty(n1, Property.TABLE_FILE_MAX.getKey(), "33"));
            this.loginAs(root);
            this.c.securityOperations().grantSystemPermission(u1, SystemPermission.ALTER_NAMESPACE);
            this.loginAs(user1);
            user1Con.namespaceOperations().setProperty(n1, Property.TABLE_FILE_MAX.getKey(), "33");
            user1Con.namespaceOperations().removeProperty(n1, Property.TABLE_FILE_MAX.getKey());
            this.loginAs(root);
            this.c.securityOperations().revokeSystemPermission(u1, SystemPermission.ALTER_NAMESPACE);
        }
    }

    @Test
    public void verifySystemPropertyInheritance() throws Exception {
        try (AccumuloClient client = NamespacesIT.getCluster().createAccumuloClient(NamespacesIT.getPrincipal(), (AuthenticationToken)new PasswordToken((CharSequence)NamespacesIT.getRootPassword()));){
            client.securityOperations().grantNamespacePermission(NamespacesIT.getPrincipal(), "accumulo", NamespacePermission.ALTER_NAMESPACE);
            client.securityOperations().grantNamespacePermission(NamespacesIT.getPrincipal(), "", NamespacePermission.ALTER_NAMESPACE);
        }
        String t1 = "1";
        String t2 = this.namespace + "." + t1;
        this.c.tableOperations().create(t1);
        this.c.namespaceOperations().create(this.namespace);
        this.c.tableOperations().create(t2);
        this._verifySystemPropertyInheritance(t1, t2, Property.TABLE_ITERATOR_PREFIX.getKey() + "scan.sum", "20," + SimpleFilter.class.getName(), false);
        this._verifySystemPropertyInheritance(t1, t2, Property.TABLE_CONSTRAINT_PREFIX.getKey() + "42", NumericValueConstraint.class.getName(), false);
        this._verifySystemPropertyInheritance(t1, t2, Property.TABLE_LOCALITY_GROUP_PREFIX.getKey() + "dummy", "dummy", true);
    }

    private void _verifySystemPropertyInheritance(String defaultNamespaceTable, String namespaceTable, String k, String v, boolean systemNamespaceShouldInherit) throws Exception {
        Assertions.assertFalse((boolean)this.c.instanceOperations().getSystemConfiguration().containsValue(v));
        Assertions.assertFalse((boolean)this.checkNamespaceHasProp(Namespace.ACCUMULO.name(), k, v));
        Assertions.assertFalse((boolean)this.checkTableHasProp(RootTable.NAME, k, v));
        Assertions.assertFalse((boolean)this.checkTableHasProp(MetadataTable.NAME, k, v));
        Assertions.assertFalse((boolean)this.checkNamespaceHasProp(Namespace.DEFAULT.name(), k, v));
        Assertions.assertFalse((boolean)this.checkTableHasProp(defaultNamespaceTable, k, v));
        Assertions.assertFalse((boolean)this.checkNamespaceHasProp(this.namespace, k, v));
        Assertions.assertFalse((boolean)this.checkTableHasProp(namespaceTable, k, v));
        this.c.instanceOperations().setProperty(k, v);
        UtilWaitThread.sleepUninterruptibly((long)250L, (TimeUnit)TimeUnit.MILLISECONDS);
        Assertions.assertTrue((boolean)this.c.instanceOperations().getSystemConfiguration().containsValue(v));
        Assertions.assertEquals((Object)systemNamespaceShouldInherit, (Object)this.checkNamespaceHasProp(Namespace.ACCUMULO.name(), k, v));
        Assertions.assertEquals((Object)systemNamespaceShouldInherit, (Object)this.checkTableHasProp(RootTable.NAME, k, v));
        Assertions.assertEquals((Object)systemNamespaceShouldInherit, (Object)this.checkTableHasProp(MetadataTable.NAME, k, v));
        Assertions.assertTrue((boolean)this.checkNamespaceHasProp(Namespace.DEFAULT.name(), k, v));
        Assertions.assertTrue((boolean)this.checkTableHasProp(defaultNamespaceTable, k, v));
        Assertions.assertTrue((boolean)this.checkNamespaceHasProp(this.namespace, k, v));
        Assertions.assertTrue((boolean)this.checkTableHasProp(namespaceTable, k, v));
        this.c.instanceOperations().removeProperty(k);
        UtilWaitThread.sleepUninterruptibly((long)250L, (TimeUnit)TimeUnit.MILLISECONDS);
        Assertions.assertFalse((boolean)this.c.instanceOperations().getSystemConfiguration().containsValue(v));
        Assertions.assertFalse((boolean)this.checkNamespaceHasProp(Namespace.ACCUMULO.name(), k, v));
        Assertions.assertFalse((boolean)this.checkTableHasProp(RootTable.NAME, k, v));
        Assertions.assertFalse((boolean)this.checkTableHasProp(MetadataTable.NAME, k, v));
        Assertions.assertFalse((boolean)this.checkNamespaceHasProp(Namespace.DEFAULT.name(), k, v));
        Assertions.assertFalse((boolean)this.checkTableHasProp(defaultNamespaceTable, k, v));
        Assertions.assertFalse((boolean)this.checkNamespaceHasProp(this.namespace, k, v));
        Assertions.assertFalse((boolean)this.checkTableHasProp(namespaceTable, k, v));
    }

    @Test
    public void listNamespaces() throws Exception {
        SortedSet namespaces = this.c.namespaceOperations().list();
        Map map = this.c.namespaceOperations().namespaceIdMap();
        Assertions.assertEquals((int)2, (int)namespaces.size());
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertTrue((boolean)namespaces.contains(Namespace.ACCUMULO.name()));
        Assertions.assertTrue((boolean)namespaces.contains(Namespace.DEFAULT.name()));
        Assertions.assertFalse((boolean)namespaces.contains(this.namespace));
        Assertions.assertEquals((Object)Namespace.ACCUMULO.id().canonical(), map.get(Namespace.ACCUMULO.name()));
        Assertions.assertEquals((Object)Namespace.DEFAULT.id().canonical(), map.get(Namespace.DEFAULT.name()));
        Assertions.assertNull(map.get(this.namespace));
        this.c.namespaceOperations().create(this.namespace);
        namespaces = this.c.namespaceOperations().list();
        map = this.c.namespaceOperations().namespaceIdMap();
        Assertions.assertEquals((int)3, (int)namespaces.size());
        Assertions.assertEquals((int)3, (int)map.size());
        Assertions.assertTrue((boolean)namespaces.contains(Namespace.ACCUMULO.name()));
        Assertions.assertTrue((boolean)namespaces.contains(Namespace.DEFAULT.name()));
        Assertions.assertTrue((boolean)namespaces.contains(this.namespace));
        Assertions.assertEquals((Object)Namespace.ACCUMULO.id().canonical(), map.get(Namespace.ACCUMULO.name()));
        Assertions.assertEquals((Object)Namespace.DEFAULT.id().canonical(), map.get(Namespace.DEFAULT.name()));
        Assertions.assertNotNull(map.get(this.namespace));
        this.c.namespaceOperations().delete(this.namespace);
        namespaces = this.c.namespaceOperations().list();
        map = this.c.namespaceOperations().namespaceIdMap();
        Assertions.assertEquals((int)2, (int)namespaces.size());
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertTrue((boolean)namespaces.contains(Namespace.ACCUMULO.name()));
        Assertions.assertTrue((boolean)namespaces.contains(Namespace.DEFAULT.name()));
        Assertions.assertFalse((boolean)namespaces.contains(this.namespace));
        Assertions.assertEquals((Object)Namespace.ACCUMULO.id().canonical(), map.get(Namespace.ACCUMULO.name()));
        Assertions.assertEquals((Object)Namespace.DEFAULT.id().canonical(), map.get(Namespace.DEFAULT.name()));
        Assertions.assertNull(map.get(this.namespace));
    }

    @Test
    public void loadClass() throws Exception {
        Assertions.assertTrue((boolean)this.c.namespaceOperations().testClassLoad(Namespace.DEFAULT.name(), VersioningIterator.class.getName(), SortedKeyValueIterator.class.getName()));
        Assertions.assertFalse((boolean)this.c.namespaceOperations().testClassLoad(Namespace.DEFAULT.name(), "dummy", SortedKeyValueIterator.class.getName()));
        Assertions.assertThrows(NamespaceNotFoundException.class, () -> this.c.namespaceOperations().testClassLoad(this.namespace, "dummy", "dummy"));
    }

    @Test
    public void testModifyingPermissions() throws Exception {
        String tableName = this.namespace + ".modify";
        this.c.namespaceOperations().create(this.namespace);
        this.c.tableOperations().create(tableName);
        Assertions.assertTrue((boolean)this.c.securityOperations().hasTablePermission(this.c.whoami(), tableName, TablePermission.READ));
        this.c.securityOperations().revokeTablePermission(this.c.whoami(), tableName, TablePermission.READ);
        Assertions.assertFalse((boolean)this.c.securityOperations().hasTablePermission(this.c.whoami(), tableName, TablePermission.READ));
        this.c.securityOperations().grantTablePermission(this.c.whoami(), tableName, TablePermission.READ);
        Assertions.assertTrue((boolean)this.c.securityOperations().hasTablePermission(this.c.whoami(), tableName, TablePermission.READ));
        this.c.tableOperations().delete(tableName);
        this.assertSecurityException(SecurityErrorCode.TABLE_DOESNT_EXIST, () -> this.c.securityOperations().hasTablePermission(this.c.whoami(), tableName, TablePermission.READ));
        this.assertSecurityException(SecurityErrorCode.TABLE_DOESNT_EXIST, () -> this.c.securityOperations().grantTablePermission(this.c.whoami(), tableName, TablePermission.READ));
        this.assertSecurityException(SecurityErrorCode.TABLE_DOESNT_EXIST, () -> this.c.securityOperations().revokeTablePermission(this.c.whoami(), tableName, TablePermission.READ));
        Assertions.assertTrue((boolean)this.c.securityOperations().hasNamespacePermission(this.c.whoami(), this.namespace, NamespacePermission.READ));
        this.c.securityOperations().revokeNamespacePermission(this.c.whoami(), this.namespace, NamespacePermission.READ);
        Assertions.assertFalse((boolean)this.c.securityOperations().hasNamespacePermission(this.c.whoami(), this.namespace, NamespacePermission.READ));
        this.c.securityOperations().grantNamespacePermission(this.c.whoami(), this.namespace, NamespacePermission.READ);
        Assertions.assertTrue((boolean)this.c.securityOperations().hasNamespacePermission(this.c.whoami(), this.namespace, NamespacePermission.READ));
        this.c.namespaceOperations().delete(this.namespace);
        this.assertSecurityException(SecurityErrorCode.TABLE_DOESNT_EXIST, () -> this.c.securityOperations().hasTablePermission(this.c.whoami(), tableName, TablePermission.READ));
        this.assertSecurityException(SecurityErrorCode.TABLE_DOESNT_EXIST, () -> this.c.securityOperations().grantTablePermission(this.c.whoami(), tableName, TablePermission.READ));
        this.assertSecurityException(SecurityErrorCode.TABLE_DOESNT_EXIST, () -> this.c.securityOperations().revokeTablePermission(this.c.whoami(), tableName, TablePermission.READ));
        this.assertSecurityException(SecurityErrorCode.NAMESPACE_DOESNT_EXIST, () -> this.c.securityOperations().hasNamespacePermission(this.c.whoami(), this.namespace, NamespacePermission.READ));
        this.assertSecurityException(SecurityErrorCode.NAMESPACE_DOESNT_EXIST, () -> this.c.securityOperations().grantNamespacePermission(this.c.whoami(), this.namespace, NamespacePermission.READ));
        this.assertSecurityException(SecurityErrorCode.NAMESPACE_DOESNT_EXIST, () -> this.c.securityOperations().revokeNamespacePermission(this.c.whoami(), this.namespace, NamespacePermission.READ));
    }

    @Test
    public void validatePermissions() throws Exception {
        this.c.namespaceOperations().create(this.namespace);
        Assertions.assertTrue((boolean)this.c.securityOperations().hasNamespacePermission(this.c.whoami(), this.namespace, NamespacePermission.READ));
        this.c.securityOperations().revokeNamespacePermission(this.c.whoami(), this.namespace, NamespacePermission.READ);
        Assertions.assertFalse((boolean)this.c.securityOperations().hasNamespacePermission(this.c.whoami(), this.namespace, NamespacePermission.READ));
        this.c.securityOperations().grantNamespacePermission(this.c.whoami(), this.namespace, NamespacePermission.READ);
        Assertions.assertTrue((boolean)this.c.securityOperations().hasNamespacePermission(this.c.whoami(), this.namespace, NamespacePermission.READ));
        this.c.namespaceOperations().delete(this.namespace);
        this.assertSecurityException(SecurityErrorCode.NAMESPACE_DOESNT_EXIST, () -> this.c.securityOperations().hasNamespacePermission(this.c.whoami(), this.namespace, NamespacePermission.READ));
        this.assertSecurityException(SecurityErrorCode.NAMESPACE_DOESNT_EXIST, () -> this.c.securityOperations().grantNamespacePermission(this.c.whoami(), this.namespace, NamespacePermission.READ));
        this.assertSecurityException(SecurityErrorCode.NAMESPACE_DOESNT_EXIST, () -> this.c.securityOperations().revokeNamespacePermission(this.c.whoami(), this.namespace, NamespacePermission.READ));
    }

    @Test
    public void verifyTableOperationsExceptions() throws Exception {
        String tableName = this.namespace + ".1";
        IteratorSetting setting = new IteratorSetting(200, VersioningIterator.class);
        Text a = new Text("a");
        Text z = new Text("z");
        TableOperations ops = this.c.tableOperations();
        Assertions.assertFalse((boolean)ops.exists(tableName));
        this.assertAccumuloExceptionNoNamespace(() -> ops.create(tableName));
        ops.create("a");
        this.assertAccumuloExceptionNoNamespace(() -> ops.clone("a", tableName, true, Collections.emptyMap(), Collections.emptySet()));
        ops.offline("a", true);
        ops.exportTable("a", System.getProperty("user.dir") + "/target");
        this.assertAccumuloExceptionNoNamespace(() -> ops.importTable(tableName, Set.of(System.getProperty("user.dir") + "/target"), ImportConfiguration.empty()));
        this.assertAccumuloExceptionNoTableNoNamespace(() -> ops.removeConstraint(tableName, 0));
        this.assertAccumuloExceptionNoTableNoNamespace(() -> ops.removeProperty(tableName, "a"));
        this.assertAccumuloExceptionNoTableNoNamespace(() -> ops.setProperty(tableName, "a", "b"));
        this.assertNoTableNoNamespace(() -> ops.addConstraint(tableName, NumericValueConstraint.class.getName()));
        this.assertNoTableNoNamespace(() -> ops.addSplits(tableName, new TreeSet()));
        this.assertNoTableNoNamespace(() -> ops.attachIterator(tableName, setting));
        this.assertNoTableNoNamespace(() -> ops.cancelCompaction(tableName));
        this.assertNoTableNoNamespace(() -> ops.checkIteratorConflicts(tableName, setting, EnumSet.allOf(IteratorUtil.IteratorScope.class)));
        this.assertNoTableNoNamespace(() -> ops.clearLocatorCache(tableName));
        this.assertNoTableNoNamespace(() -> ops.clone(tableName, "2", true, Collections.emptyMap(), Collections.emptySet()));
        this.assertNoTableNoNamespace(() -> ops.compact(tableName, a, z, true, true));
        this.assertNoTableNoNamespace(() -> ops.delete(tableName));
        this.assertNoTableNoNamespace(() -> ops.deleteRows(tableName, a, z));
        this.assertNoTableNoNamespace(() -> ops.splitRangeByTablets(tableName, new Range(), 10));
        this.assertNoTableNoNamespace(() -> ops.exportTable(tableName, this.namespace + "_dir"));
        this.assertNoTableNoNamespace(() -> ops.flush(tableName, a, z, true));
        this.assertNoTableNoNamespace(() -> ops.getDiskUsage(Set.of(tableName)));
        this.assertNoTableNoNamespace(() -> ops.getIteratorSetting(tableName, "a", IteratorUtil.IteratorScope.scan));
        this.assertNoTableNoNamespace(() -> ops.getLocalityGroups(tableName));
        this.assertNoTableNoNamespace(() -> ops.getMaxRow(tableName, Authorizations.EMPTY, a, true, z, true));
        this.assertNoTableNoNamespace(() -> ops.getConfiguration(tableName));
        this.assertNoTableNoNamespace(() -> ops.importDirectory("").to(tableName).load());
        this.assertNoTableNoNamespace(() -> ops.testClassLoad(tableName, VersioningIterator.class.getName(), SortedKeyValueIterator.class.getName()));
        this.assertNoTableNoNamespace(() -> ops.listConstraints(tableName));
        this.assertNoTableNoNamespace(() -> ops.listIterators(tableName));
        this.assertNoTableNoNamespace(() -> ops.listSplits(tableName));
        this.assertNoTableNoNamespace(() -> ops.merge(tableName, a, z));
        this.assertNoTableNoNamespace(() -> ops.offline(tableName, true));
        this.assertNoTableNoNamespace(() -> ops.online(tableName, true));
        this.assertNoTableNoNamespace(() -> ops.removeIterator(tableName, "a", EnumSet.of(IteratorUtil.IteratorScope.scan)));
        this.assertNoTableNoNamespace(() -> ops.rename(tableName, tableName + "2"));
        this.assertNoTableNoNamespace(() -> ops.setLocalityGroups(tableName, Collections.emptyMap()));
    }

    @Test
    public void verifyNamespaceOperationsExceptions() throws Exception {
        IteratorSetting setting = new IteratorSetting(200, VersioningIterator.class);
        NamespaceOperations ops = this.c.namespaceOperations();
        Assertions.assertFalse((boolean)ops.exists(this.namespace));
        this.assertNoNamespace(() -> ops.addConstraint(this.namespace, NumericValueConstraint.class.getName()));
        this.assertNoNamespace(() -> ops.attachIterator(this.namespace, setting));
        this.assertNoNamespace(() -> ops.checkIteratorConflicts(this.namespace, setting, EnumSet.of(IteratorUtil.IteratorScope.scan)));
        this.assertNoNamespace(() -> ops.delete(this.namespace));
        this.assertNoNamespace(() -> ops.getIteratorSetting(this.namespace, "thing", IteratorUtil.IteratorScope.scan));
        this.assertNoNamespace(() -> ops.getConfiguration(this.namespace));
        this.assertNoNamespace(() -> ops.listConstraints(this.namespace));
        this.assertNoNamespace(() -> ops.listIterators(this.namespace));
        this.assertNoNamespace(() -> ops.removeConstraint(this.namespace, 1));
        this.assertNoNamespace(() -> ops.removeIterator(this.namespace, "thing", EnumSet.allOf(IteratorUtil.IteratorScope.class)));
        this.assertNoNamespace(() -> ops.removeProperty(this.namespace, "a"));
        this.assertNoNamespace(() -> ops.rename(this.namespace, this.namespace + "2"));
        this.assertNoNamespace(() -> ops.setProperty(this.namespace, "k", "v"));
        this.assertNoNamespace(() -> ops.testClassLoad(this.namespace, VersioningIterator.class.getName(), SortedKeyValueIterator.class.getName()));
        this.assertNamespaceExists(() -> ops.create(Namespace.DEFAULT.name()));
        this.assertNamespaceExists(() -> ops.create(Namespace.ACCUMULO.name()));
        ops.create(this.namespace + "0");
        ops.create(this.namespace + "1");
        this.assertNamespaceExists(() -> ops.create(this.namespace + "0"));
        this.assertNamespaceExists(() -> ops.rename(this.namespace + "0", this.namespace + "1"));
        this.assertNamespaceExists(() -> ops.rename(this.namespace + "0", Namespace.DEFAULT.name()));
        this.assertNamespaceExists(() -> ops.rename(this.namespace + "0", Namespace.ACCUMULO.name()));
    }

    private boolean checkTableHasProp(String t, String propKey, String propVal) throws Exception {
        return this.checkHasProperty(t, propKey, propVal, true);
    }

    private boolean checkNamespaceHasProp(String n, String propKey, String propVal) throws Exception {
        return this.checkHasProperty(n, propKey, propVal, false);
    }

    private boolean checkHasProperty(String name, String propKey, String propVal, boolean nameIsTable) throws Exception {
        Map props = nameIsTable ? this.c.tableOperations().getConfiguration(name) : this.c.namespaceOperations().getConfiguration(name);
        for (Map.Entry e : props.entrySet()) {
            if (!propKey.equals(e.getKey())) continue;
            return propVal.equals(e.getValue());
        }
        return false;
    }

    private void assertNamespaceExists(Executable runnable) {
        Assertions.assertThrows(NamespaceExistsException.class, (Executable)runnable);
    }

    private void assertNoNamespace(Executable runnable) {
        Assertions.assertThrows(NamespaceNotFoundException.class, (Executable)runnable);
    }

    private void assertNoTableNoNamespace(Executable runnable) {
        TableNotFoundException e = (TableNotFoundException)Assertions.assertThrows(TableNotFoundException.class, (Executable)runnable);
        Assertions.assertEquals(NamespaceNotFoundException.class, e.getCause().getClass());
    }

    private void assertAccumuloExceptionNoNamespace(Executable runnable) {
        AccumuloException e = (AccumuloException)Assertions.assertThrows(AccumuloException.class, (Executable)runnable);
        Assertions.assertEquals(NamespaceNotFoundException.class, e.getCause().getClass());
    }

    private void assertAccumuloExceptionNoTableNoNamespace(Executable runnable) {
        AccumuloException e = (AccumuloException)Assertions.assertThrows(AccumuloException.class, (Executable)runnable);
        Assertions.assertEquals(TableNotFoundException.class, e.getCause().getClass());
        Assertions.assertEquals(NamespaceNotFoundException.class, e.getCause().getCause().getClass());
    }

    private void assertSecurityException(SecurityErrorCode code, Executable runnable) {
        AccumuloSecurityException e = (AccumuloSecurityException)Assertions.assertThrows(AccumuloSecurityException.class, (Executable)runnable);
        Assertions.assertSame((Object)code, (Object)e.getSecurityErrorCode());
    }

    public static class SimpleFilter
    extends Filter {
        public boolean accept(Key k, Value v) {
            return !k.getColumnFamily().toString().equals("a");
        }
    }
}

