/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.lang.invoke.CallSite;
import java.time.Duration;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class NewTableConfigurationIT
extends SharedMiniClusterBase {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofSeconds(30L);
    }

    @BeforeAll
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniCluster();
    }

    @AfterAll
    public static void teardown() {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @Test
    public void testSetPropertiesOverwriteOlderProperties() throws AccumuloSecurityException, AccumuloException, TableExistsException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            HashMap<CallSite, String> initialProps = new HashMap<CallSite, String>();
            initialProps.put((CallSite)((Object)(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop1")), "val1");
            initialProps.put((CallSite)((Object)(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop2")), "val2");
            ntc.setProperties(initialProps);
            HashMap<CallSite, String> updatedProps = new HashMap<CallSite, String>();
            updatedProps.put((CallSite)((Object)(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "newerprop1")), "newerval1");
            updatedProps.put((CallSite)((Object)(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "newerprop2")), "newerval2");
            ntc.setProperties(updatedProps);
            client.tableOperations().create(tableName, ntc);
            Map props = ntc.getProperties();
            Assertions.assertEquals(props.get(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "newerprop1"), (Object)"newerval1");
            Assertions.assertEquals(props.get(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "newerprop2"), (Object)"newerval2");
            Assertions.assertFalse((boolean)props.containsKey(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop1"));
            Assertions.assertFalse((boolean)props.containsKey(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop2"));
        }
    }

    @Test
    public void testSimpleLocalityGroupCreation() throws AccumuloSecurityException, AccumuloException, TableExistsException, TableNotFoundException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            HashMap<String, Set<Text>> lgroups = new HashMap<String, Set<Text>>();
            lgroups.put("lg1", Set.of(new Text("dog"), new Text("cat")));
            lgroups.put("lg2", Set.of(new Text("lion"), new Text("tiger")));
            ntc.setLocalityGroups(lgroups);
            client.tableOperations().create(tableName, ntc);
            Map createdLocalityGroups = client.tableOperations().getLocalityGroups(tableName);
            Assertions.assertEquals((int)2, (int)createdLocalityGroups.size());
            Assertions.assertEquals(createdLocalityGroups.get("lg1"), Set.of(new Text("dog"), new Text("cat")));
            Assertions.assertEquals(createdLocalityGroups.get("lg2"), Set.of(new Text("lion"), new Text("tiger")));
        }
    }

    @Test
    public void testMulitpleCallsToSetLocalityGroups() throws AccumuloSecurityException, AccumuloException, TableExistsException, TableNotFoundException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            HashMap<String, Set<Text>> initalGroup = new HashMap<String, Set<Text>>();
            initalGroup.put("lg1", Set.of(new Text("dog"), new Text("cat")));
            ntc.setLocalityGroups(initalGroup);
            HashMap<String, Set<Text>> secondGroup = new HashMap<String, Set<Text>>();
            secondGroup.put("lg1", Set.of(new Text("blue"), new Text("red")));
            ntc.setLocalityGroups(secondGroup);
            client.tableOperations().create(tableName, ntc);
            Map createdLocalityGroups = client.tableOperations().getLocalityGroups(tableName);
            Assertions.assertEquals((int)1, (int)createdLocalityGroups.size());
            Assertions.assertEquals(createdLocalityGroups.get("lg1"), Set.of(new Text("red"), new Text("blue")));
        }
    }

    @Test
    public void testSetPropertiesAndGroups() throws AccumuloSecurityException, AccumuloException, TableExistsException, TableNotFoundException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            HashMap<CallSite, String> props = new HashMap<CallSite, String>();
            props.put((CallSite)((Object)(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop1")), "val1");
            props.put((CallSite)((Object)(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop2")), "val2");
            ntc.setProperties(props);
            HashMap<String, Set<Text>> lgroups = new HashMap<String, Set<Text>>();
            lgroups.put("lg1", Set.of(new Text("dog")));
            ntc.setLocalityGroups(lgroups);
            client.tableOperations().create(tableName, ntc);
            int count = 0;
            for (Map.Entry property : client.tableOperations().getProperties(tableName)) {
                if (((String)property.getKey()).equals("table.group.lg1")) {
                    Assertions.assertEquals(property.getValue(), (Object)"dog");
                    ++count;
                }
                if (((String)property.getKey()).equals("table.groups.enabled")) {
                    Assertions.assertEquals(property.getValue(), (Object)"lg1");
                    ++count;
                }
                if (((String)property.getKey()).equals(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop1")) {
                    Assertions.assertEquals(property.getValue(), (Object)"val1");
                    ++count;
                }
                if (!((String)property.getKey()).equals(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop2")) continue;
                Assertions.assertEquals(property.getValue(), (Object)"val2");
                ++count;
            }
            Assertions.assertEquals((int)4, (int)count);
            Map createdLocalityGroups = client.tableOperations().getLocalityGroups(tableName);
            Assertions.assertEquals((int)1, (int)createdLocalityGroups.size());
            Assertions.assertEquals(createdLocalityGroups.get("lg1"), Set.of(new Text("dog")));
        }
    }

    @Test
    public void testSetGroupsWithoutDefaultIterators() throws AccumuloSecurityException, AccumuloException, TableExistsException, TableNotFoundException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration().withoutDefaultIterators();
            HashMap<String, Set<Text>> lgroups = new HashMap<String, Set<Text>>();
            lgroups.put("lg1", Set.of(new Text("colF")));
            ntc.setLocalityGroups(lgroups);
            client.tableOperations().create(tableName, ntc);
            Map createdLocalityGroups = client.tableOperations().getLocalityGroups(tableName);
            Assertions.assertEquals((int)1, (int)createdLocalityGroups.size());
            Assertions.assertEquals(createdLocalityGroups.get("lg1"), Set.of(new Text("colF")));
            Map iterators = client.tableOperations().listIterators(tableName);
            Assertions.assertEquals((int)0, (int)iterators.size());
        }
    }

    @Test
    public void testPreconfigureIteratorWithDefaultIterator1() throws AccumuloException, TableNotFoundException, AccumuloSecurityException, TableExistsException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            ntc.attachIterator(new IteratorSetting(10, "anIterator", "it.class", Collections.emptyMap()), EnumSet.of(IteratorUtil.IteratorScope.scan));
            client.tableOperations().create(tableName, ntc);
            Map iteratorList = client.tableOperations().listIterators(tableName);
            Assertions.assertEquals((int)2, (int)iteratorList.size());
            this.verifyIterators(client, tableName, new String[]{"table.iterator.scan.anIterator=10,it.class"}, true);
            client.tableOperations().removeIterator(tableName, "anIterator", EnumSet.of(IteratorUtil.IteratorScope.scan));
            this.verifyIterators(client, tableName, new String[0], true);
            iteratorList = client.tableOperations().listIterators(tableName);
            Assertions.assertEquals((int)1, (int)iteratorList.size());
        }
    }

    @Test
    public void testPreconfiguredIteratorWithDefaultIterator2() throws AccumuloException, TableNotFoundException, AccumuloSecurityException, TableExistsException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            IteratorSetting setting = new IteratorSetting(10, "someName", "foo.bar");
            ntc.attachIterator(setting);
            client.tableOperations().create(tableName, ntc);
            Map iteratorList = client.tableOperations().listIterators(tableName);
            Assertions.assertEquals((int)2, (int)iteratorList.size());
            this.verifyIterators(client, tableName, new String[]{"table.iterator.scan.someName=10,foo.bar"}, true);
            client.tableOperations().removeIterator(tableName, "someName", EnumSet.allOf(IteratorUtil.IteratorScope.class));
            this.verifyIterators(client, tableName, new String[0], true);
            Map iteratorList2 = client.tableOperations().listIterators(tableName);
            Assertions.assertEquals((int)1, (int)iteratorList2.size());
        }
    }

    @Test
    public void testPreconfiguredIteratorWithDefaultIterator3() throws AccumuloException, TableNotFoundException, AccumuloSecurityException, TableExistsException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            IteratorSetting setting = new IteratorSetting(10, "someName", "foo.bar");
            ntc.attachIterator(setting, EnumSet.of(IteratorUtil.IteratorScope.scan));
            client.tableOperations().create(tableName, ntc);
            this.verifyIterators(client, tableName, new String[]{"table.iterator.scan.someName=10,foo.bar"}, true);
            Map iteratorList = client.tableOperations().listIterators(tableName);
            Assertions.assertEquals((int)2, (int)iteratorList.size());
            Assertions.assertEquals(iteratorList.get("someName"), EnumSet.of(IteratorUtil.IteratorScope.scan));
            client.tableOperations().removeIterator(tableName, "someName", EnumSet.of(IteratorUtil.IteratorScope.scan));
            this.verifyIterators(client, tableName, new String[0], true);
            iteratorList = client.tableOperations().listIterators(tableName);
            Assertions.assertEquals((int)1, (int)iteratorList.size());
        }
    }

    @Test
    public void testSettingInitialIteratorWithAdditionalIteratorOptions() throws AccumuloException, TableNotFoundException, AccumuloSecurityException, TableExistsException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            IteratorSetting setting = new IteratorSetting(10, "someName", "foo.bar");
            setting.addOptions(Collections.singletonMap("key", "value"));
            ntc.attachIterator(setting);
            client.tableOperations().create(tableName, ntc);
            this.verifyIterators(client, tableName, new String[]{"table.iterator.scan.someName=10,foo.bar", "table.iterator.scan.someName.opt.key=value"}, true);
            client.tableOperations().removeIterator(tableName, "someName", EnumSet.of(IteratorUtil.IteratorScope.scan));
            this.verifyIterators(client, tableName, new String[0], true);
        }
    }

    @Test
    public void testSetIteratorWithoutDefaultIterators() throws AccumuloException, TableNotFoundException, AccumuloSecurityException, TableExistsException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration().withoutDefaultIterators();
            IteratorSetting setting = new IteratorSetting(10, "myIterator", "my.class");
            ntc.attachIterator(setting);
            client.tableOperations().create(tableName, ntc);
            Map iteratorList = client.tableOperations().listIterators(tableName);
            Assertions.assertEquals((int)1, (int)iteratorList.size());
            this.verifyIterators(client, tableName, new String[]{"table.iterator.scan.myIterator=10,my.class"}, false);
            client.tableOperations().removeIterator(tableName, "myIterator", EnumSet.allOf(IteratorUtil.IteratorScope.class));
            this.verifyIterators(client, tableName, new String[0], false);
            Map iteratorList2 = client.tableOperations().listIterators(tableName);
            Assertions.assertEquals((int)0, (int)iteratorList2.size());
        }
    }

    @Test
    public void testSettingIteratorAndProperties() throws AccumuloException, TableNotFoundException, AccumuloSecurityException, TableExistsException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            IteratorSetting setting = new IteratorSetting(10, "someName", "foo.bar");
            ntc.attachIterator(setting);
            HashMap<CallSite, String> props = new HashMap<CallSite, String>();
            props.put((CallSite)((Object)(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop1")), "val1");
            props.put((CallSite)((Object)(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop2")), "val2");
            ntc.setProperties(props);
            client.tableOperations().create(tableName, ntc);
            int count = 0;
            for (Map.Entry property : client.tableOperations().getProperties(tableName)) {
                if (((String)property.getKey()).equals(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop1")) {
                    Assertions.assertEquals(property.getValue(), (Object)"val1");
                    ++count;
                }
                if (!((String)property.getKey()).equals(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop2")) continue;
                Assertions.assertEquals(property.getValue(), (Object)"val2");
                ++count;
            }
            Assertions.assertEquals((int)2, (int)count);
            this.verifyIterators(client, tableName, new String[]{"table.iterator.scan.someName=10,foo.bar"}, true);
            client.tableOperations().removeIterator(tableName, "someName", EnumSet.of(IteratorUtil.IteratorScope.scan));
            this.verifyIterators(client, tableName, new String[0], true);
        }
    }

    @Test
    public void testMultipleIteratorValid() throws AccumuloException, TableNotFoundException, AccumuloSecurityException, TableExistsException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            IteratorSetting setting = new IteratorSetting(10, "firstIterator", "first.class");
            ntc.attachIterator(setting, EnumSet.of(IteratorUtil.IteratorScope.scan));
            setting = new IteratorSetting(11, "secondIterator", "second.class");
            ntc.attachIterator(setting, EnumSet.of(IteratorUtil.IteratorScope.scan));
            client.tableOperations().create(tableName, ntc);
            this.verifyIterators(client, tableName, new String[]{"table.iterator.scan.firstIterator=10,first.class", "table.iterator.scan.secondIterator=11,second.class"}, true);
            client.tableOperations().removeIterator(tableName, "firstIterator", EnumSet.of(IteratorUtil.IteratorScope.scan));
            this.verifyIterators(client, tableName, new String[]{"table.iterator.scan.secondIterator=11,second.class"}, true);
            client.tableOperations().removeIterator(tableName, "secondIterator", EnumSet.of(IteratorUtil.IteratorScope.scan));
            this.verifyIterators(client, tableName, new String[0], true);
        }
    }

    @Test
    public void testGroupsIteratorAndPropsTogether() throws AccumuloException, TableNotFoundException, AccumuloSecurityException, TableExistsException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            IteratorSetting setting = new IteratorSetting(10, "someName", "foo.bar");
            ntc.attachIterator(setting, EnumSet.of(IteratorUtil.IteratorScope.scan));
            HashMap<CallSite, String> props = new HashMap<CallSite, String>();
            props.put((CallSite)((Object)(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop1")), "val1");
            ntc.setProperties(props);
            HashMap<String, Set<Text>> lgroups = new HashMap<String, Set<Text>>();
            lgroups.put("lg1", Set.of(new Text("colF")));
            ntc.setLocalityGroups(lgroups);
            client.tableOperations().create(tableName, ntc);
            int count = 0;
            for (Map.Entry property : client.tableOperations().getProperties(tableName)) {
                if (!((String)property.getKey()).equals(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop1")) continue;
                Assertions.assertEquals(property.getValue(), (Object)"val1");
                ++count;
            }
            Assertions.assertEquals((int)1, (int)count);
            Map createdLocalityGroups = client.tableOperations().getLocalityGroups(tableName);
            Assertions.assertEquals((int)1, (int)createdLocalityGroups.size());
            Assertions.assertEquals(createdLocalityGroups.get("lg1"), Set.of(new Text("colF")));
            this.verifyIterators(client, tableName, new String[]{"table.iterator.scan.someName=10,foo.bar"}, true);
            client.tableOperations().removeIterator(tableName, "someName", EnumSet.of(IteratorUtil.IteratorScope.scan));
            this.verifyIterators(client, tableName, new String[0], true);
        }
    }

    @Test
    public void testNtcChaining() throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            IteratorSetting setting = new IteratorSetting(10, "anIterator", "it.class", Collections.emptyMap());
            HashMap<String, Set<Text>> lgroups = new HashMap<String, Set<Text>>();
            lgroups.put("lgp", Set.of(new Text("col")));
            NewTableConfiguration ntc = new NewTableConfiguration().withoutDefaultIterators().attachIterator(setting, EnumSet.of(IteratorUtil.IteratorScope.scan)).setLocalityGroups(lgroups);
            client.tableOperations().create(tableName, ntc);
            Map iteratorList = client.tableOperations().listIterators(tableName);
            Assertions.assertEquals((int)1, (int)iteratorList.size());
            this.verifyIterators(client, tableName, new String[]{"table.iterator.scan.anIterator=10,it.class"}, false);
            client.tableOperations().removeIterator(tableName, "anIterator", EnumSet.of(IteratorUtil.IteratorScope.scan));
            this.verifyIterators(client, tableName, new String[0], false);
            iteratorList = client.tableOperations().listIterators(tableName);
            Assertions.assertEquals((int)0, (int)iteratorList.size());
            int count = 0;
            for (Map.Entry property : client.tableOperations().getProperties(tableName)) {
                if (((String)property.getKey()).equals("table.group.lgp")) {
                    Assertions.assertEquals(property.getValue(), (Object)"col");
                    ++count;
                }
                if (!((String)property.getKey()).equals("table.groups.enabled")) continue;
                Assertions.assertEquals(property.getValue(), (Object)"lgp");
                ++count;
            }
            Assertions.assertEquals((int)2, (int)count);
            Map createdLocalityGroups = client.tableOperations().getLocalityGroups(tableName);
            Assertions.assertEquals((int)1, (int)createdLocalityGroups.size());
            Assertions.assertEquals(createdLocalityGroups.get("lgp"), Set.of(new Text("col")));
        }
    }

    private void verifyIterators(AccumuloClient client, String tablename, String[] values, boolean withDefaultIts) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        TreeMap<String, String> expected = new TreeMap<String, String>();
        if (withDefaultIts) {
            expected.put("table.iterator.scan.vers", "20,org.apache.accumulo.core.iterators.user.VersioningIterator");
            expected.put("table.iterator.scan.vers.opt.maxVersions", "1");
        }
        for (String value : values) {
            String[] parts = value.split("=", 2);
            expected.put(parts[0], parts[1]);
        }
        TreeMap<String, String> actual = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : this.getProperties(client, tablename).entrySet()) {
            if (!entry.getKey().contains("table.iterator.scan.")) continue;
            actual.put(entry.getKey(), entry.getValue());
        }
        Assertions.assertEquals(expected, actual);
    }

    private Map<String, String> getProperties(AccumuloClient accumuloClient, String tableName) throws AccumuloException, TableNotFoundException {
        Map properties = accumuloClient.tableOperations().getConfiguration(tableName);
        return Map.copyOf(properties);
    }
}

