/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.client.summary.summarizers.VisibilitySummarizer;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.rfile.PrintInfo;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class PrintInfoIT
extends SharedMiniClusterBase {
    @TempDir
    private static File tempDir;

    @BeforeAll
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniCluster();
    }

    @AfterAll
    public static void teardown() {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @Test
    public void testRFileNotContainingSummaryInfo() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient accumuloClient = (AccumuloClient)Accumulo.newClient().from(PrintInfoIT.getClientProps()).build();){
            this.createTableAndFlush(accumuloClient, table, false);
            String rFileName = this.getRFileName(accumuloClient, table);
            String output = this.execPrintInfo(rFileName, false);
            Assertions.assertTrue((boolean)output.contains("RFile Version            : 8"));
            Assertions.assertFalse((boolean)output.contains("Meta block     : accumulo.summaries.index"));
            Assertions.assertFalse((boolean)output.contains("No summary data present in file"));
            output = this.execPrintInfo(rFileName, true);
            Assertions.assertTrue((boolean)output.contains("RFile Version            : 8"));
            Assertions.assertFalse((boolean)output.contains("Meta block     : accumulo.summaries.index"));
            Assertions.assertTrue((boolean)output.contains("No summary data present in file"));
        }
    }

    @Test
    public void testRFileContainingSummaryInfo() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient accumuloClient = (AccumuloClient)Accumulo.newClient().from(PrintInfoIT.getClientProps()).build();){
            this.createTableAndFlush(accumuloClient, table, true);
            String rFileName = this.getRFileName(accumuloClient, table);
            String output = this.execPrintInfo(rFileName, false);
            Assertions.assertTrue((boolean)output.contains("RFile Version            : 8"));
            Assertions.assertTrue((boolean)output.contains("Meta block     : accumulo.summaries.index"));
            Assertions.assertFalse((boolean)output.contains("No summary data present in file"));
            output = this.execPrintInfo(rFileName, true);
            Assertions.assertTrue((boolean)output.contains("RFile Version            : 8"));
            Assertions.assertTrue((boolean)output.contains("Meta block     : accumulo.summaries.index"));
            Assertions.assertFalse((boolean)output.contains("No summary data present in file"));
            Assertions.assertTrue((boolean)output.contains("Summary data :"));
        }
    }

    @Test
    public void testOldRFileVersion() throws Exception {
        String resource = "/org/apache/accumulo/test/ver_7.rf";
        File rFile = new File(tempDir, resource);
        FileUtils.copyURLToFile((URL)Objects.requireNonNull(PrintInfoIT.class.getResource(resource)), (File)rFile);
        String output = this.execPrintInfo(rFile.getAbsolutePath(), false);
        Assertions.assertTrue((boolean)output.contains("Unable to read crypto params"));
        Assertions.assertTrue((boolean)output.contains("RFile Version            : 7"));
        Assertions.assertFalse((boolean)output.contains("No summary data present in file"));
    }

    private void createTableAndFlush(AccumuloClient client, String tableName, boolean enableSummaries) throws AccumuloException, TableExistsException, AccumuloSecurityException, TableNotFoundException {
        client.tableOperations().create(tableName);
        BatchWriterConfig config = new BatchWriterConfig();
        config.setMaxMemory(0L);
        try (BatchWriter writer = client.createBatchWriter(tableName, config);){
            Mutation m = new Mutation((CharSequence)"row1");
            m.put((CharSequence)"cf1", (CharSequence)"cq1", new ColumnVisibility("A"), new Value((CharSequence)"value1"));
            writer.addMutation(m);
            m = new Mutation((CharSequence)"row2");
            m.put((CharSequence)"cf2", (CharSequence)"cq2", new ColumnVisibility("B"), new Value((CharSequence)"value2"));
            writer.addMutation(m);
            m = new Mutation((CharSequence)"row3");
            m.put((CharSequence)"cf3", (CharSequence)"cq3", new ColumnVisibility("A&B"), new Value((CharSequence)"value3"));
            writer.addMutation(m);
        }
        if (enableSummaries) {
            SummarizerConfiguration sc1 = SummarizerConfiguration.builder(VisibilitySummarizer.class).build();
            client.tableOperations().addSummarizers(tableName, new SummarizerConfiguration[]{sc1});
        }
        client.tableOperations().flush(tableName, null, null, true);
    }

    private String getRFileName(AccumuloClient client, String tableName) throws Exception {
        boolean foundFile = false;
        String rfileName = null;
        try (BatchScanner bscanner = client.createBatchScanner(MetadataTable.NAME, Authorizations.EMPTY, 1);){
            String tableId = (String)client.tableOperations().tableIdMap().get(tableName);
            bscanner.setRanges(Collections.singletonList(new Range(new Text(tableId + ";"), new Text(tableId + "<"))));
            bscanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            for (Map.Entry entry : bscanner) {
                foundFile = true;
                rfileName = ((Key)entry.getKey()).getColumnQualifier().toString();
            }
            Assertions.assertTrue((boolean)foundFile);
        }
        return rfileName;
    }

    private String execPrintInfo(String rfile, boolean useSummaryArg) throws Exception {
        MiniAccumuloClusterImpl.ProcessInfo p = useSummaryArg ? PrintInfoIT.getCluster().exec(PrintInfo.class, new String[]{rfile, "--summary"}) : PrintInfoIT.getCluster().exec(PrintInfo.class, new String[]{rfile});
        Assertions.assertEquals((int)0, (int)p.getProcess().waitFor(), (String)"Call to PrintInfo failed");
        String rfileOutput = p.readStdOut();
        return rfileOutput;
    }
}

