/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.time.Duration;
import java.util.Map;
import org.apache.accumulo.cluster.ClusterControl;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecoveryCompactionsAreFlushesIT
extends AccumuloClusterHarness {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(3L);
    }

    @Override
    public boolean canRunTest(AccumuloClusterHarness.ClusterType type) {
        return type == AccumuloClusterHarness.ClusterType.MINI;
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Test
    public void test() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(RecoveryCompactionsAreFlushesIT.getClientProps()).build();){
            c.tableOperations().create(tableName);
            c.tableOperations().setProperty(tableName, Property.TABLE_MAJC_RATIO.getKey(), "100");
            c.tableOperations().setProperty(tableName, Property.TABLE_FILE_MAX.getKey(), "3");
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                Mutation m = new Mutation((CharSequence)"a");
                m.put((CharSequence)"b", (CharSequence)"c", new Value((CharSequence)"v"));
                for (int i = 0; i < 3; ++i) {
                    bw.addMutation(m);
                    bw.flush();
                    c.tableOperations().flush(tableName, null, null, true);
                }
                bw.addMutation(m);
            }
            ClusterControl control = cluster.getClusterControl();
            control.stopAllServers(ServerType.TABLET_SERVER);
            control.startAllServers(ServerType.TABLET_SERVER);
            try (Scanner scanner = c.createScanner(tableName, Authorizations.EMPTY);){
                scanner.forEach((k, v) -> {});
            }
            try (Scanner s = c.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                s.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                for (Map.Entry entry : s) {
                    String filename = ((Key)entry.getKey()).getColumnQualifier().toString();
                    String[] parts = filename.split("/");
                    Assertions.assertFalse((boolean)parts[parts.length - 1].startsWith("M"));
                }
            }
        }
    }
}

