/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.ScanServerIT;
import org.apache.accumulo.test.util.Wait;
import org.apache.hadoop.conf.Configuration;
import org.apache.zookeeper.KeeperException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="MiniClusterOnly")
public class ScanServerConcurrentTabletScanIT
extends SharedMiniClusterBase {
    @BeforeAll
    public static void start() throws Exception {
        ScanServerConcurrentTabletScanITConfiguration c = new ScanServerConcurrentTabletScanITConfiguration();
        SharedMiniClusterBase.startMiniClusterWithConfig(c);
    }

    @AfterAll
    public static void stop() throws Exception {
        SharedMiniClusterBase.stopMiniCluster();
    }

    private void startScanServer(String cacheExpiration, String cacheRefresh) throws IOException, KeeperException, InterruptedException {
        String zooRoot = ScanServerConcurrentTabletScanIT.getCluster().getServerContext().getZooKeeperRoot();
        ZooReaderWriter zrw = ScanServerConcurrentTabletScanIT.getCluster().getServerContext().getZooReaderWriter();
        String scanServerRoot = zooRoot + "/sservers";
        SharedMiniClusterBase.getCluster().getClusterControl().stop(ServerType.SCAN_SERVER);
        HashMap<String, String> overrides = new HashMap<String, String>();
        overrides.put(Property.SSERV_CACHED_TABLET_METADATA_EXPIRATION.getKey(), cacheExpiration);
        overrides.put(Property.SSERV_CACHED_TABLET_METADATA_REFRESH_PERCENT.getKey(), cacheRefresh);
        SharedMiniClusterBase.getCluster().getClusterControl().start(ServerType.SCAN_SERVER, overrides, 1);
        while (zrw.getChildren(scanServerRoot).size() == 0) {
            Thread.sleep(500L);
        }
    }

    @Test
    public void testScanSameTabletDifferentDataTmCacheEnabledRefreshNotTriggered() throws Exception {
        this.startScanServer("10m", ".5");
        this.testScanSameTabletDifferentDataTabletMetadataCacheEnabled(false);
    }

    @Test
    public void testScanSameTabletDifferentDataTmCacheEnabledRefreshTriggered() throws Exception {
        this.startScanServer("10m", ".00001");
        this.testScanSameTabletDifferentDataTabletMetadataCacheEnabled(true);
    }

    @Test
    public void testScanSameTabletDifferentDataTmCacheEnabledRefreshDisabled() throws Exception {
        this.startScanServer("5m", "0");
        this.testScanSameTabletDifferentDataTabletMetadataCacheEnabled(false);
    }

    private void testScanSameTabletDifferentDataTabletMetadataCacheEnabled(boolean shouldRefresh) throws Exception {
        Properties clientProperties = ScanServerConcurrentTabletScanIT.getClientProps();
        clientProperties.put(ClientProperty.SCANNER_BATCH_SIZE.getKey(), "100");
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(clientProperties).build();){
            int count1;
            String tableName = this.getUniqueNames(1)[0];
            int firstBatchOfEntriesCount = ScanServerIT.createTableAndIngest(client, tableName, null, 10, 100, "COLA");
            Scanner scanner1 = client.createScanner(tableName, Authorizations.EMPTY);
            scanner1.setRange(new Range());
            scanner1.setBatchSize(100);
            scanner1.setReadaheadThreshold(0L);
            scanner1.setConsistencyLevel(ScannerBase.ConsistencyLevel.EVENTUAL);
            Iterator iter1 = scanner1.iterator();
            for (count1 = 0; iter1.hasNext() && count1 < 10; ++count1) {
                iter1.next();
            }
            int secondBatchOfEntriesCount = ScanServerIT.ingest(client, tableName, 10, 10, 0, "COLB", true);
            Thread.sleep(1000L);
            Iterator iter2 = scanner1.iterator();
            int count2 = 0;
            boolean useIter1 = true;
            do {
                if (useIter1) {
                    if (iter1.hasNext()) {
                        iter1.next();
                        ++count1;
                    }
                } else if (iter2.hasNext()) {
                    iter2.next();
                    ++count2;
                }
                boolean bl = useIter1 = !useIter1;
            } while (iter1.hasNext() || iter2.hasNext());
            Assertions.assertEquals((int)firstBatchOfEntriesCount, (int)count1);
            Assertions.assertEquals((int)firstBatchOfEntriesCount, (int)count2);
            if (shouldRefresh) {
                Wait.waitFor(() -> this.countEntries(scanner1) == firstBatchOfEntriesCount + secondBatchOfEntriesCount, 10000L, 500L);
            } else {
                Thread.sleep(1000L);
                Assertions.assertEquals((int)firstBatchOfEntriesCount, (int)this.countEntries(scanner1));
            }
            scanner1.close();
            try (Scanner scanner2 = client.createScanner(tableName, Authorizations.EMPTY);){
                int totalEntriesExpected = firstBatchOfEntriesCount + secondBatchOfEntriesCount;
                Assertions.assertEquals((int)totalEntriesExpected, (int)Iterables.size((Iterable)scanner2));
            }
        }
    }

    private int countEntries(Scanner scanner) {
        int count = 0;
        Iterator iter = scanner.iterator();
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        return count;
    }

    @Test
    public void testScanSameTabletDifferentDataTabletMetadataCacheDisabled() throws Exception {
        this.startScanServer("0m", "0");
        Properties clientProperties = ScanServerConcurrentTabletScanIT.getClientProps();
        clientProperties.put(ClientProperty.SCANNER_BATCH_SIZE.getKey(), "100");
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(clientProperties).build();){
            String tableName = this.getUniqueNames(1)[0];
            int firstBatchOfEntriesCount = ScanServerIT.createTableAndIngest(client, tableName, null, 10, 100, "COLA");
            try (Scanner scanner1 = client.createScanner(tableName, Authorizations.EMPTY);){
                int count1;
                scanner1.setRange(new Range());
                scanner1.setBatchSize(100);
                scanner1.setReadaheadThreshold(0L);
                scanner1.setConsistencyLevel(ScannerBase.ConsistencyLevel.EVENTUAL);
                Iterator iter1 = scanner1.iterator();
                for (count1 = 0; iter1.hasNext() && count1 < 10; ++count1) {
                    iter1.next();
                }
                int secondBatchOfEntriesCount = ScanServerIT.ingest(client, tableName, 10, 10, 0, "COLB", true);
                Iterator iter2 = scanner1.iterator();
                int count2 = 0;
                boolean useIter1 = true;
                do {
                    if (useIter1) {
                        if (iter1.hasNext()) {
                            iter1.next();
                            ++count1;
                        }
                    } else if (iter2.hasNext()) {
                        iter2.next();
                        ++count2;
                    }
                    boolean bl = useIter1 = !useIter1;
                } while (iter1.hasNext() || iter2.hasNext());
                Assertions.assertEquals((int)firstBatchOfEntriesCount, (int)count1);
                Assertions.assertEquals((int)(firstBatchOfEntriesCount + secondBatchOfEntriesCount), (int)count2);
            }
        }
    }

    private static class ScanServerConcurrentTabletScanITConfiguration
    implements MiniClusterConfigurationCallback {
        private ScanServerConcurrentTabletScanITConfiguration() {
        }

        @Override
        public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
            cfg.setNumScanServers(1);
            cfg.setProperty(Property.TSERV_SESSION_MAXIDLE, "3s");
            cfg.setProperty(Property.SSERV_MINTHREADS, "4");
        }
    }
}

