/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterables;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.ScanServerIT;
import org.apache.accumulo.test.util.Wait;
import org.apache.accumulo.tserver.ScanServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.zookeeper.ZooKeeper;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class ScanServerGroupConfigurationIT
extends SharedMiniClusterBase {
    private static final String clientConfiguration = "[ {   \"isDefault\": true,   \"maxBusyTimeout\": \"5m\",   \"busyTimeoutMultiplier\": 8,   \"scanTypeActivations\": [],   \"attemptPlans\": [     {       \"servers\": \"3\",       \"busyTimeout\": \"33ms\",       \"salt\": \"one\"     },     {       \"servers\": \"13\",       \"busyTimeout\": \"33ms\",       \"salt\": \"two\"     },     {       \"servers\": \"100%\",       \"busyTimeout\": \"33ms\"     }   ]  }, {   \"isDefault\": false,   \"maxBusyTimeout\": \"5m\",   \"busyTimeoutMultiplier\": 8,   \"group\": \"GROUP1\",   \"scanTypeActivations\": [\"use_group1\"],   \"attemptPlans\": [     {       \"servers\": \"3\",       \"busyTimeout\": \"33ms\",       \"salt\": \"one\"     },     {       \"servers\": \"13\",       \"busyTimeout\": \"33ms\",       \"salt\": \"two\"     },     {       \"servers\": \"100%\",       \"busyTimeout\": \"33ms\"     }   ]  }]";

    @BeforeAll
    public static void start() throws Exception {
        SharedMiniClusterBase.startMiniClusterWithConfig(new Config());
    }

    @AfterAll
    public static void after() throws Exception {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @Test
    public void testClientConfiguration() throws Exception {
        String zooRoot = ScanServerGroupConfigurationIT.getCluster().getServerContext().getZooKeeperRoot();
        ZooKeeper zk = ScanServerGroupConfigurationIT.getCluster().getServerContext().getZooReaderWriter().getZooKeeper();
        String scanServerRoot = zooRoot + "/sservers";
        Wait.waitFor(() -> zk.getChildren(scanServerRoot, false).size() == 0);
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ScanServerGroupConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            int ingestedEntryCount = ScanServerIT.createTableAndIngest(client, tableName, null, 10, 10, "colf");
            Assertions.assertEquals((int)100, (int)ingestedEntryCount);
            try (Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);){
                scanner.setRange(new Range());
                scanner.setConsistencyLevel(ScannerBase.ConsistencyLevel.EVENTUAL);
                Assertions.assertEquals((int)ingestedEntryCount, (int)Iterables.size((Iterable)scanner), (String)"The scanner should fall back to the tserver and should have seen all ingested and flushed entries");
                ScanServerGroupConfigurationIT.getCluster().getConfig().setNumScanServers(1);
                ScanServerGroupConfigurationIT.getCluster().getClusterControl().start(ServerType.SCAN_SERVER, "localhost");
                Wait.waitFor(() -> zk.getChildren(scanServerRoot, false).size() == 1, 30000L);
                Wait.waitFor(() -> ((ClientContext)client).getScanServers().values().stream().anyMatch(p -> ((String)p.getSecond()).equals("default")));
                Assertions.assertEquals((int)ingestedEntryCount, (int)Iterables.size((Iterable)scanner), (String)"The scan server scanner should have seen all ingested and flushed entries");
                int additionalIngest1 = ScanServerIT.ingest(client, tableName, 10, 10, 10, "colf", true);
                Assertions.assertEquals((int)100, (int)additionalIngest1);
                ScanServerGroupConfigurationIT.getCluster().getConfig().setNumScanServers(2);
                ScanServerGroupConfigurationIT.getCluster()._exec(ScanServer.class, ServerType.SCAN_SERVER, Map.of(), new String[]{"-g", "GROUP1"});
                Wait.waitFor(() -> zk.getChildren(scanServerRoot, false).size() == 2);
                Wait.waitFor(() -> ((ClientContext)client).getScanServers().values().stream().anyMatch(p -> ((String)p.getSecond()).equals("default")));
                Wait.waitFor(() -> ((ClientContext)client).getScanServers().values().stream().anyMatch(p -> ((String)p.getSecond()).equals("GROUP1")));
                scanner.setExecutionHints(Map.of("scan_type", "use_group1"));
                Assertions.assertEquals((int)(ingestedEntryCount + additionalIngest1), (int)Iterables.size((Iterable)scanner), (String)"The scan server scanner should have seen all ingested and flushed entries");
                int additionalIngest2 = ScanServerIT.ingest(client, tableName, 10, 10, 20, "colf", false);
                Assertions.assertEquals((int)100, (int)additionalIngest2);
                Assertions.assertEquals((int)(ingestedEntryCount + additionalIngest1), (int)Iterables.size((Iterable)scanner), (String)"The scan server scanner should have seen all ingested and flushed entries");
                scanner.setConsistencyLevel(ScannerBase.ConsistencyLevel.IMMEDIATE);
                Assertions.assertEquals((int)(ingestedEntryCount + additionalIngest1 + additionalIngest2), (int)Iterables.size((Iterable)scanner), (String)"Scanning against tserver should have resulted in seeing all ingested entries");
            }
        }
    }

    private static class Config
    implements MiniClusterConfigurationCallback {
        private Config() {
        }

        @Override
        public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
            cfg.setNumScanServers(0);
            cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT.getKey(), "10s");
            cfg.setClientProperty(ClientProperty.SCAN_SERVER_SELECTOR_OPTS_PREFIX.getKey() + "profiles", ScanServerGroupConfigurationIT.clientConfiguration);
        }
    }
}

