/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TimedOutException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.spi.scan.ConfigurableScanServerSelector;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.ScanServerIT;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="MiniClusterOnly")
public class ScanServerIT_NoServers
extends SharedMiniClusterBase {
    @BeforeAll
    public static void start() throws Exception {
        ScanServerITConfiguration c = new ScanServerITConfiguration();
        SharedMiniClusterBase.startMiniClusterWithConfig(c);
    }

    @AfterAll
    public static void stop() throws Exception {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @Test
    public void testScan() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ScanServerIT_NoServers.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            int ingestedEntryCount = ScanServerIT.createTableAndIngest(client, tableName, null, 10, 10, "colf");
            try (Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);){
                scanner.setRange(new Range());
                scanner.setConsistencyLevel(ScannerBase.ConsistencyLevel.EVENTUAL);
                Assertions.assertEquals((int)ingestedEntryCount, (int)Iterables.size((Iterable)scanner), (String)"Scanner did not see ingested and flushed entries");
                int additionalIngestedEntryCount = ScanServerIT.ingest(client, tableName, 10, 10, 10, "colf", false);
                Assertions.assertEquals((int)(ingestedEntryCount + additionalIngestedEntryCount), (int)Iterables.size((Iterable)scanner), (String)"Scanning against tserver should have resulted in seeing all ingested entries");
            }
        }
    }

    @Test
    public void testBatchScan() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ScanServerIT_NoServers.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            int ingestedEntryCount = ScanServerIT.createTableAndIngest(client, tableName, null, 10, 10, "colf");
            try (BatchScanner scanner = client.createBatchScanner(tableName, Authorizations.EMPTY);){
                scanner.setRanges(Collections.singletonList(new Range()));
                scanner.setConsistencyLevel(ScannerBase.ConsistencyLevel.EVENTUAL);
                Assertions.assertEquals((int)ingestedEntryCount, (int)Iterables.size((Iterable)scanner), (String)"Scanner did not see ingested and flushed entries");
                int additionalIngestedEntryCount = ScanServerIT.ingest(client, tableName, 10, 10, 10, "colf", false);
                Assertions.assertEquals((int)(ingestedEntryCount + additionalIngestedEntryCount), (int)Iterables.size((Iterable)scanner), (String)"Scanning against tserver should have resulted in seeing all ingested entries");
            }
        }
    }

    @Test
    public void testScanWithNoTserverFallback() throws Exception {
        Properties clientProps = new Properties();
        clientProps.putAll((Map<?, ?>)ScanServerIT_NoServers.getClientProps());
        String scanServerSelectorProfiles = "[{'isDefault':true,'maxBusyTimeout':'5m','busyTimeoutMultiplier':8, 'scanTypeActivations':[], 'timeToWaitForScanServers':'120s','attemptPlans':[{'servers':'3', 'busyTimeout':'1s'}]}]";
        clientProps.put("scan.server.selector.impl", ConfigurableScanServerSelector.class.getName());
        clientProps.put("scan.server.selector.opts.profiles", scanServerSelectorProfiles.replace("'", "\""));
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(clientProps).build();){
            String tableName = this.getUniqueNames(1)[0];
            ScanServerIT.createTableAndIngest(client, tableName, null, 10, 10, "colf");
            Assertions.assertThrows(TimedOutException.class, () -> {
                try (Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);){
                    scanner.setRange(new Range());
                    scanner.setTimeout(1L, TimeUnit.SECONDS);
                    scanner.setConsistencyLevel(ScannerBase.ConsistencyLevel.EVENTUAL);
                    Assertions.assertEquals((int)100, (int)Iterables.size((Iterable)scanner));
                }
            });
        }
    }

    @Test
    public void testBatchScanWithNoTserverFallback() throws Exception {
        Properties clientProps = new Properties();
        clientProps.putAll((Map<?, ?>)ScanServerIT_NoServers.getClientProps());
        String scanServerSelectorProfiles = "[{'isDefault':true,'maxBusyTimeout':'5m','busyTimeoutMultiplier':8, 'scanTypeActivations':[], 'timeToWaitForScanServers':'120s','attemptPlans':[{'servers':'3', 'busyTimeout':'1s'}]}]";
        clientProps.put("scan.server.selector.impl", ConfigurableScanServerSelector.class.getName());
        clientProps.put("scan.server.selector.opts.profiles", scanServerSelectorProfiles.replace("'", "\""));
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(clientProps).build();){
            String tableName = this.getUniqueNames(1)[0];
            ScanServerIT.createTableAndIngest(client, tableName, null, 10, 10, "colf");
            Assertions.assertThrows(TimedOutException.class, () -> {
                try (BatchScanner scanner = client.createBatchScanner(tableName, Authorizations.EMPTY);){
                    scanner.setRanges(List.of(new Range()));
                    scanner.setTimeout(1L, TimeUnit.SECONDS);
                    scanner.setConsistencyLevel(ScannerBase.ConsistencyLevel.EVENTUAL);
                    Assertions.assertEquals((int)100, (int)Iterables.size((Iterable)scanner));
                }
            });
        }
    }

    private static class ScanServerITConfiguration
    implements MiniClusterConfigurationCallback {
        private ScanServerITConfiguration() {
        }

        @Override
        public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
            cfg.setNumScanServers(0);
            cfg.setProperty(Property.TSERV_SESSION_MAXIDLE, "3s");
            cfg.setProperty(Property.SSERV_SCAN_EXECUTORS_DEFAULT_THREADS, "1");
        }
    }
}

