/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.metadata.ScanServerRefTabletFile;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.util.ScanServerMetadataEntries;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="MiniClusterOnly")
public class ScanServerMetadataEntriesCleanIT
extends SharedMiniClusterBase {
    @BeforeAll
    public static void start() throws Exception {
        ScanServerMetadataEntriesCleanIT.startMiniCluster();
    }

    @AfterAll
    public static void stop() throws Exception {
        ScanServerMetadataEntriesCleanIT.stopMiniCluster();
    }

    @Test
    public void testServerContextMethods() {
        HostAndPort server = HostAndPort.fromParts((String)"127.0.0.1", (int)1234);
        UUID serverLockUUID = UUID.randomUUID();
        Set scanRefs = Stream.of("F0000070.rf", "F0000071.rf").map(f -> "hdfs://localhost:8020/accumulo/tables/2a/default_tablet/" + f).map(f -> new ScanServerRefTabletFile(serverLockUUID, server.toString(), f)).collect(Collectors.toSet());
        ServerContext ctx = ScanServerMetadataEntriesCleanIT.getCluster().getServerContext();
        ctx.getAmple().putScanServerFileReferences(scanRefs);
        Assertions.assertEquals((long)scanRefs.size(), (long)ctx.getAmple().getScanServerFileReferences().count());
        Set scanRefs2 = ctx.getAmple().getScanServerFileReferences().collect(Collectors.toSet());
        Assertions.assertEquals(scanRefs, scanRefs2);
        ScanServerMetadataEntries.clean((ServerContext)ctx);
        Assertions.assertFalse((boolean)ctx.getAmple().getScanServerFileReferences().findAny().isPresent());
    }

    @Test
    public void testOldScanServerRefs() {
        HostAndPort server = HostAndPort.fromParts((String)"127.0.0.1", (int)1234);
        UUID serverLockUUID = UUID.randomUUID();
        Set scanRefs = Stream.of("F0001270.rf", "F0001271.rf").map(f -> "hdfs://localhost:8020/accumulo/tables/2a/test_tablet/" + f).map(f -> new ScanServerRefTabletFile(serverLockUUID, server.toString(), f)).collect(Collectors.toSet());
        ServerContext ctx = ScanServerMetadataEntriesCleanIT.getCluster().getServerContext();
        ctx.getAmple().putScanServerFileReferences(scanRefs);
        Assertions.assertEquals((long)scanRefs.size(), (long)ctx.getAmple().getScanServerFileReferences().count());
        try (BatchWriter writer = ctx.createBatchWriter(Ample.DataLevel.USER.metaTable());){
            String prefix = MetadataSchema.OldScanServerFileReferenceSection.getRowPrefix();
            for (String filepath : Stream.of("F0001243.rf", "F0006512.rf").map(f -> "hdfs://localhost:8020/accumulo/tables/2a/test_tablet/" + f).collect(Collectors.toSet())) {
                Mutation m = new Mutation((CharSequence)(prefix + filepath));
                m.put((CharSequence)server.toString(), (CharSequence)serverLockUUID.toString(), (CharSequence)"");
                writer.addMutation(m);
            }
            writer.flush();
        }
        catch (MutationsRejectedException | TableNotFoundException e) {
            throw new IllegalStateException("Error inserting scan server file references into " + Ample.DataLevel.USER.metaTable(), e);
        }
        Assertions.assertEquals((long)(scanRefs.size() + 2), (long)ctx.getAmple().getScanServerFileReferences().count());
        ctx.getAmple().deleteScanServerFileReferences((Collection)ctx.getAmple().getScanServerFileReferences().collect(Collectors.toSet()));
        Assertions.assertEquals((long)0L, (long)ctx.getAmple().getScanServerFileReferences().count());
    }
}

