/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.gc.Reference;
import org.apache.accumulo.core.metadata.ScanServerRefTabletFile;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.gc.GCRun;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.test.ScanServerIT;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="MiniClusterOnly")
public class ScanServerMetadataEntriesIT
extends SharedMiniClusterBase {
    public static final Logger log = LoggerFactory.getLogger(ScanServerMetadataEntriesIT.class);

    @BeforeAll
    public static void start() throws Exception {
        ScanServerMetadataEntriesITConfiguration c = new ScanServerMetadataEntriesITConfiguration();
        SharedMiniClusterBase.startMiniClusterWithConfig(c);
        SharedMiniClusterBase.getCluster().getClusterControl().start(ServerType.SCAN_SERVER, "localhost");
        String zooRoot = ScanServerMetadataEntriesIT.getCluster().getServerContext().getZooKeeperRoot();
        ZooReaderWriter zrw = ScanServerMetadataEntriesIT.getCluster().getServerContext().getZooReaderWriter();
        String scanServerRoot = zooRoot + "/sservers";
        while (zrw.getChildren(scanServerRoot).size() == 0) {
            Thread.sleep(500L);
        }
    }

    @AfterAll
    public static void stop() throws Exception {
        ScanServerMetadataEntriesIT.stopMiniCluster();
    }

    @Test
    public void testServerContextMethods() {
        HostAndPort server = HostAndPort.fromParts((String)"127.0.0.1", (int)1234);
        UUID serverLockUUID = UUID.randomUUID();
        Set scanRefs = Stream.of("F0000070.rf", "F0000071.rf").map(f -> "hdfs://localhost:8020/accumulo/tables/2a/default_tablet/" + f).map(f -> new ScanServerRefTabletFile(serverLockUUID, server.toString(), f)).collect(Collectors.toSet());
        ServerContext ctx = ScanServerMetadataEntriesIT.getCluster().getServerContext();
        ctx.getAmple().putScanServerFileReferences(scanRefs);
        Assertions.assertEquals((long)scanRefs.size(), (long)ctx.getAmple().getScanServerFileReferences().count());
        Set scanRefs2 = ctx.getAmple().getScanServerFileReferences().collect(Collectors.toSet());
        Assertions.assertEquals(scanRefs, scanRefs2);
        ctx.getAmple().deleteScanServerFileReferences(server.toString(), serverLockUUID);
        Assertions.assertFalse((boolean)ctx.getAmple().getScanServerFileReferences().findAny().isPresent());
        ctx.getAmple().putScanServerFileReferences(scanRefs);
        Assertions.assertEquals((long)scanRefs.size(), (long)ctx.getAmple().getScanServerFileReferences().count());
        ctx.getAmple().deleteScanServerFileReferences(scanRefs);
        Assertions.assertFalse((boolean)ctx.getAmple().getScanServerFileReferences().findAny().isPresent());
    }

    @Test
    public void testScanServerMetadataEntries() throws Exception {
        ServerContext ctx = ScanServerMetadataEntriesIT.getCluster().getServerContext();
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ScanServerMetadataEntriesIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            int fileCount = 3;
            for (int i = 0; i < 3; ++i) {
                ScanServerIT.ingest(client, tableName, 10, 10, 0, "colf", true);
            }
            try (Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);){
                scanner.setRange(new Range());
                scanner.setConsistencyLevel(ScannerBase.ConsistencyLevel.EVENTUAL);
                scanner.setBatchSize(10);
                Iterator iter = scanner.iterator();
                Assertions.assertTrue((boolean)iter.hasNext());
                Assertions.assertNotNull(iter.next());
                Assertions.assertEquals((long)3L, (long)ctx.getAmple().getScanServerFileReferences().count());
            }
            while (ctx.getAmple().getScanServerFileReferences().findAny().isPresent()) {
                Thread.sleep(1000L);
            }
        }
    }

    @Test
    public void testBatchScanServerMetadataEntries() throws Exception {
        ServerContext ctx = ScanServerMetadataEntriesIT.getCluster().getServerContext();
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ScanServerMetadataEntriesIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            int fileCount = 3;
            for (int i = 0; i < 3; ++i) {
                ScanServerIT.ingest(client, tableName, 10, 10, 0, "colf", true);
            }
            try (BatchScanner scanner = client.createBatchScanner(tableName, Authorizations.EMPTY);){
                scanner.setRanges(Collections.singletonList(new Range()));
                scanner.setConsistencyLevel(ScannerBase.ConsistencyLevel.EVENTUAL);
                Iterator iter = scanner.iterator();
                Assertions.assertTrue((boolean)iter.hasNext());
                Assertions.assertNotNull(iter.next());
                Assertions.assertEquals((long)3L, (long)ctx.getAmple().getScanServerFileReferences().count());
            }
            while (ctx.getAmple().getScanServerFileReferences().findAny().isPresent()) {
                Thread.sleep(1000L);
            }
        }
    }

    @Test
    public void testGcRunScanServerReferences() throws Exception {
        ServerContext ctx = ScanServerMetadataEntriesIT.getCluster().getServerContext();
        GCRun gc = new GCRun(Ample.DataLevel.USER, ctx);
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ScanServerMetadataEntriesIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            TableId tid = TableId.of((String)((String)ctx.tableOperations().tableIdMap().get(tableName)));
            int fileCount = 3;
            for (int i = 0; i < 3; ++i) {
                ScanServerIT.ingest(client, tableName, 10, 10, 0, "colf", true);
            }
            try (Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);){
                scanner.setRange(new Range());
                scanner.setConsistencyLevel(ScannerBase.ConsistencyLevel.EVENTUAL);
                scanner.setBatchSize(10);
                Iterator iter = scanner.iterator();
                Assertions.assertTrue((boolean)iter.hasNext());
                Assertions.assertNotNull(iter.next());
                List<Map.Entry> metadataEntries = null;
                try (Scanner scanner2 = client.createScanner("accumulo.metadata", Authorizations.EMPTY);){
                    scanner2.setRange(MetadataSchema.ScanServerFileReferenceSection.getRange());
                    metadataEntries = scanner2.stream().distinct().collect(Collectors.toList());
                }
                Assertions.assertEquals((int)3, (int)metadataEntries.size());
                metadataEntries.forEach(e -> log.info("{}", e.getKey()));
                HashSet metadataScanFileRefs = new HashSet();
                metadataEntries.forEach(m -> {
                    String row = ((Key)m.getKey()).getRow().toString();
                    Assertions.assertTrue((boolean)row.startsWith(MetadataSchema.ScanServerFileReferenceSection.getRowPrefix()));
                    String file = ((Key)m.getKey()).getColumnQualifier().toString();
                    metadataScanFileRefs.add(file);
                });
                Assertions.assertEquals((int)3, (int)metadataScanFileRefs.size());
                Assertions.assertEquals((long)3L, (long)ctx.getAmple().getScanServerFileReferences().count());
                List refs = gc.getReferences().collect(Collectors.toList());
                Assertions.assertTrue((refs.size() > 6 ? 1 : 0) != 0);
                List tableRefs = refs.stream().filter(r -> r.getTableId().equals((Object)tid) && !r.isDirectory()).peek(r -> Assertions.assertTrue((boolean)metadataScanFileRefs.contains(r.getMetadataEntry()))).collect(Collectors.toList());
                log.info("Reference List:{}", tableRefs);
                Assertions.assertEquals((int)6, (int)tableRefs.size());
                Set deduplicatedReferences = tableRefs.stream().map(Reference::getMetadataEntry).collect(Collectors.toSet());
                Assertions.assertEquals((int)3, (int)deduplicatedReferences.size());
            }
            client.tableOperations().delete(tableName);
        }
        while (ctx.getAmple().getScanServerFileReferences().findAny().isPresent()) {
            Thread.sleep(1000L);
        }
    }

    private static class ScanServerMetadataEntriesITConfiguration
    implements MiniClusterConfigurationCallback {
        private ScanServerMetadataEntriesITConfiguration() {
        }

        @Override
        public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
            cfg.setNumScanServers(1);
            cfg.setProperty(Property.TSERV_SESSION_MAXIDLE, "3s");
            cfg.setProperty(Property.SSERV_SCAN_REFERENCE_EXPIRATION_TIME, "5s");
        }
    }
}

