/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.Collections;
import java.util.Iterator;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.test.ScanServerIT;
import org.apache.accumulo.test.SelfStoppingScanServer;
import org.apache.accumulo.test.util.Wait;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class ScanServerShutdownIT
extends SharedMiniClusterBase {
    @BeforeAll
    public static void start() throws Exception {
        ScanServerShutdownITConfiguration c = new ScanServerShutdownITConfiguration();
        SharedMiniClusterBase.startMiniClusterWithConfig(c);
    }

    @AfterAll
    public static void stop() throws Exception {
        SharedMiniClusterBase.stopMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRefRemovalOnShutdown() throws Exception {
        ServerContext ctx = ScanServerShutdownIT.getCluster().getServerContext();
        String zooRoot = ctx.getZooKeeperRoot();
        ZooReaderWriter zrw = ctx.getZooReaderWriter();
        String scanServerRoot = zooRoot + "/sservers";
        Wait.waitFor(() -> zrw.getChildren(scanServerRoot).size() == 0);
        ScanServerShutdownIT.getCluster().getClusterControl().startScanServer(SelfStoppingScanServer.class, 1, "default");
        Wait.waitFor(() -> zrw.getChildren(scanServerRoot).size() == 1);
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ScanServerShutdownIT.getClientProps()).build();){
            int i;
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            int fileCount = 3;
            for (i = 0; i < 3; ++i) {
                ScanServerIT.ingest(client, tableName, 10, 10, 0, "colf", true);
            }
            Assertions.assertEquals((long)0L, (long)ctx.getAmple().getScanServerFileReferences().count());
            for (i = 0; i < 3; ++i) {
                try (BatchScanner scanner = client.createBatchScanner(tableName, Authorizations.EMPTY);){
                    scanner.setRanges(Collections.singletonList(new Range()));
                    scanner.setConsistencyLevel(ScannerBase.ConsistencyLevel.EVENTUAL);
                    Iterator iter = scanner.iterator();
                    Assertions.assertTrue((boolean)iter.hasNext());
                    Assertions.assertNotNull(iter.next());
                    Assertions.assertEquals((long)3L, (long)ctx.getAmple().getScanServerFileReferences().count());
                    continue;
                }
            }
            Wait.waitFor(() -> ((ClientContext)client).getScanServers().size() == 0);
            Wait.waitFor(() -> ctx.getAmple().getScanServerFileReferences().count() == 0L);
        }
        finally {
            ScanServerShutdownIT.getCluster().getClusterControl().stopAllServers(ServerType.SCAN_SERVER);
        }
    }

    private static class ScanServerShutdownITConfiguration
    implements MiniClusterConfigurationCallback {
        private ScanServerShutdownITConfiguration() {
        }

        @Override
        public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
            cfg.setNumScanServers(1);
            cfg.setProperty(Property.TSERV_SESSION_MAXIDLE, "3s");
            cfg.setProperty(Property.SSERV_SCAN_EXECUTORS_DEFAULT_THREADS, "1");
        }
    }
}

