/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.accumulo.core.tabletserver.thrift.NoSuchScanIDException;
import org.apache.accumulo.core.tabletserver.thrift.TabletScanClientService;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.tserver.ScanServer;
import org.apache.accumulo.tserver.TabletHostingServer;
import org.apache.thrift.TException;

public class SelfStoppingScanServer
extends ScanServer
implements TabletScanClientService.Iface,
TabletHostingServer {
    private final AtomicInteger scanCount = new AtomicInteger(0);

    public SelfStoppingScanServer(ScanServer.ScanServerOpts opts, String[] args) {
        super(opts, args);
    }

    public void closeMultiScan(TInfo tinfo, long scanID) throws NoSuchScanIDException, TException {
        this.scanCount.incrementAndGet();
        super.closeMultiScan(tinfo, scanID);
        if (this.scanCount.get() == 3) {
            this.serverStopRequested = true;
        }
    }

    public static void main(String[] args) throws Exception {
        try (SelfStoppingScanServer tserver = new SelfStoppingScanServer(new ScanServer.ScanServerOpts(), args);){
            tserver.runServer();
        }
    }
}

