/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitRecoveryIT
extends AccumuloClusterHarness {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    private Mutation m(String row) {
        Mutation result = new Mutation((CharSequence)row);
        result.put((CharSequence)"cf", (CharSequence)"cq", new Value((CharSequence)"value"));
        return result;
    }

    boolean isOffline(String tablename, AccumuloClient client) throws TableNotFoundException {
        String tableId = (String)client.tableOperations().tableIdMap().get(tablename);
        try (Scanner scanner = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
            scanner.setRange(new Range(new Text(tableId + ";"), new Text(tableId + "<")));
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
            boolean bl = scanner.stream().findAny().isEmpty();
            return bl;
        }
    }

    @Test
    public void test() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(SplitRecoveryIT.getClientProps()).build();){
            for (int tn = 0; tn < 2; ++tn) {
                block35: {
                    client.tableOperations().create(tableName);
                    try (BatchWriter bw = client.createBatchWriter(tableName);){
                        bw.addMutation(this.m("a"));
                        bw.addMutation(this.m("b"));
                        bw.addMutation(this.m("c"));
                    }
                    client.tableOperations().offline(tableName);
                    while (!this.isOffline(tableName, client)) {
                        UtilWaitThread.sleepUninterruptibly((long)200L, (TimeUnit)TimeUnit.MILLISECONDS);
                    }
                    client.securityOperations().grantTablePermission(SplitRecoveryIT.getAdminPrincipal(), MetadataTable.NAME, TablePermission.WRITE);
                    TableId tableId = TableId.of((String)((String)client.tableOperations().tableIdMap().get(tableName)));
                    KeyExtent extent = new KeyExtent(tableId, null, new Text("b"));
                    Mutation m = MetadataSchema.TabletsSection.TabletColumnFamily.createPrevRowMutation((KeyExtent)extent);
                    MetadataSchema.TabletsSection.TabletColumnFamily.SPLIT_RATIO_COLUMN.put(m, new Value((CharSequence)Double.toString(0.5)));
                    MetadataSchema.TabletsSection.TabletColumnFamily.OLD_PREV_ROW_COLUMN.put(m, MetadataSchema.TabletsSection.TabletColumnFamily.encodePrevEndRow(null));
                    try (BatchWriter bw = client.createBatchWriter(MetadataTable.NAME);){
                        bw.addMutation(m);
                        if (tn != 1) break block35;
                        bw.flush();
                        try (Scanner scanner = client.createScanner(MetadataTable.NAME);){
                            scanner.setRange(extent.toMetaRange());
                            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                            KeyExtent extent2 = new KeyExtent(tableId, new Text("b"), null);
                            m = MetadataSchema.TabletsSection.TabletColumnFamily.createPrevRowMutation((KeyExtent)extent2);
                            MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(m, new Value((CharSequence)"t2"));
                            MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.put(m, new Value((CharSequence)"M0"));
                            for (Map.Entry entry : scanner) {
                                m.put(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, ((Key)entry.getKey()).getColumnQualifier(), (Value)entry.getValue());
                            }
                            bw.addMutation(m);
                        }
                    }
                }
                client.tableOperations().online(tableName);
                try (Scanner scanner = client.createScanner(tableName);){
                    int i = 0;
                    String[] expected = new String[]{"a", "b", "c"};
                    for (Map.Entry entry : scanner) {
                        Assertions.assertEquals((Object)expected[i], (Object)((Key)entry.getKey()).getRow().toString());
                        ++i;
                    }
                    Assertions.assertEquals((int)3, (int)i);
                    client.tableOperations().delete(tableName);
                    continue;
                }
            }
        }
    }
}

