/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.clientImpl.Namespace;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.harness.AccumuloITBase;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.NamespaceConfiguration;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableConfigurationUpdateIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(TableConfigurationUpdateIT.class);

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(TableConfigurationUpdateIT.getClientProps()).build();){
            ServerContext context = TableConfigurationUpdateIT.getCluster().getServerContext();
            String table = this.getUniqueNames(1)[0];
            client.tableOperations().create(table);
            NamespaceConfiguration defaultConf = new NamespaceConfiguration(context, Namespace.DEFAULT.id(), (AccumuloConfiguration)DefaultConfiguration.getInstance());
            int randomMax = 4;
            int numThreads = 2;
            int iterations = 100000;
            TableId tid = TableId.of((String)((String)client.tableOperations().tableIdMap().get(table)));
            TableConfiguration tableConf = new TableConfiguration(context, tid, defaultConf);
            long start = System.currentTimeMillis();
            ExecutorService svc = Executors.newFixedThreadPool(numThreads);
            CountDownLatch countDown = new CountDownLatch(numThreads);
            ArrayList<Future<Exception>> futures = new ArrayList<Future<Exception>>(numThreads);
            for (int i = 0; i < numThreads; ++i) {
                futures.add(svc.submit(new TableConfRunner(randomMax, iterations, (AccumuloConfiguration)tableConf, countDown)));
            }
            svc.shutdown();
            Assertions.assertTrue((boolean)svc.awaitTermination(60L, TimeUnit.MINUTES));
            for (Future future : futures) {
                Exception e = (Exception)future.get();
                if (e == null) continue;
                Assertions.fail((String)("Thread failed with exception " + e));
            }
            long end = System.currentTimeMillis();
            log.debug("{} with {} iterations and {} threads and cache invalidates {}% took {} second(s)", new Object[]{tableConf, iterations, numThreads, 1.0 / (double)randomMax * 100.0, (end - start) / 1000L});
        }
    }

    public static class TableConfRunner
    implements Callable<Exception> {
        private static final Property prop = Property.TABLE_SPLIT_THRESHOLD;
        private AccumuloConfiguration tableConf;
        private CountDownLatch countDown;
        private int iterations;
        private int randMax;

        public TableConfRunner(int randMax, int iterations, AccumuloConfiguration tableConf, CountDownLatch countDown) {
            this.randMax = randMax;
            this.iterations = iterations;
            this.tableConf = tableConf;
            this.countDown = countDown;
        }

        @Override
        public Exception call() {
            this.countDown.countDown();
            try {
                this.countDown.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return e;
            }
            String t = Thread.currentThread().getName() + " ";
            try {
                AccumuloITBase.random.ints(this.iterations, 0, this.randMax).forEach(choice -> {
                    if (choice < 1) {
                        this.tableConf.invalidateCache();
                    } else {
                        this.tableConf.get(prop);
                    }
                });
            }
            catch (Exception e) {
                log.error(t, (Throwable)e);
                return e;
            }
            return null;
        }
    }
}

