/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Sets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.DiskUsage;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.constraints.DefaultKeySizeConstraint;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.functional.BadIterator;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TableOperationsIT
extends AccumuloClusterHarness {
    private AccumuloClient accumuloClient;
    private static final int MAX_TABLE_NAME_LEN = 1024;
    static final KeyRowColFColQComparator COMPARE_KEY_TO_COLQ = new KeyRowColFColQComparator();

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofSeconds(90L);
    }

    @BeforeEach
    public void setup() {
        this.accumuloClient = (AccumuloClient)Accumulo.newClient().from(TableOperationsIT.getClientProps()).build();
    }

    @AfterEach
    public void checkForDanglingFateLocks() {
        if (TableOperationsIT.getClusterType() == AccumuloClusterHarness.ClusterType.MINI) {
            FunctionalTestUtils.assertNoDanglingFateLocks(TableOperationsIT.getCluster());
        }
        this.accumuloClient.close();
    }

    @Test
    public void getDiskUsageErrors() throws TableExistsException, AccumuloException, AccumuloSecurityException, TableNotFoundException {
        String tableName = this.getUniqueNames(1)[0];
        this.accumuloClient.tableOperations().create(tableName);
        List diskUsage = this.accumuloClient.tableOperations().getDiskUsage(Collections.singleton(tableName));
        Assertions.assertEquals((int)1, (int)diskUsage.size());
        Assertions.assertEquals((long)0L, (long)((DiskUsage)diskUsage.get(0)).getUsage());
        Assertions.assertEquals((Object)tableName, ((DiskUsage)diskUsage.get(0)).getTables().iterator().next());
        this.accumuloClient.securityOperations().revokeTablePermission(TableOperationsIT.getAdminPrincipal(), tableName, TablePermission.READ);
        Assertions.assertThrows(AccumuloSecurityException.class, () -> this.accumuloClient.tableOperations().getDiskUsage(Collections.singleton(tableName)));
        this.accumuloClient.tableOperations().delete(tableName);
        Assertions.assertThrows(TableNotFoundException.class, () -> this.accumuloClient.tableOperations().getDiskUsage(Collections.singleton(tableName)));
    }

    @Test
    public void getDiskUsage() throws TableExistsException, AccumuloException, AccumuloSecurityException, TableNotFoundException {
        String[] names = this.getUniqueNames(2);
        String tableName = names[0];
        this.accumuloClient.tableOperations().create(tableName);
        List diskUsages = this.accumuloClient.tableOperations().getDiskUsage(Collections.singleton(tableName));
        Assertions.assertEquals((int)1, (int)diskUsages.size());
        Assertions.assertEquals((int)1, (int)((DiskUsage)diskUsages.get(0)).getTables().size());
        Assertions.assertEquals((Long)0L, (long)((DiskUsage)diskUsages.get(0)).getUsage());
        Assertions.assertEquals((Object)tableName, ((DiskUsage)diskUsages.get(0)).getTables().first());
        try (BatchWriter bw = this.accumuloClient.createBatchWriter(tableName);){
            Mutation m = new Mutation((CharSequence)"a");
            m.put((CharSequence)"b", (CharSequence)"c", new Value((CharSequence)"abcde"));
            bw.addMutation(m);
            bw.flush();
        }
        this.accumuloClient.tableOperations().compact(tableName, new Text("A"), new Text("z"), true, true);
        diskUsages = this.accumuloClient.tableOperations().getDiskUsage(Collections.singleton(tableName));
        Assertions.assertEquals((int)1, (int)diskUsages.size());
        Assertions.assertEquals((int)1, (int)((DiskUsage)diskUsages.get(0)).getTables().size());
        Assertions.assertTrue((((DiskUsage)diskUsages.get(0)).getUsage() > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((Object)tableName, ((DiskUsage)diskUsages.get(0)).getTables().first());
        String newTable = names[1];
        this.accumuloClient.tableOperations().clone(tableName, newTable, false, null, null);
        HashSet<String> tables = new HashSet<String>();
        tables.add(tableName);
        tables.add(newTable);
        diskUsages = this.accumuloClient.tableOperations().getDiskUsage(tables);
        Assertions.assertEquals((int)1, (int)diskUsages.size());
        Assertions.assertEquals((int)2, (int)((DiskUsage)diskUsages.get(0)).getTables().size());
        Assertions.assertTrue((((DiskUsage)diskUsages.get(0)).getUsage() > 0L ? 1 : 0) != 0);
        this.accumuloClient.tableOperations().compact(tableName, new Text("A"), new Text("z"), true, true);
        this.accumuloClient.tableOperations().compact(newTable, new Text("A"), new Text("z"), true, true);
        diskUsages = this.accumuloClient.tableOperations().getDiskUsage(tables);
        Assertions.assertEquals((int)2, (int)diskUsages.size());
        Assertions.assertEquals((int)1, (int)((DiskUsage)diskUsages.get(0)).getTables().size());
        Assertions.assertEquals((int)1, (int)((DiskUsage)diskUsages.get(1)).getTables().size());
        Assertions.assertTrue((((DiskUsage)diskUsages.get(0)).getUsage() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((((DiskUsage)diskUsages.get(1)).getUsage() > 0L ? 1 : 0) != 0);
        this.accumuloClient.tableOperations().delete(tableName);
    }

    @Test
    public void createTable() throws TableExistsException, AccumuloException, AccumuloSecurityException, TableNotFoundException {
        String tableName = this.getUniqueNames(1)[0];
        this.accumuloClient.tableOperations().create(tableName);
        Map props = this.accumuloClient.tableOperations().getConfiguration(tableName);
        Assertions.assertEquals((Object)DefaultKeySizeConstraint.class.getName(), props.get(Property.TABLE_CONSTRAINT_PREFIX + "1"));
        this.accumuloClient.tableOperations().delete(tableName);
    }

    @Test
    public void createTableWithTableNameLengthLimit() throws AccumuloException, AccumuloSecurityException, TableExistsException {
        TableOperations tableOps = this.accumuloClient.tableOperations();
        String t0 = StringUtils.repeat((char)'a', (int)1023);
        tableOps.create(t0);
        Assertions.assertTrue((boolean)tableOps.exists(t0));
        String t1 = StringUtils.repeat((char)'b', (int)1024);
        tableOps.create(t1);
        Assertions.assertTrue((boolean)tableOps.exists(t1));
        String t2 = StringUtils.repeat((char)'c', (int)1025);
        Assertions.assertThrows(IllegalArgumentException.class, () -> tableOps.create(t2));
        Assertions.assertFalse((boolean)tableOps.exists(t2));
    }

    @Test
    public void createTableWithBadProperties() throws AccumuloException, AccumuloSecurityException, TableExistsException {
        TableOperations tableOps = this.accumuloClient.tableOperations();
        String t0 = this.getUniqueNames(1)[0];
        tableOps.create(t0);
        Assertions.assertTrue((boolean)tableOps.exists(t0));
        Assertions.assertThrows(AccumuloException.class, () -> tableOps.setProperty(t0, Property.TABLE_BLOOM_ENABLED.getKey(), "foo"));
    }

    @Test
    public void createMergeClonedTable() throws Exception {
        String[] names = this.getUniqueNames(2);
        String originalTable = names[0];
        TableOperations tops = this.accumuloClient.tableOperations();
        TreeSet splits = Sets.newTreeSet(Arrays.asList(new Text("a"), new Text("b"), new Text("c"), new Text("d")));
        tops.create(originalTable);
        tops.addSplits(originalTable, (SortedSet)splits);
        try (BatchWriter bw = this.accumuloClient.createBatchWriter(originalTable);){
            for (Text row : splits) {
                Mutation m = new Mutation(row);
                for (int i = 0; i < 10; ++i) {
                    for (int j = 0; j < 10; ++j) {
                        m.put((CharSequence)Integer.toString(i), (CharSequence)Integer.toString(j), (CharSequence)Integer.toString(i + j));
                    }
                }
                bw.addMutation(m);
            }
        }
        String clonedTable = names[1];
        tops.clone(originalTable, clonedTable, true, null, null);
        tops.merge(clonedTable, null, new Text("b"));
        HashMap<String, Integer> rowCounts = new HashMap<String, Integer>();
        try (Scanner s = this.accumuloClient.createScanner(clonedTable, new Authorizations());){
            for (Map.Entry entry : s) {
                Key key = (Key)entry.getKey();
                String row = key.getRow().toString();
                String cf = key.getColumnFamily().toString();
                String cq = key.getColumnQualifier().toString();
                String value = ((Value)entry.getValue()).toString();
                if (rowCounts.containsKey(row)) {
                    rowCounts.put(row, (Integer)rowCounts.get(row) + 1);
                } else {
                    rowCounts.put(row, 1);
                }
                Assertions.assertEquals((int)(Integer.parseInt(cf) + Integer.parseInt(cq)), (int)Integer.parseInt(value));
            }
        }
        Collection clonedSplits = tops.listSplits(clonedTable);
        HashSet expectedSplits = Sets.newHashSet((Object[])new Text[]{new Text("b"), new Text("c"), new Text("d")});
        for (Text clonedSplit : clonedSplits) {
            Assertions.assertTrue((boolean)expectedSplits.remove(clonedSplit), (String)("Encountered unexpected split on the cloned table: " + clonedSplit));
        }
        Assertions.assertTrue((boolean)expectedSplits.isEmpty(), (String)("Did not find all expected splits on the cloned table: " + expectedSplits));
    }

    @Test
    public void testCompactEmptyTablesWithBadIterator_FailsAndCancel() throws TableExistsException, AccumuloException, AccumuloSecurityException, TableNotFoundException {
        String tableName = this.getUniqueNames(1)[0];
        this.accumuloClient.tableOperations().create(tableName);
        ArrayList<IteratorSetting> list = new ArrayList<IteratorSetting>();
        list.add(new IteratorSetting(15, BadIterator.class));
        this.accumuloClient.tableOperations().compact(tableName, null, null, list, true, false);
        UtilWaitThread.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
        this.accumuloClient.tableOperations().cancelCompaction(tableName);
        try (Scanner scanner = this.accumuloClient.createScanner(tableName, Authorizations.EMPTY);){
            TreeMap<Key, Value> actual = new TreeMap<Key, Value>();
            for (Map.Entry entry : scanner) {
                actual.put((Key)entry.getKey(), (Value)entry.getValue());
            }
            Assertions.assertTrue((boolean)actual.isEmpty(), (String)("Should be empty. Actual is " + actual));
            this.accumuloClient.tableOperations().delete(tableName);
        }
    }

    @Test
    public void getTimeTypeTest() throws TableNotFoundException, AccumuloException, TableExistsException, AccumuloSecurityException {
        String[] tableNames = this.getUniqueNames(5);
        this.accumuloClient.tableOperations().create(tableNames[0]);
        TimeType timeType = this.accumuloClient.tableOperations().getTimeType(tableNames[0]);
        Assertions.assertEquals((Object)TimeType.MILLIS, (Object)timeType);
        NewTableConfiguration ntc = new NewTableConfiguration();
        ntc.setTimeType(TimeType.MILLIS);
        this.accumuloClient.tableOperations().create(tableNames[1], ntc);
        timeType = this.accumuloClient.tableOperations().getTimeType(tableNames[1]);
        Assertions.assertEquals((Object)TimeType.MILLIS, (Object)timeType);
        ntc = new NewTableConfiguration();
        ntc.setTimeType(TimeType.LOGICAL);
        this.accumuloClient.tableOperations().create(tableNames[2], ntc);
        timeType = this.accumuloClient.tableOperations().getTimeType(tableNames[2]);
        Assertions.assertEquals((Object)TimeType.LOGICAL, (Object)timeType);
        TreeSet<Text> splits = new TreeSet<Text>();
        splits.add(new Text("F"));
        splits.add(new Text("M"));
        splits.add(new Text("S"));
        ntc = new NewTableConfiguration();
        ntc.withSplits(splits);
        this.accumuloClient.tableOperations().create(tableNames[3], ntc);
        timeType = this.accumuloClient.tableOperations().getTimeType(tableNames[3]);
        Assertions.assertEquals((Object)TimeType.MILLIS, (Object)timeType);
        ntc = new NewTableConfiguration();
        ntc.setTimeType(TimeType.LOGICAL).withSplits(splits);
        this.accumuloClient.tableOperations().create(tableNames[4], ntc);
        timeType = this.accumuloClient.tableOperations().getTimeType(tableNames[4]);
        Assertions.assertEquals((Object)TimeType.LOGICAL, (Object)timeType);
        timeType = this.accumuloClient.tableOperations().getTimeType("accumulo.metadata");
        Assertions.assertEquals((Object)TimeType.LOGICAL, (Object)timeType);
        timeType = this.accumuloClient.tableOperations().getTimeType("accumulo.replication");
        Assertions.assertEquals((Object)TimeType.LOGICAL, (Object)timeType);
        timeType = this.accumuloClient.tableOperations().getTimeType("accumulo.root");
        Assertions.assertEquals((Object)TimeType.LOGICAL, (Object)timeType);
        Assertions.assertThrows(TableNotFoundException.class, () -> this.accumuloClient.tableOperations().getTimeType("notatable"), (String)"specified table does not exist");
    }

    static class KeyRowColFColQComparator
    implements Comparator<Key> {
        KeyRowColFColQComparator() {
        }

        @Override
        public int compare(Key k1, Key k2) {
            return k1.compareTo(k2, PartialKey.ROW_COLFAM_COLQUAL);
        }
    }
}

