/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.beust.jcommander.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.hadoop.io.Text;

public class TestMultiTableIngest {
    private static void readBack(Opts opts, AccumuloClient client, List<String> tableNames) throws Exception {
        int i = 0;
        for (String table : tableNames) {
            while (!client.tableOperations().exists(table)) {
                UtilWaitThread.sleep((long)100L);
            }
            Scanner scanner = client.createScanner(table, opts.auths);
            try {
                int count = i;
                for (Map.Entry elt : scanner) {
                    String expected = String.format("%06d", count);
                    if (!((Key)elt.getKey()).getRow().toString().equals(expected)) {
                        throw new RuntimeException("entry " + elt + " does not match expected " + expected + " in table " + table);
                    }
                    count += tableNames.size();
                }
                ++i;
            }
            finally {
                if (scanner == null) continue;
                scanner.close();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        ArrayList<String> tableNames = new ArrayList<String>();
        Opts opts = new Opts();
        opts.parseArgs(TestMultiTableIngest.class.getName(), args, new Object[0]);
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(opts.getClientProps()).build();){
            for (int i = 0; i < opts.tables; ++i) {
                tableNames.add(String.format(opts.prefix + "%04d", i));
            }
            if (!opts.readonly) {
                MultiTableBatchWriter b;
                for (String table : tableNames) {
                    client.tableOperations().create(table);
                }
                try {
                    b = client.createMultiTableBatchWriter();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                for (int i = 0; i < opts.count; ++i) {
                    Mutation m = new Mutation(new Text(String.format("%06d", i)));
                    m.put((CharSequence)("col" + (i % 3 + 1)), (CharSequence)"qual", (CharSequence)"junk");
                    b.getBatchWriter(tableNames.get(i % tableNames.size())).addMutation(m);
                }
                try {
                    b.close();
                }
                catch (MutationsRejectedException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                TestMultiTableIngest.readBack(opts, client, tableNames);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class Opts
    extends ClientOpts {
        @Parameter(names={"--readonly"}, description="read only")
        boolean readonly = false;
        @Parameter(names={"--tables"}, description="number of tables to create")
        int tables = 5;
        @Parameter(names={"--count"}, description="number of entries to create")
        int count = 10000;
        @Parameter(names={"--tablePrefix"}, description="prefix of the table names")
        String prefix = "test_";

        Opts() {
        }
    }
}

