/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.beust.jcommander.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRandomDeletes {
    private static final Logger log = LoggerFactory.getLogger(TestRandomDeletes.class);
    private static Authorizations auths = new Authorizations(new String[]{"L1", "L2", "G1", "GROUP2"});

    private static TreeSet<RowColumn> scanAll(TestOpts opts) throws Exception {
        TreeSet<RowColumn> result = new TreeSet<RowColumn>();
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(opts.getClientProps()).build();
             Scanner scanner = client.createScanner(opts.tableName, auths);){
            for (Map.Entry entry : scanner) {
                Key key = (Key)entry.getKey();
                Column column = new Column(TextUtil.getBytes((Text)key.getColumnFamily()), TextUtil.getBytes((Text)key.getColumnQualifier()), TextUtil.getBytes((Text)key.getColumnVisibility()));
                result.add(new RowColumn(key.getRow(), column, key.getTimestamp()));
            }
        }
        return result;
    }

    private static long scrambleDeleteHalfAndCheck(TestOpts opts, Set<RowColumn> rows) throws Exception {
        int result = 0;
        ArrayList<RowColumn> entries = new ArrayList<RowColumn>(rows);
        Collections.shuffle(entries);
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(opts.getClientProps()).build();
             BatchWriter bw = client.createBatchWriter(opts.tableName);){
            for (int i = 0; i < (entries.size() + 1) / 2; ++i) {
                RowColumn rc = entries.get(i);
                Mutation m = new Mutation(rc.row);
                m.putDelete(new Text(rc.column.columnFamily), new Text(rc.column.columnQualifier), new ColumnVisibility(rc.column.getColumnVisibility()), rc.timestamp + 1L);
                bw.addMutation(m);
                rows.remove(rc);
                ++result;
            }
        }
        TreeSet<RowColumn> current = TestRandomDeletes.scanAll(opts);
        current.removeAll(rows);
        if (!current.isEmpty()) {
            throw new RuntimeException(current.size() + " records not deleted");
        }
        return result;
    }

    public static void main(String[] args) {
        TestOpts opts = new TestOpts();
        opts.parseArgs(TestRandomDeletes.class.getName(), args, new Object[0]);
        log.info("starting random delete test");
        try {
            long half;
            long deleted = 0L;
            TreeSet<RowColumn> doomed = TestRandomDeletes.scanAll(opts);
            log.info("Got {} rows", (Object)doomed.size());
            long startTime = System.currentTimeMillis();
            do {
                half = TestRandomDeletes.scrambleDeleteHalfAndCheck(opts, doomed);
                deleted += half;
            } while (half != 0L);
            long stopTime = System.currentTimeMillis();
            long elapsed = (stopTime - startTime) / 1000L;
            log.info("deleted {} values in {} seconds", (Object)deleted, (Object)elapsed);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static class TestOpts
    extends ClientOpts {
        @Parameter(names={"--table"}, description="table to use")
        String tableName = "test_ingest";

        TestOpts() {
        }
    }

    private static class RowColumn
    implements Comparable<RowColumn> {
        Text row;
        Column column;
        long timestamp;

        public RowColumn(Text row, Column column, long timestamp) {
            this.row = row;
            this.column = column;
            this.timestamp = timestamp;
        }

        public int hashCode() {
            return Objects.hashCode(this.row) + Objects.hashCode(this.column);
        }

        public boolean equals(Object obj) {
            return this == obj || obj != null && obj instanceof RowColumn && this.compareTo((RowColumn)obj) == 0;
        }

        @Override
        public int compareTo(RowColumn other) {
            int result = this.row.compareTo((BinaryComparable)other.row);
            if (result != 0) {
                return result;
            }
            return this.column.compareTo(other.column);
        }

        public String toString() {
            return this.row + ":" + this.column;
        }
    }
}

