/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.util.MonitorUtil;
import org.apache.accumulo.gc.SimpleGarbageCollector;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.server.util.PortUtils;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="MiniClusterOnly")
public class ThriftServerBindsBeforeZooKeeperLockIT
extends AccumuloClusterHarness {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftServerBindsBeforeZooKeeperLockIT.class);

    @Override
    public boolean canRunTest(AccumuloClusterHarness.ClusterType type) {
        return type == AccumuloClusterHarness.ClusterType.MINI;
    }

    @Test
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="url is not from user")
    public void testMonitorService() throws Exception {
        MiniAccumuloClusterImpl cluster = (MiniAccumuloClusterImpl)ThriftServerBindsBeforeZooKeeperLockIT.getCluster();
        Collection monitors = (Collection)cluster.getProcesses().get(ServerType.MONITOR);
        if (monitors == null || monitors.isEmpty()) {
            ThriftServerBindsBeforeZooKeeperLockIT.getClusterControl().start(ServerType.MONITOR, "localhost");
        }
        while (true) {
            try {
                MonitorUtil.getLocation((ClientContext)ThriftServerBindsBeforeZooKeeperLockIT.getServerContext());
            }
            catch (Exception e) {
                LOG.debug("Failed to find active monitor location, retrying", (Throwable)e);
                Thread.sleep(1000L);
                continue;
            }
            break;
        }
        LOG.debug("Found active monitor");
        int freePort = PortUtils.getRandomFreePort();
        String monitorUrl = "http://localhost:" + freePort;
        Process monitor = null;
        try {
            LOG.debug("Starting standby monitor on {}", (Object)freePort);
            monitor = this.startProcess(cluster, ServerType.MONITOR, freePort);
            while (true) {
                int responseCode;
                HttpURLConnection cnxn;
                block13: {
                    URL url = new URL(monitorUrl);
                    cnxn = (HttpURLConnection)url.openConnection();
                    responseCode = cnxn.getResponseCode();
                    if (responseCode != 200) break block13;
                    return;
                }
                try {
                    String errorText = FunctionalTestUtils.readAll(cnxn.getErrorStream());
                    LOG.debug("Unexpected responseCode and/or error text, will retry: '{}' '{}'", (Object)responseCode, (Object)errorText);
                }
                catch (Exception e) {
                    LOG.debug("Caught exception trying to fetch monitor info", (Throwable)e);
                }
                Thread.sleep(1000L);
                if (monitor.isAlive()) continue;
                freePort = PortUtils.getRandomFreePort();
                monitorUrl = "http://localhost:" + freePort;
                LOG.debug("Monitor died, restarting it listening on {}", (Object)freePort);
                monitor = this.startProcess(cluster, ServerType.MONITOR, freePort);
            }
        }
        finally {
            if (monitor != null) {
                monitor.destroyForcibly();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"}, justification="unencrypted socket is okay for testing")
    public void testManagerService() throws Exception {
        MiniAccumuloClusterImpl cluster = (MiniAccumuloClusterImpl)ThriftServerBindsBeforeZooKeeperLockIT.getCluster();
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ThriftServerBindsBeforeZooKeeperLockIT.getClientProps()).build();){
            InstanceId instanceID = client.instanceOperations().getInstanceId();
            while (true) {
                try {
                    List locks;
                    while ((locks = cluster.getServerContext().getZooReader().getChildren("/accumulo/" + instanceID + "/managers/lock")).isEmpty()) {
                    }
                }
                catch (Exception e) {
                    LOG.debug("Failed to find active manager location, retrying", (Throwable)e);
                    Thread.sleep(1000L);
                    continue;
                }
                break;
            }
            LOG.debug("Found active manager");
            int freePort = PortUtils.getRandomFreePort();
            Process manager = null;
            try {
                LOG.debug("Starting standby manager on {}", (Object)freePort);
                manager = this.startProcess(cluster, ServerType.MANAGER, freePort);
                while (true) {
                    try {
                        Socket s;
                        block24: {
                            s = new Socket("localhost", freePort);
                            try {
                                if (!s.isConnected()) break block24;
                            }
                            catch (Throwable throwable) {
                                try {
                                    s.close();
                                    throw throwable;
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            s.close();
                            return;
                        }
                        s.close();
                    }
                    catch (Exception e) {
                        LOG.debug("Caught exception trying to connect to Manager", (Throwable)e);
                    }
                    Thread.sleep(1000L);
                    if (manager.isAlive()) continue;
                    freePort = PortUtils.getRandomFreePort();
                    LOG.debug("Manager died, restarting it listening on {}", (Object)freePort);
                    manager = this.startProcess(cluster, ServerType.MANAGER, freePort);
                }
            }
            finally {
                if (manager != null) {
                    manager.destroyForcibly();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"}, justification="unencrypted socket is okay for testing")
    public void testGarbageCollectorPorts() throws Exception {
        MiniAccumuloClusterImpl cluster = (MiniAccumuloClusterImpl)ThriftServerBindsBeforeZooKeeperLockIT.getCluster();
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ThriftServerBindsBeforeZooKeeperLockIT.getClientProps()).build();){
            InstanceId instanceID = client.instanceOperations().getInstanceId();
            while (true) {
                try {
                    List locks;
                    while ((locks = cluster.getServerContext().getZooReader().getChildren("/accumulo/" + instanceID + "/gc/lock")).isEmpty()) {
                    }
                }
                catch (Exception e) {
                    LOG.debug("Failed to find active gc location, retrying", (Throwable)e);
                    Thread.sleep(1000L);
                    continue;
                }
                break;
            }
            LOG.debug("Found active gc");
            int freePort = PortUtils.getRandomFreePort();
            Process manager = null;
            try {
                LOG.debug("Starting standby gc on {}", (Object)freePort);
                manager = this.startProcess(cluster, ServerType.GARBAGE_COLLECTOR, freePort);
                while (true) {
                    try {
                        Socket s;
                        block24: {
                            s = new Socket("localhost", freePort);
                            try {
                                if (!s.isConnected()) break block24;
                            }
                            catch (Throwable throwable) {
                                try {
                                    s.close();
                                    throw throwable;
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            s.close();
                            return;
                        }
                        s.close();
                    }
                    catch (Exception e) {
                        LOG.debug("Caught exception trying to connect to GC", (Throwable)e);
                    }
                    Thread.sleep(1000L);
                    if (manager.isAlive()) continue;
                    freePort = PortUtils.getRandomFreePort();
                    LOG.debug("GC died, restarting it listening on {}", (Object)freePort);
                    manager = this.startProcess(cluster, ServerType.GARBAGE_COLLECTOR, freePort);
                }
            }
            finally {
                if (manager != null) {
                    manager.destroyForcibly();
                }
            }
        }
    }

    private Process startProcess(MiniAccumuloClusterImpl cluster, ServerType serverType, int port) throws IOException {
        Class<Monitor> service;
        Property property;
        switch (serverType) {
            case MONITOR: {
                property = Property.MONITOR_PORT;
                service = Monitor.class;
                break;
            }
            case MANAGER: {
                property = Property.MANAGER_CLIENTPORT;
                service = Manager.class;
                break;
            }
            case GARBAGE_COLLECTOR: {
                property = Property.GC_PORT;
                service = SimpleGarbageCollector.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Irrelevant server type for test");
            }
        }
        return cluster._exec(service, serverType, Map.of(property.getKey(), Integer.toString(port)), new String[0]).getProcess();
    }
}

