/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.ThriftTransportKey;
import org.apache.accumulo.core.clientImpl.ThriftTransportPool;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportCachingIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(TransportCachingIT.class);

    @Test
    public void testCachedTransport() throws InterruptedException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(TransportCachingIT.getClientProps()).build();){
            List tservers;
            while ((tservers = client.instanceOperations().getTabletServers()).isEmpty()) {
                Thread.sleep(50L);
            }
            ClientContext context = (ClientContext)client;
            long rpcTimeout = ConfigurationTypeHelper.getTimeInMillis((String)Property.GENERAL_RPC_TIMEOUT.getDefaultValue());
            List servers = tservers.stream().map(serverStr -> new ThriftTransportKey((ThriftClientTypes)ThriftClientTypes.CLIENT, HostAndPort.fromString((String)serverStr), rpcTimeout, context)).collect(Collectors.toList());
            ThriftTransportKey ttk = (ThriftTransportKey)servers.get(0);
            ThriftTransportPool pool = context.getTransportPool();
            TTransport first = this.getAnyTransport(ttk, pool, true);
            Assertions.assertNotNull((Object)first);
            pool.returnTransport(first);
            TTransport second = this.getAnyTransport(ttk, pool, true);
            Assertions.assertSame((Object)first, (Object)second, (String)"Expected the first and second to be the same instance");
            pool.returnTransport(second);
            TTransport third = this.getAnyTransport(ttk, pool, false);
            Assertions.assertNotSame((Object)second, (Object)third, (String)"Expected second and third transport to be different instances");
            TTransport fourth = this.getAnyTransport(ttk, pool, false);
            Assertions.assertNotSame((Object)third, (Object)fourth, (String)"Expected third and fourth transport to be different instances");
            pool.returnTransport(third);
            pool.returnTransport(fourth);
            TTransport fifth = this.getAnyTransport(ttk, pool, true);
            Assertions.assertSame((Object)fourth, (Object)fifth, (String)"Expected fourth and fifth transport to be the same instance");
            TTransport sixth = this.getAnyTransport(ttk, pool, true);
            Assertions.assertSame((Object)third, (Object)sixth, (String)"Expected third and sixth transport to be the same instance");
            TTransport seventh = this.getAnyTransport(ttk, pool, true);
            Assertions.assertSame((Object)second, (Object)seventh, (String)"Expected second and seventh transport to be the same instance");
            pool.returnTransport(fifth);
            pool.returnTransport(sixth);
            pool.returnTransport(seventh);
        }
    }

    private TTransport getAnyTransport(ThriftTransportKey ttk, ThriftTransportPool pool, boolean preferCached) {
        Pair cached;
        if (preferCached && (cached = pool.getAnyCachedTransport(ttk.getType())) != null) {
            return (TTransport)cached.getSecond();
        }
        try {
            return pool.getTransport(ttk.getType(), ttk.getServer(), ttk.getTimeout(), (ClientContext)TransportCachingIT.getServerContext(), preferCached);
        }
        catch (TTransportException e) {
            log.warn("Failed to obtain transport to {}", (Object)ttk.getServer());
            return null;
        }
    }
}

