/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.log.WalStateManager;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnusedWALIT
extends ConfigurableMacBase {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(4L);
    }

    @Override
    protected void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        long logSize = 0xA00000L;
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "5s");
        cfg.setProperty(Property.TSERV_WAL_MAX_SIZE, Long.toString(0xA00000L));
        cfg.setNumTservers(1);
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
        hadoopCoreSite.set("fs.namenode.fs-limits.min-block-size", Long.toString(0xA00000L));
    }

    @Test
    public void test() throws Exception {
        this.getCluster().getClusterControl().stop(ServerType.GARBAGE_COLLECTOR);
        String[] tableNames = this.getUniqueNames(2);
        String bigTable = tableNames[0];
        String lilTable = tableNames[1];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            c.tableOperations().create(bigTable);
            c.tableOperations().create(lilTable);
            ServerContext context = this.getServerContext();
            this.writeSomeData(c, bigTable, 0, 10, 0, 10);
            this.scanSomeData(c, bigTable, 0, 10, 0, 10);
            this.writeSomeData(c, lilTable, 0, 1, 0, 1);
            this.scanSomeData(c, lilTable, 0, 1, 0, 1);
            Assertions.assertEquals((int)2, (int)this.getWALCount(context));
            this.writeSomeData(c, bigTable, 0, 3000, 0, 1000);
            Assertions.assertEquals((int)3, (int)this.getWALCount(context));
            this.writeSomeData(c, lilTable, 1, 10, 0, 10);
            this.scanSomeData(c, lilTable, 1, 10, 0, 10);
            this.getCluster().getClusterControl().stop(ServerType.TABLET_SERVER);
            this.getCluster().getClusterControl().start(ServerType.TABLET_SERVER);
            try (Scanner scanner = c.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                scanner.forEach((k, v) -> {});
            }
            this.scanSomeData(c, lilTable, 0, 1, 0, 1);
            this.scanSomeData(c, lilTable, 1, 10, 0, 10);
        }
    }

    private void scanSomeData(AccumuloClient c, String table, int startRow, int rowCount, int startCol, int colCount) throws Exception {
        try (Scanner s = c.createScanner(table, Authorizations.EMPTY);){
            s.setRange(new Range((CharSequence)Integer.toHexString(startRow), (CharSequence)Integer.toHexString(startRow + rowCount)));
            int row = startRow;
            int col = startCol;
            for (Map.Entry entry : s) {
                Assertions.assertEquals((int)row, (int)Integer.parseInt(((Key)entry.getKey()).getRow().toString(), 16));
                Assertions.assertEquals((int)col++, (int)Integer.parseInt(((Key)entry.getKey()).getColumnQualifier().toString(), 16));
                if (col != startCol + colCount) continue;
                col = startCol;
                if (++row != startRow + rowCount) continue;
                break;
            }
            Assertions.assertEquals((int)row, (int)(startRow + rowCount));
        }
    }

    private int getWALCount(ServerContext context) throws Exception {
        WalStateManager wals = new WalStateManager(context);
        int result = 0;
        for (Map.Entry entry : wals.getAllMarkers().entrySet()) {
            result += ((List)entry.getValue()).size();
        }
        return result;
    }

    private void writeSomeData(AccumuloClient client, String table, int startRow, int rowCount, int startCol, int colCount) throws Exception {
        BatchWriterConfig config = new BatchWriterConfig();
        config.setMaxMemory(0xA00000L);
        BatchWriter bw = client.createBatchWriter(table, config);
        for (int r = startRow; r < startRow + rowCount; ++r) {
            Mutation m = new Mutation((CharSequence)Integer.toHexString(r));
            for (int c = startCol; c < startCol + colCount; ++c) {
                m.put((CharSequence)"", (CharSequence)Integer.toHexString(c), (CharSequence)"");
            }
            bw.addMutation(m);
        }
        bw.close();
    }
}

