/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.Set;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.admin.SecurityOperations;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UsersIT
extends AccumuloClusterHarness {
    @Test
    public void testCreateExistingUser() throws Exception {
        ClusterUser user0 = this.getUser(0);
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(UsersIT.getClientProps()).build();){
            SecurityOperations securityOperations = client.securityOperations();
            Set currentUsers = securityOperations.listLocalUsers();
            String user0Principal = user0.getPrincipal();
            if (!currentUsers.contains(user0Principal)) {
                PasswordToken token = null;
                if (!UsersIT.saslEnabled()) {
                    token = new PasswordToken((CharSequence)user0.getPassword());
                }
                securityOperations.createLocalUser(user0Principal, token);
            }
            PasswordToken badToken = new PasswordToken((CharSequence)"better_fail");
            AccumuloSecurityException ase = (AccumuloSecurityException)Assertions.assertThrows(AccumuloSecurityException.class, () -> securityOperations.createLocalUser(user0Principal, badToken), (String)"Creating a user that already exists should throw an exception");
            Assertions.assertSame((Object)SecurityErrorCode.USER_EXISTS, (Object)ase.getSecurityErrorCode(), (String)"Expected USER_EXISTS error");
            String msg = ase.getMessage();
            Assertions.assertTrue((boolean)msg.contains(user0Principal), (String)("Error message didn't contain principal: '" + msg + "'"));
        }
    }
}

