/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.beust.jcommander.Parameter;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.test.TestIngest;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyIngest {
    private static final Logger log = LoggerFactory.getLogger(VerifyIngest.class);

    public static int getRow(Key k) {
        return Integer.parseInt(k.getRow().toString().split("_")[1]);
    }

    public static int getCol(Key k) {
        return Integer.parseInt(k.getColumnQualifier().toString().split("_")[1]);
    }

    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(VerifyIngest.class.getName(), args, new Object[0]);
        Span span = TraceUtil.startSpan(VerifyIngest.class, (String)"main");
        try (Scope scope = span.makeCurrent();){
            span.setAttribute("cmdLine", Arrays.asList(args).toString());
            try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(opts.getClientProps()).build();){
                VerifyIngest.verifyIngest(client, opts.getVerifyParams());
            }
        }
        catch (Exception e) {
            TraceUtil.setException((Span)span, (Throwable)e, (boolean)true);
            throw e;
        }
        finally {
            span.end();
        }
    }

    public static void verifyIngest(AccumuloClient accumuloClient, VerifyParams params) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        byte[][] bytevals = TestIngest.generateValues(params.dataSize);
        Authorizations labelAuths = new Authorizations(new String[]{"L1", "L2", "G1", "GROUP2"});
        String principal = ClientProperty.AUTH_PRINCIPAL.getValue(params.clientProps);
        accumuloClient.securityOperations().changeUserAuthorizations(principal, labelAuths);
        int expectedRow = params.startRow;
        int expectedCol = 0;
        int recsRead = 0;
        long bytesRead = 0L;
        long t1 = System.currentTimeMillis();
        byte[] randomValue = new byte[params.dataSize];
        Key endKey = new Key(new Text("row_" + String.format("%010d", params.rows + params.startRow)));
        int errors = 0;
        while (expectedRow < params.rows + params.startRow) {
            if (params.useGet) {
                Text rowKey = new Text("row_" + String.format("%010d", expectedRow + params.startRow));
                Text colf = new Text(params.columnFamily);
                Text colq = new Text("col_" + String.format("%07d", expectedCol));
                Scanner scanner = accumuloClient.createScanner("test_ingest", labelAuths);
                try {
                    scanner.setBatchSize(1);
                    Key startKey = new Key(rowKey, colf, colq);
                    Range range = new Range(startKey, startKey.followingKey(PartialKey.ROW_COLFAM_COLQUAL));
                    scanner.setRange(range);
                    byte[] val = null;
                    Iterator iter = scanner.iterator();
                    if (iter.hasNext()) {
                        val = ((Value)((Map.Entry)iter.next()).getValue()).get();
                    }
                    byte[] ev = params.random != null ? TestIngest.genRandomValue(randomValue, params.random, expectedRow, expectedCol) : bytevals[expectedCol % bytevals.length];
                    if (val == null) {
                        log.error("Did not find {} {} {}", new Object[]{rowKey, colf, colq});
                        ++errors;
                    } else {
                        ++recsRead;
                        bytesRead += (long)val.length;
                        Value value = new Value(val);
                        if (value.compareTo(ev) != 0) {
                            log.error("unexpected value  ({} {} {} : saw {} expected {}", new Object[]{rowKey, colf, colq, value, new Value(ev)});
                            ++errors;
                        }
                    }
                    if (++expectedCol < params.cols) continue;
                    expectedCol = 0;
                    ++expectedRow;
                    continue;
                }
                finally {
                    if (scanner != null) {
                        scanner.close();
                    }
                    continue;
                }
            }
            Key startKey = new Key(new Text("row_" + String.format("%010d", expectedRow)));
            Scanner scanner = accumuloClient.createScanner(params.tableName, labelAuths);
            try {
                scanner.setRange(new Range(startKey, endKey));
                for (int j = 0; j < params.cols; ++j) {
                    scanner.fetchColumn(new Text(params.columnFamily), new Text("col_" + String.format("%07d", j)));
                }
                int recsReadBefore = recsRead;
                for (Map.Entry entry : scanner) {
                    ++recsRead;
                    bytesRead += (long)((Key)entry.getKey()).getLength();
                    bytesRead += (long)((Value)entry.getValue()).getSize();
                    int rowNum = VerifyIngest.getRow((Key)entry.getKey());
                    int colNum = VerifyIngest.getCol((Key)entry.getKey());
                    if (rowNum != expectedRow) {
                        log.error("rowNum != expectedRow   {} != {}", (Object)rowNum, (Object)expectedRow);
                        ++errors;
                        expectedRow = rowNum;
                    }
                    if (colNum != expectedCol) {
                        log.error("colNum != expectedCol  {} != {}  rowNum : {}", new Object[]{colNum, expectedCol, rowNum});
                        ++errors;
                    }
                    if (expectedRow >= params.rows + params.startRow) {
                        log.error("expectedRow ({}) >= (ingestArgs.rows + ingestArgs.startRow)  ({}), get batch returned data passed end key", (Object)expectedRow, (Object)(params.rows + params.startRow));
                        ++errors;
                        break;
                    }
                    byte[] value = params.random != null ? TestIngest.genRandomValue(randomValue, params.random, expectedRow, colNum) : bytevals[colNum % bytevals.length];
                    if (((Value)entry.getValue()).compareTo(value) != 0) {
                        log.error("unexpected value, rowNum : {} colNum : {}", (Object)rowNum, (Object)colNum);
                        log.error(" saw = {} expected = {}", (Object)new String(((Value)entry.getValue()).get()), (Object)new String(value));
                        ++errors;
                    }
                    if (params.timestamp >= 0L && ((Key)entry.getKey()).getTimestamp() != params.timestamp) {
                        log.error("unexpected timestamp {}, rowNum : {} colNum : {}", new Object[]{((Key)entry.getKey()).getTimestamp(), rowNum, colNum});
                        ++errors;
                    }
                    if (++expectedCol < params.cols) continue;
                    expectedCol = 0;
                    ++expectedRow;
                }
                if (recsRead != recsReadBefore) continue;
                log.warn("Scan returned nothing, breaking...");
                break;
            }
            finally {
                if (scanner == null) continue;
                scanner.close();
            }
        }
        long t2 = System.currentTimeMillis();
        if (errors > 0) {
            throw new AccumuloException("saw " + errors + " errors ");
        }
        if (expectedRow != params.rows + params.startRow) {
            throw new AccumuloException("Did not read expected number of rows. Saw " + (expectedRow - params.startRow) + " expected " + params.rows);
        }
        System.out.printf("%,12d records read | %,8d records/sec | %,12d bytes read | %,8d bytes/sec | %6.3f secs   %n", recsRead, (int)((double)recsRead / ((double)(t2 - t1) / 1000.0)), bytesRead, (int)((double)bytesRead / ((double)(t2 - t1) / 1000.0)), (double)(t2 - t1) / 1000.0);
    }

    public static class Opts
    extends TestIngest.Opts {
        @Parameter(names={"-useGet"}, description="fetches values one at a time, instead of scanning")
        public boolean useGet = false;

        public VerifyParams getVerifyParams() {
            VerifyParams params = new VerifyParams(this.getClientProps(), this.tableName);
            this.populateIngestPrams(params);
            params.useGet = this.useGet;
            return params;
        }
    }

    public static class VerifyParams
    extends TestIngest.IngestParams {
        public boolean useGet = false;

        public VerifyParams(Properties props) {
            super(props);
        }

        public VerifyParams(Properties props, String table) {
            super(props, table);
        }

        public VerifyParams(Properties props, String table, int rows) {
            super(props, table, rows);
        }
    }
}

