/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.time.Duration;
import java.util.Collection;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.miniclusterImpl.ProcessReference;
import org.apache.accumulo.server.util.Admin;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class VerifySerialRecoveryIT
extends ConfigurableMacBase {
    private static final byte[] HEXCHARS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public static byte[] randomHex(int n) {
        byte[] binary = new byte[n];
        byte[] hex = new byte[n * 2];
        random.nextBytes(binary);
        int count = 0;
        for (byte x : binary) {
            hex[count++] = HEXCHARS[x >> 4 & 0xF];
            hex[count++] = HEXCHARS[x & 0xF];
        }
        return hex;
    }

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(4L);
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setProperty(Property.TSERV_ASSIGNMENT_MAXCONCURRENT, "20");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Test
    public void testSerializedRecovery() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            TreeSet<Text> splits = new TreeSet<Text>();
            for (int i = 0; i < 200; ++i) {
                splits.add(new Text(VerifySerialRecoveryIT.randomHex(8)));
            }
            NewTableConfiguration ntc = new NewTableConfiguration().withSplits(splits);
            c.tableOperations().create(tableName, ntc);
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                for (int i = 0; i < 50000; ++i) {
                    String[] m = new Mutation(VerifySerialRecoveryIT.randomHex(8));
                    m.put((CharSequence)"", (CharSequence)"", (CharSequence)"");
                    bw.addMutation((Mutation)m);
                }
            }
            for (ProcessReference ref : (Collection)this.getCluster().getProcesses().get(ServerType.TABLET_SERVER)) {
                this.getCluster().killProcess(ServerType.TABLET_SERVER, ref);
            }
            MiniAccumuloClusterImpl.ProcessInfo ts = this.cluster.exec(TabletServer.class, new String[0]);
            try (Scanner scanner = c.createScanner(tableName, Authorizations.EMPTY);){
                scanner.forEach((k, v) -> {});
            }
            Assertions.assertEquals((int)0, (int)this.cluster.exec(Admin.class, new String[]{"stopAll"}).getProcess().waitFor());
            ts.getProcess().waitFor();
            String result = ts.readStdOut();
            for (String line : result.split("\n")) {
                System.out.println(line);
            }
            boolean started = false;
            int recoveries = 0;
            Pattern pattern = Pattern.compile(".*recovered \\d+ mutations creating \\d+ entries from \\d+ walogs.*");
            for (String line : result.split("\n")) {
                if (line.contains("!0") || line.contains("+r")) continue;
                if (line.contains("recovering data from walogs")) {
                    Assertions.assertFalse((boolean)started);
                    started = true;
                    ++recoveries;
                }
                if (!pattern.matcher(line).matches()) continue;
                Assertions.assertTrue((boolean)started);
                started = false;
            }
            Assertions.assertFalse((boolean)started);
            Assertions.assertTrue((recoveries > 0 ? 1 : 0) != 0);
        }
    }
}

